/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.references.ReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;

class EntryPointReferenceDB
extends ReferenceDB {
    public EntryPointReferenceDB(Address fromAddr, Address toAddr, RefType refType, int opIndex, SourceType sourceType, boolean isPrimary, long symbolID) {
        super(fromAddr, toAddr, refType, opIndex, sourceType, isPrimary, symbolID);
    }

    @Override
    public boolean isEntryPointReference() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference ref = (Reference)obj;
        return this.isEntryPointReference() && this.fromAddr.equals(ref.getFromAddress()) && this.toAddr.equals(ref.getToAddress()) && this.opIndex == ref.getOperandIndex() && this.symbolID == ref.getSymbolID() && this.isPrimary == ref.isPrimary() && this.sourceType == ref.getSource() && this.refType == ref.getReferenceType() && this.isShiftedReference() == ref.isShiftedReference() && this.isOffsetReference() == ref.isOffsetReference();
    }
}

