/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.util.UniversalID;
import java.util.HashMap;
import java.util.Map;

public class SourceArchiveUpgradeMap {
    private static final long OLD_CLIB_ARCHIVE_ID = 2585014296036210369L;
    private static final long OLD_WINDOWS_ARCHIVE_ID = 2592694847825635591L;
    private static final long OLD_NTDDK_ARCHIVE_ID = 2585014353215059675L;
    private static final long[] oldArchiveIds = new long[]{2585014296036210369L, 2585014353215059675L, 2592694847825635591L};
    private CompilerSpecID WINDOWS_CSPEC_ID = new CompilerSpecID("windows");
    private Map<UniversalID, SourceArchive> oldArchiveRemappings;

    public SourceArchiveUpgradeMap() {
        UniversalID NEW_WINDOWS_SUPER_ARCHIVE_ID = new UniversalID(2644092282468053077L);
        UniversalID NEW_DEFAULT_CLIB_ARCHIVE_ID = new UniversalID(2644097909188870631L);
        String NEW_WINDOWS_SUPER_ARCHIVE_NAME = "windows_vs12_32";
        String NEW_DEFAULT_CLIB_ARCHIVE_NAME = "generic_clib";
        SourceArchiveImpl newWindowsArchive = new SourceArchiveImpl(NEW_WINDOWS_SUPER_ARCHIVE_ID, NEW_WINDOWS_SUPER_ARCHIVE_NAME);
        SourceArchiveImpl newDefaultClibArchive = new SourceArchiveImpl(NEW_DEFAULT_CLIB_ARCHIVE_ID, NEW_DEFAULT_CLIB_ARCHIVE_NAME);
        this.oldArchiveRemappings = new HashMap<UniversalID, SourceArchive>();
        this.oldArchiveRemappings.put(new UniversalID(2585014296036210369L), newWindowsArchive);
        this.oldArchiveRemappings.put(new UniversalID(2592694847825635591L), newWindowsArchive);
        this.oldArchiveRemappings.put(new UniversalID(2585014353215059675L), newWindowsArchive);
        this.oldArchiveRemappings.put(new UniversalID(2585014296036210369L), newDefaultClibArchive);
        SourceArchiveImpl removedSourceArchive = new SourceArchiveImpl();
        this.oldArchiveRemappings.put(new UniversalID(2592694847825635591L), removedSourceArchive);
        this.oldArchiveRemappings.put(new UniversalID(2585014353215059675L), removedSourceArchive);
    }

    public SourceArchive getMappedSourceArchive(SourceArchive sourceArchive) {
        return this.oldArchiveRemappings.get(sourceArchive.getSourceArchiveID());
    }

    public static boolean isReplacedSourceArchive(long id) {
        for (long oldId : oldArchiveIds) {
            if (id != oldId) continue;
            return true;
        }
        return false;
    }

    public static String[] getTypedefReplacements() {
        return new String[]{"short", "int", "long", "longlong", "wchar_t", "bool"};
    }

    private static class SourceArchiveImpl
    implements SourceArchive {
        private final UniversalID id;
        private final String archiveName;

        public SourceArchiveImpl(UniversalID id, String archiveName) {
            this.id = id;
            this.archiveName = archiveName;
        }

        public SourceArchiveImpl() {
            this.id = DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
            this.archiveName = "";
        }

        @Override
        public ArchiveType getArchiveType() {
            return ArchiveType.FILE;
        }

        @Override
        public String getDomainFileID() {
            return null;
        }

        @Override
        public long getLastSyncTime() {
            return 0L;
        }

        @Override
        public String getName() {
            return this.archiveName;
        }

        @Override
        public UniversalID getSourceArchiveID() {
            return this.id;
        }

        @Override
        public boolean isDirty() {
            return false;
        }

        @Override
        public void setDirtyFlag(boolean dirty) {
        }

        @Override
        public void setLastSyncTime(long time) {
        }

        @Override
        public void setName(String name) {
        }
    }
}

