/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.code.InstDBAdapterV0;
import ghidra.program.database.code.InstDBAdapterV1;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class InstDBAdapter {
    static final String INSTRUCTION_TABLE_NAME = "Instructions";
    static final Schema INSTRUCTION_SCHEMA = new Schema(1, "Address", new Field[]{IntField.INSTANCE, ByteField.INSTANCE}, new String[]{"Proto ID", "Flags"});
    static final int PROTO_ID_COL = 0;
    static final int FLAGS_COL = 1;

    InstDBAdapter() {
    }

    static InstDBAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new InstDBAdapterV1(dbHandle, addrMap, true);
        }
        try {
            InstDBAdapterV1 adapter = new InstDBAdapterV1(dbHandle, addrMap, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            InstDBAdapter adapter = InstDBAdapter.findReadOnlyAdapter(dbHandle, addrMap);
            if (openMode == 3) {
                adapter = InstDBAdapter.upgrade(dbHandle, addrMap, adapter, monitor);
            }
            return adapter;
        }
    }

    private static InstDBAdapter findReadOnlyAdapter(DBHandle handle, AddressMap addrMap) throws VersionException, IOException {
        try {
            return new InstDBAdapterV1(handle, addrMap.getOldAddressMap(), false);
        }
        catch (VersionException versionException) {
            return new InstDBAdapterV0(handle, addrMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstDBAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, InstDBAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Instructions...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            InstDBAdapterV1 tmpAdapter = new InstDBAdapterV1(tmpHandle, addrMap, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getKey());
                rec.setKey(addrMap.getKey(addr, true));
                ((InstDBAdapter)tmpAdapter).putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(INSTRUCTION_TABLE_NAME);
            InstDBAdapterV1 newAdapter = new InstDBAdapterV1(dbHandle, addrMap, true);
            iter = ((InstDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = iter.next();
                ((InstDBAdapter)newAdapter).putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            InstDBAdapterV1 instDBAdapterV1 = newAdapter;
            return instDBAdapterV1;
        }
    }

    abstract void createInstruction(long var1, int var3, byte var4) throws IOException;

    abstract void updateFlags(long var1, byte var3) throws IOException;

    abstract void deleteRecord(long var1) throws IOException;

    abstract DBRecord getRecordAtOrAfter(Address var1) throws IOException;

    abstract DBRecord getRecordAfter(Address var1) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract DBRecord getRecord(Address var1) throws IOException;

    abstract DBRecord getRecordBefore(Address var1) throws IOException;

    abstract RecordIterator getRecords(Address var1, Address var2, boolean var3) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract int getRecordCount() throws IOException;

    abstract DBRecord getRecordAtOrBefore(Address var1) throws IOException;

    abstract AddressKeyIterator getKeys(Address var1, Address var2, boolean var3) throws IOException;

    abstract boolean deleteRecords(Address var1, Address var2) throws IOException;

    abstract void putRecord(DBRecord var1) throws IOException;

    abstract RecordIterator getRecords(Address var1, boolean var2) throws IOException;

    abstract AddressKeyIterator getKeys(AddressSetView var1, boolean var2) throws IOException;

    abstract RecordIterator getRecords(AddressSetView var1, boolean var2) throws IOException;

    abstract void moveAddressRange(Address var1, Address var2, long var3, TaskMonitor var5) throws CancelledException, IOException;

    abstract void deleteAll() throws IOException;
}

