/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.module.TreeManager;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.PropertyMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ListingDB
implements Listing {
    private ProgramDB program;
    private CodeManager codeMgr;
    private TreeManager treeMgr;
    private FunctionManager functionMgr;

    ListingDB() {
    }

    public void setProgram(ProgramDB program) {
        this.program = program;
        this.codeMgr = program.getCodeManager();
        this.treeMgr = program.getTreeManager();
        this.functionMgr = program.getFunctionManager();
    }

    @Override
    public CodeUnit getCodeUnitAt(Address addr) {
        return this.codeMgr.getCodeUnitAt(addr);
    }

    @Override
    public CodeUnit getCodeUnitContaining(Address addr) {
        return this.codeMgr.getCodeUnitContaining(addr);
    }

    @Override
    public CodeUnit getCodeUnitAfter(Address addr) {
        return this.codeMgr.getCodeUnitAfter(addr);
    }

    @Override
    public CodeUnit getCodeUnitBefore(Address addr) {
        return this.codeMgr.getCodeUnitBefore(addr);
    }

    @Override
    public CodeUnitIterator getCodeUnitIterator(String property, boolean forward) {
        return this.codeMgr.getCodeUnitIterator(property, this.program.getMinAddress(), forward);
    }

    @Override
    public CodeUnitIterator getCodeUnitIterator(String property, Address addr, boolean forward) {
        return this.codeMgr.getCodeUnitIterator(property, addr, forward);
    }

    @Override
    public CodeUnitIterator getCodeUnitIterator(String property, AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getCodeUnitIterator(property, addrSet, forward);
    }

    @Override
    public CodeUnitIterator getCodeUnits(boolean forward) {
        return this.codeMgr.getCodeUnits(this.program.getMemory(), forward);
    }

    @Override
    public CodeUnitIterator getCodeUnits(Address addr, boolean forward) {
        return this.codeMgr.getCodeUnits(addr, forward);
    }

    @Override
    public CodeUnitIterator getCodeUnits(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getCodeUnits(addrSet, forward);
    }

    @Override
    public Instruction getInstructionAt(Address addr) {
        return this.codeMgr.getInstructionAt(addr);
    }

    @Override
    public Instruction getInstructionContaining(Address addr) {
        return this.codeMgr.getInstructionContaining(addr, false);
    }

    @Override
    public Instruction getInstructionAfter(Address addr) {
        return this.codeMgr.getInstructionAfter(addr);
    }

    @Override
    public Instruction getInstructionBefore(Address addr) {
        return this.codeMgr.getInstructionBefore(addr);
    }

    @Override
    public InstructionIterator getInstructions(boolean forward) {
        return this.codeMgr.getInstructions(forward ? this.program.getMinAddress() : this.program.getMaxAddress(), forward);
    }

    @Override
    public InstructionIterator getInstructions(Address addr, boolean forward) {
        return this.codeMgr.getInstructions(addr, forward);
    }

    @Override
    public InstructionIterator getInstructions(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getInstructions(addrSet, forward);
    }

    @Override
    public Data getDataAt(Address addr) {
        return this.codeMgr.getDataAt(addr);
    }

    @Override
    public Data getDataContaining(Address addr) {
        return this.codeMgr.getDataContaining(addr);
    }

    @Override
    public Data getDataAfter(Address addr) {
        return this.codeMgr.getDataAfter(addr);
    }

    @Override
    public Data getDataBefore(Address addr) {
        return this.codeMgr.getDataBefore(addr);
    }

    @Override
    public DataIterator getData(boolean forward) {
        return this.codeMgr.getData(forward ? this.program.getMinAddress() : this.program.getMaxAddress(), forward);
    }

    @Override
    public DataIterator getData(Address addr, boolean forward) {
        return this.codeMgr.getData(addr, forward);
    }

    @Override
    public DataIterator getData(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getData(addrSet, forward);
    }

    @Override
    public Data getDefinedDataAt(Address addr) {
        return this.codeMgr.getDefinedDataAt(addr);
    }

    @Override
    public Data getDefinedDataContaining(Address addr) {
        return this.codeMgr.getDefinedDataContaining(addr);
    }

    @Override
    public Data getDefinedDataAfter(Address addr) {
        return this.codeMgr.getDefinedDataAfter(addr);
    }

    @Override
    public Data getDefinedDataBefore(Address addr) {
        return this.codeMgr.getDefinedDataBefore(addr);
    }

    @Override
    public DataIterator getDefinedData(boolean forward) {
        return this.codeMgr.getDefinedData(forward ? this.program.getMinAddress() : this.program.getMaxAddress(), forward);
    }

    @Override
    public DataIterator getDefinedData(Address addr, boolean forward) {
        return this.codeMgr.getDefinedData(addr, forward);
    }

    @Override
    public DataIterator getDefinedData(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getDefinedData(addrSet, forward);
    }

    @Override
    public Data getUndefinedDataAt(Address addr) {
        return this.codeMgr.getUndefinedAt(addr);
    }

    @Override
    public AddressSetView getUndefinedRanges(AddressSetView set, boolean initializedMemoryOnly, TaskMonitor monitor) throws CancelledException {
        return this.codeMgr.getUndefinedRanges(set, initializedMemoryOnly, monitor);
    }

    @Override
    public Data getUndefinedDataAfter(Address addr, TaskMonitor monitor) {
        return this.codeMgr.getFirstUndefinedDataAfter(addr, monitor);
    }

    @Override
    public Data getFirstUndefinedData(AddressSetView set, TaskMonitor monitor) {
        return this.codeMgr.getFirstUndefinedData(set, monitor);
    }

    @Override
    public Data getUndefinedDataBefore(Address addr, TaskMonitor monitor) {
        return this.codeMgr.getFirstUndefinedDataBefore(addr, monitor);
    }

    @Override
    public DataIterator getCompositeData(boolean forward) {
        return this.codeMgr.getCompositeData(forward ? this.program.getMinAddress() : this.program.getMaxAddress(), forward);
    }

    @Override
    public DataIterator getCompositeData(Address start, boolean forward) {
        return this.codeMgr.getCompositeData(start, forward);
    }

    @Override
    public DataIterator getCompositeData(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getCompositeData(addrSet, forward);
    }

    @Override
    public Iterator<String> getUserDefinedProperties() {
        return this.codeMgr.getUserDefinedProperties();
    }

    @Override
    public void removeUserDefinedProperty(String propertyName) {
        this.codeMgr.removeUserDefinedProperty(propertyName);
    }

    @Override
    public PropertyMap<?> getPropertyMap(String propertyName) {
        return this.codeMgr.getPropertyMap(propertyName);
    }

    @Override
    public Instruction createInstruction(Address addr, InstructionPrototype prototype, MemBuffer memBuf, ProcessorContextView context, int length) throws CodeUnitInsertionException {
        return this.codeMgr.createCodeUnit(addr, prototype, memBuf, context, length);
    }

    @Override
    public AddressSetView addInstructions(InstructionSet instructionSet, boolean overwrite) throws CodeUnitInsertionException {
        return this.codeMgr.addInstructions(instructionSet, overwrite);
    }

    @Override
    public Data createData(Address addr, DataType dataType) throws CodeUnitInsertionException {
        return this.codeMgr.createCodeUnit(addr, dataType, dataType.getLength());
    }

    @Override
    public Data createData(Address addr, DataType dataType, int length) throws CodeUnitInsertionException {
        return this.codeMgr.createCodeUnit(addr, dataType, length);
    }

    @Override
    public void clearCodeUnits(Address startAddr, Address endAddr, boolean clearContext) {
        try {
            this.codeMgr.clearCodeUnits(startAddr, endAddr, clearContext, TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    @Override
    public void clearCodeUnits(Address startAddr, Address endAddr, boolean clearContext, TaskMonitor monitor) throws CancelledException {
        this.codeMgr.clearCodeUnits(startAddr, endAddr, clearContext, monitor);
    }

    @Override
    public boolean isUndefined(Address start, Address end) {
        return this.codeMgr.isUndefined(start, end);
    }

    @Override
    public void clearComments(Address startAddr, Address endAddr) {
        this.codeMgr.clearComments(startAddr, endAddr);
    }

    @Override
    public void clearProperties(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.codeMgr.clearProperties(startAddr, endAddr, monitor);
    }

    @Override
    public void clearAll(boolean clearContext, TaskMonitor monitor) {
        this.codeMgr.clearAll(false, TaskMonitor.DUMMY);
    }

    @Override
    public long getNumCodeUnits() {
        return this.getNumDefinedData() + this.getNumInstructions();
    }

    @Override
    public long getNumDefinedData() {
        return this.codeMgr.getNumDefinedData();
    }

    @Override
    public long getNumInstructions() {
        return this.codeMgr.getNumInstructions();
    }

    @Override
    public ProgramFragment getFragment(String treeName, Address addr) {
        return this.treeMgr.getFragment(treeName, addr);
    }

    @Override
    public ProgramModule getModule(String treeName, String name) {
        return this.treeMgr.getModule(treeName, name);
    }

    @Override
    public ProgramFragment getFragment(String treeName, String name) {
        return this.treeMgr.getFragment(treeName, name);
    }

    @Override
    public ProgramModule createRootModule(String treeName) throws DuplicateNameException {
        return this.treeMgr.createRootModule(treeName);
    }

    @Override
    public ProgramModule getRootModule(String treeName) {
        return this.treeMgr.getRootModule(treeName);
    }

    @Override
    public ProgramModule getRootModule(long treeID) {
        return this.treeMgr.getRootModule(treeID);
    }

    @Override
    public ProgramModule getDefaultRootModule() {
        return this.treeMgr.getDefaultRootModule();
    }

    @Override
    public String[] getTreeNames() {
        return this.treeMgr.getTreeNames();
    }

    @Override
    public boolean removeTree(String treeName) {
        return this.treeMgr.removeTree(treeName);
    }

    @Override
    public void renameTree(String oldName, String newName) throws DuplicateNameException {
        this.treeMgr.renameTree(oldName, newName);
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.program.getDataTypeManager();
    }

    @Override
    public Function createFunction(String name, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.functionMgr.createFunction(name, entryPoint, body, source);
    }

    @Override
    public Function createFunction(String name, Namespace nameSpace, Address entryPoint, AddressSetView body, SourceType source) throws InvalidInputException, OverlappingFunctionException {
        return this.functionMgr.createFunction(name, nameSpace, entryPoint, body, source);
    }

    @Override
    public void removeFunction(Address entryPoint) {
        this.functionMgr.removeFunction(entryPoint);
    }

    @Override
    public Function getFunctionAt(Address entryPoint) {
        return this.functionMgr.getFunctionAt(entryPoint);
    }

    @Override
    public List<Function> getGlobalFunctions(String name) {
        ArrayList<Function> list = new ArrayList<Function>();
        List<Symbol> globalSymbols = this.program.getSymbolTable().getGlobalSymbols(name);
        for (Symbol symbol : globalSymbols) {
            if (symbol.getSymbolType() != SymbolType.FUNCTION) continue;
            list.add((Function)symbol.getObject());
        }
        return list;
    }

    @Override
    public List<Function> getFunctions(String namespacePath, String name) {
        ArrayList<Function> list = new ArrayList<Function>();
        SymbolIterator symbols = this.program.getSymbolTable().getSymbols(name);
        while (symbols.hasNext()) {
            Namespace namespace;
            String fullName;
            Symbol symbol = symbols.next();
            if (!(symbol instanceof FunctionSymbol) || !(fullName = (namespace = symbol.getParentNamespace()).getName(true)).equals(namespacePath)) continue;
            list.add((Function)symbol.getObject());
        }
        return list;
    }

    @Override
    public Function getFunctionContaining(Address addr) {
        return this.functionMgr.getFunctionContaining(addr);
    }

    @Override
    public FunctionIterator getExternalFunctions() {
        return this.functionMgr.getExternalFunctions();
    }

    @Override
    public FunctionIterator getFunctions(boolean forward) {
        return this.functionMgr.getFunctions(forward);
    }

    @Override
    public FunctionIterator getFunctions(Address start, boolean forward) {
        return this.functionMgr.getFunctions(start, forward);
    }

    @Override
    public FunctionIterator getFunctions(AddressSetView asv, boolean forward) {
        return this.functionMgr.getFunctions(asv, forward);
    }

    @Override
    public boolean isInFunction(Address addr) {
        return this.functionMgr.isInFunction(addr);
    }

    @Override
    public CommentHistory[] getCommentHistory(Address addr, int commentType) {
        return this.codeMgr.getCommentHistory(addr, commentType);
    }

    @Override
    public CodeUnitIterator getCommentCodeUnitIterator(int commentType, AddressSetView addrSet) {
        return this.codeMgr.getCommentCodeUnitIterator(commentType, addrSet);
    }

    @Override
    public AddressIterator getCommentAddressIterator(int commentType, AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getCommentAddressIterator(commentType, addrSet, forward);
    }

    @Override
    public AddressIterator getCommentAddressIterator(AddressSetView addrSet, boolean forward) {
        return this.codeMgr.getCommentAddressIterator(addrSet, forward);
    }

    @Override
    public String getComment(int commentType, Address address) {
        return this.codeMgr.getComment(commentType, address);
    }

    @Override
    public void setComment(Address address, int commentType, String comment) {
        this.codeMgr.setComment(address, commentType, comment);
    }

    @Override
    public CodeUnit getDefinedCodeUnitAfter(Address addr) {
        Address instAddr;
        Data data = this.codeMgr.getDefinedDataAfter(addr);
        Instruction inst = this.codeMgr.getInstructionAfter(addr);
        if (data == null) {
            return inst;
        }
        if (inst == null) {
            return data;
        }
        Address dataAddr = data.getMinAddress();
        if (dataAddr.compareTo(instAddr = inst.getMinAddress()) < 0) {
            return data;
        }
        return inst;
    }

    @Override
    public CodeUnit getDefinedCodeUnitBefore(Address addr) {
        Address instAddr;
        Data data = this.codeMgr.getDefinedDataBefore(addr);
        Instruction inst = this.codeMgr.getInstructionBefore(addr);
        if (data == null) {
            return inst;
        }
        if (inst == null) {
            return data;
        }
        Address dataAddr = data.getMinAddress();
        if (dataAddr.compareTo(instAddr = inst.getMinAddress()) < 0) {
            return inst;
        }
        return data;
    }
}

