/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.space;

import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import java.io.PrintStream;
import org.jdom.Element;

public class ConstantSpace
extends AddrSpace {
    public ConstantSpace(Translate t) {
        super(t, spacetype.IPTR_CONSTANT, "const", 8, 1, 0, 0, 0);
        this.clearFlags(3);
        this.setFlags(1);
    }

    @Override
    public int printRaw(PrintStream s, long offset) {
        s.append("0x");
        s.append(Long.toHexString(offset));
        return this.getTrans().getDefaultSize();
    }

    @Override
    public void saveXml(PrintStream s) {
        throw new LowlevelError("Should never save the constant space as XML");
    }

    @Override
    public void restoreXml(Element el) {
        throw new LowlevelError("Should never restore the constant space from XML");
    }
}

