/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.address;

import generic.stl.ComparableSetSTL;
import generic.stl.IteratorSTL;
import generic.stl.SetSTL;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.Range;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.Utils;
import java.io.PrintStream;
import java.util.List;
import org.jdom.Element;

public class RangeList {
    private SetSTL<Range> tree;

    public RangeList(RangeList rangeList) {
        this.tree = new SetSTL(rangeList.tree);
    }

    public RangeList() {
        this.tree = new ComparableSetSTL();
    }

    public void clear() {
        this.tree.clear();
    }

    public IteratorSTL<Range> begin() {
        return this.tree.begin();
    }

    public IteratorSTL<Range> end() {
        return this.tree.end();
    }

    public boolean empty() {
        return this.tree.isEmpty();
    }

    public void insertRange(AddrSpace spc, long first, long last) {
        IteratorSTL iter1 = this.tree.upper_bound((Object)new Range(spc, first, first));
        if (!iter1.isBegin()) {
            iter1.decrement();
            if (!((Range)iter1.get()).getSpace().equals(spc) || Utils.unsignedCompare(((Range)iter1.get()).getLast(), first) < 0) {
                iter1.increment();
            }
        }
        IteratorSTL iter2 = this.tree.upper_bound((Object)new Range(spc, last, last));
        while (!iter1.equals(iter2)) {
            if (Utils.unsignedCompare(((Range)iter1.get()).getFirst(), first) < 0) {
                first = ((Range)iter1.get()).getFirst();
            }
            if (Utils.unsignedCompare(((Range)iter1.get()).getLast(), last) > 0) {
                last = ((Range)iter1.get()).getLast();
            }
            this.tree.erase(iter1);
            iter1.increment();
        }
        this.tree.insert((Object)new Range(spc, first, last));
    }

    public void removeRange(AddrSpace spc, long first, long last) {
        if (this.tree.isEmpty()) {
            return;
        }
        IteratorSTL iter1 = this.tree.upper_bound((Object)new Range(spc, first, first));
        if (!iter1.isBegin()) {
            iter1.decrement();
            if (!((Range)iter1.get()).getSpace().equals(spc) || Utils.unsignedCompare(((Range)iter1.get()).getLast(), first) < 0) {
                iter1.increment();
            }
        }
        IteratorSTL iter2 = this.tree.upper_bound((Object)new Range(spc, last, last));
        while (!iter1.equals(iter2)) {
            long a = ((Range)iter1.get()).getFirst();
            long b = ((Range)iter1.get()).getLast();
            this.tree.erase(iter1);
            iter1.increment();
            if (Utils.unsignedCompare(a, first) < 0) {
                this.tree.insert((Object)new Range(spc, a, first - 1L));
            }
            if (Utils.unsignedCompare(b, last) <= 0) continue;
            this.tree.insert((Object)new Range(spc, last + 1L, b));
        }
    }

    public boolean inRange(Address addr, int size) {
        if (addr.isInvalid()) {
            return true;
        }
        if (this.tree.isEmpty()) {
            return false;
        }
        IteratorSTL iter = this.tree.upper_bound((Object)new Range(addr.getSpace(), addr.getOffset(), addr.getOffset()));
        if (iter.isBegin()) {
            return false;
        }
        iter.decrement();
        if (!((Range)iter.get()).getSpace().equals(addr.getSpace())) {
            return false;
        }
        return Utils.unsignedCompare(((Range)iter.get()).getLast(), addr.getOffset() + (long)size - 1L) >= 0;
    }

    public long longestFit(Address addr, long maxsize) {
        if (addr.isInvalid()) {
            return 0L;
        }
        if (this.tree.isEmpty()) {
            return 0L;
        }
        long offset = addr.getOffset();
        IteratorSTL iter = this.tree.upper_bound((Object)new Range(addr.getSpace(), offset, offset));
        if (iter.isBegin()) {
            return 0L;
        }
        iter.decrement();
        long sizeres = 0L;
        if (Utils.unsignedCompare(((Range)iter.get()).getLast(), offset) < 0) {
            return sizeres;
        }
        while (((Range)iter.get()).getSpace().equals(addr.getSpace()) && Utils.unsignedCompare(((Range)iter.get()).getFirst(), offset) <= 0) {
            offset = ((Range)iter.get()).getLast() + 1L;
            if (Utils.unsignedCompare(sizeres += ((Range)iter.get()).getLast() + 1L - offset, maxsize) >= 0) break;
            iter.increment();
            if (!iter.isEnd()) continue;
        }
        return sizeres;
    }

    public Range getFirstRange() {
        if (this.tree.isEmpty()) {
            return null;
        }
        return (Range)this.tree.begin().get();
    }

    public Range getFirstRange(AddrSpace spaceid) {
        Range range = new Range(spaceid, 0L, 0L);
        IteratorSTL iter = this.tree.lower_bound((Object)range);
        if (iter.equals(this.tree.end())) {
            return null;
        }
        if (!((Range)iter.get()).getSpace().equals(spaceid)) {
            return null;
        }
        return (Range)iter.get();
    }

    public Range getLastRange() {
        if (this.tree.isEmpty()) {
            return null;
        }
        IteratorSTL iter = this.tree.end();
        iter.decrement();
        return (Range)iter.get();
    }

    public Range getLastRange(AddrSpace spaceid) {
        Range range = new Range(spaceid, -1L, -1L);
        IteratorSTL iter = this.tree.upper_bound((Object)range);
        if (iter.equals(this.tree.begin())) {
            return null;
        }
        iter.decrement();
        if (!((Range)iter.get()).getSpace().equals(spaceid)) {
            return null;
        }
        return (Range)iter.get();
    }

    public void printBounds(PrintStream s) {
        if (this.tree.isEmpty()) {
            s.println("all");
        } else {
            IteratorSTL it = this.tree.begin();
            while (!it.isEnd()) {
                Range range = (Range)it.get();
                range.printBounds(s);
                it.increment();
            }
        }
    }

    public void saveXml(PrintStream s) {
        s.println("<rangelist>");
        IteratorSTL it = this.tree.begin();
        while (!it.isEnd()) {
            Range range = (Range)it.get();
            range.saveXml(s);
            it.increment();
        }
        s.println("</rangelist>");
    }

    public void restoreXml(Element el, Translate trans) {
        List children = el.getChildren();
        for (Object object : children) {
            Element child = (Element)object;
            Range range = new Range();
            range.restoreXml(child, trans);
            this.tree.insert((Object)range);
        }
    }
}

