/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import generic.jar.ResourceFile;
import generic.stl.Pair;
import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.app.plugin.processors.sleigh.ContextCache;
import ghidra.app.plugin.processors.sleigh.DecisionNode;
import ghidra.app.plugin.processors.sleigh.ModuleDefinitionsAdapter;
import ghidra.app.plugin.processors.sleigh.SleighCompilerSpecDescription;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighInstructionPrototype;
import ghidra.app.plugin.processors.sleigh.SleighLanguageValidator;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.ContextSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeListSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.framework.Application;
import ghidra.pcodeCPort.slgh_compile.SleighCompileLauncher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.address.ProtectedAddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.AddressLabelInfo;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.ContextSetting;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.InjectPayloadJumpAssist;
import ghidra.program.model.lang.InjectPayloadSegment;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.NestedDelaySlotException;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterBuilder;
import ghidra.program.model.lang.RegisterManager;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.util.ProcessorSymbolType;
import ghidra.sleigh.grammar.SleighPreprocessor;
import ghidra.sleigh.grammar.SourceFileIndexer;
import ghidra.util.ManualEntry;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.RecognitionException;
import org.jdom.JDOMException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighLanguage
implements Language {
    public static final int SLA_FORMAT_VERSION = 3;
    private Map<CompilerSpecID, SleighCompilerSpecDescription> compilerSpecDescriptions;
    private HashMap<CompilerSpecID, BasicCompilerSpec> compilerSpecs;
    private List<InjectPayloadSleigh> additionalInject = null;
    private AddressFactory addressFactory;
    private AddressSpace defaultDataSpace;
    private RegisterBuilder registerBuilder;
    private MemoryBlockDefinition[] defaultMemoryBlocks;
    private Register programCounter;
    private List<AddressLabelInfo> defaultSymbols;
    private long uniqueBase;
    private int uniqueAllocateMask = 0;
    private int numSections = 0;
    private int alignment = 1;
    private int defaultPointerWordSize = 1;
    private SleighLanguageDescription description;
    private ParallelInstructionLanguageHelper parallelHelper;
    private SourceFileIndexer indexer;
    private SymbolTable symtab = null;
    private String segmentedspace = "";
    private String segmentType = "";
    private AddressSet volatileAddresses;
    private AddressSet volatileSymbolAddresses;
    private AddressSet nonVolatileSymbolAddresses;
    private ContextCache contextcache = null;
    private LinkedHashMap<Integer, SleighInstructionPrototype> instructProtoMap;
    private DecisionNode root = null;
    LinkedHashMap<String, AddressSpace> spacetable;
    private AddressSpace default_space;
    private List<ContextSetting> ctxsetting = new ArrayList<ContextSetting>();
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    SortedMap<String, ManualEntry> manual = null;
    private RegisterManager registerManager = null;
    private ErrorHandler SPEC_ERR_HANDLER = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Msg.error((Object)SleighLanguage.this, (Object)("Error parsing " + SleighLanguage.this.description.getSpecFile()), (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Msg.error((Object)SleighLanguage.this, (Object)("Fatal error parsing " + SleighLanguage.this.description.getSpecFile()), (Throwable)exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Msg.warn((Object)SleighLanguage.this, (Object)("Warning parsing " + SleighLanguage.this.description.getSpecFile()), (Throwable)exception);
        }
    };
    private Exception manualException = null;
    private static final Comparator<String> CASE_INSENSITIVE = (o1, o2) -> {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareToIgnoreCase((String)o2);
    };
    private static final Pattern COMMENT = Pattern.compile("^\\s*#(.*)");
    private static final Pattern FILE_INCLUDE = Pattern.compile("^\\s*<(.*)");
    private static final Pattern FILE_SWITCH = Pattern.compile("^\\s*@(.*)");
    private static final Pattern FILE_SWITCH_WITH_DESCRIPTION = Pattern.compile("^\\s*@(.*)\\[(.*)\\]");
    private static final Pattern INSTRUCTION = Pattern.compile("\\s*([^,]+)\\s*,\\s*(.+)");

    SleighLanguage(SleighLanguageDescription description) throws SAXException, IOException, UnknownInstructionException {
        this.initialize(description);
    }

    private void addAdditionInject(InjectPayloadSleigh payload) {
        if (this.additionalInject == null) {
            this.additionalInject = new ArrayList<InjectPayloadSleigh>();
        }
        this.additionalInject.add(payload);
    }

    private void initialize(SleighLanguageDescription langDescription) throws SAXException, IOException, UnknownInstructionException {
        this.defaultSymbols = new ArrayList<AddressLabelInfo>();
        this.compilerSpecDescriptions = new LinkedHashMap<CompilerSpecID, SleighCompilerSpecDescription>();
        for (CompilerSpecDescription compilerSpecDescription : langDescription.getCompatibleCompilerSpecDescriptions()) {
            this.compilerSpecDescriptions.put(compilerSpecDescription.getCompilerSpecID(), (SleighCompilerSpecDescription)compilerSpecDescription);
        }
        this.compilerSpecs = new HashMap();
        this.description = langDescription;
        this.additionalInject = null;
        SleighLanguageValidator.validatePspecFile(langDescription.getSpecFile());
        this.readInitialDescription();
        this.contextcache = new ContextCache();
        ResourceFile slaFile = langDescription.getSlaFile();
        if (!slaFile.exists() || slaFile.canWrite() && (this.isSLAWrongVersion(slaFile) || this.isSLAStale(slaFile))) {
            this.reloadLanguage(TaskMonitor.DUMMY, true);
        }
        this.readSpecification(slaFile);
        this.registerBuilder = new RegisterBuilder();
        this.loadRegisters(this.registerBuilder);
        this.readRemainingSpecification();
        this.buildVolatileSymbolAddresses();
        this.xrefRegisters();
        this.instructProtoMap = new LinkedHashMap();
        this.initParallelHelper();
    }

    private void buildVolatileSymbolAddresses() {
        if (this.volatileAddresses == null) {
            this.volatileAddresses = new AddressSet();
        }
        if (this.volatileSymbolAddresses != null) {
            this.volatileAddresses.add(this.volatileSymbolAddresses);
        }
        if (this.nonVolatileSymbolAddresses != null) {
            this.volatileAddresses.delete(this.nonVolatileSymbolAddresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSLAWrongVersion(ResourceFile slaFile) {
        XmlPullParser parser = null;
        try {
            parser = XmlPullParserFactory.create((ResourceFile)slaFile, (ErrorHandler)new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            }, (boolean)false);
            XmlElement e = parser.peek();
            if (!"sleigh".equals(e.getName())) {
                boolean bl = true;
                return bl;
            }
            int version = SpecXmlUtils.decodeInt((String)e.getAttribute("version"));
            boolean bl = version != 3;
            return bl;
        }
        catch (IOException | SAXException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (parser != null) {
                parser.dispose();
            }
        }
    }

    private boolean isSLAStale(ResourceFile slaFile) {
        String slafilename = slaFile.getName();
        int index = slafilename.lastIndexOf(46);
        String slabase = slafilename.substring(0, index);
        String slaspecfilename = slabase + ".slaspec";
        ResourceFile slaspecFile = new ResourceFile(slaFile.getParentFile(), slaspecfilename);
        File resourceAsFile = slaspecFile.getFile(true);
        SleighPreprocessor preprocessor = new SleighPreprocessor(new ModuleDefinitionsAdapter(), resourceAsFile);
        long sourceTimestamp = Long.MAX_VALUE;
        try {
            sourceTimestamp = preprocessor.scanForTimestamp();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long compiledTimestamp = slaFile.lastModified();
        return sourceTimestamp > compiledTimestamp;
    }

    public long getUniqueBase() {
        return this.uniqueBase;
    }

    public int getUniqueAllocationMask() {
        return this.uniqueAllocateMask;
    }

    public int numSections() {
        return this.numSections;
    }

    public String toString() {
        return this.description.toString();
    }

    private RegisterManager getRegisterManager() {
        if (this.registerManager == null) {
            this.registerManager = this.registerBuilder.getRegisterManager();
        }
        return this.registerManager;
    }

    @Override
    public void applyContextSettings(DefaultProgramContext programContext) {
        for (ContextSetting cs : this.ctxsetting) {
            RegisterValue registerValue = new RegisterValue(cs.getRegister(), cs.getValue());
            programContext.setDefaultValue(registerValue, cs.getStartAddress(), cs.getEndAddress());
        }
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public List<InjectPayloadSleigh> getAdditionalInject() {
        return this.additionalInject;
    }

    @Override
    public Register getContextBaseRegister() {
        return this.getRegisterManager().getContextBaseRegister();
    }

    @Override
    public List<Register> getContextRegisters() {
        return this.getRegisterManager().getContextRegisters();
    }

    @Override
    public MemoryBlockDefinition[] getDefaultMemoryBlocks() {
        return this.defaultMemoryBlocks;
    }

    @Override
    public Register getProgramCounter() {
        return this.programCounter;
    }

    @Override
    public List<AddressLabelInfo> getDefaultSymbols() {
        return this.defaultSymbols;
    }

    @Override
    public int getInstructionAlignment() {
        return this.alignment;
    }

    @Override
    public int getMinorVersion() {
        return this.description.getMinorVersion();
    }

    @Override
    public LanguageID getLanguageID() {
        return this.description.getLanguageID();
    }

    @Override
    public String getUserDefinedOpName(int index) {
        return this.symtab.getUserDefinedOpName(index);
    }

    @Override
    public int getNumberOfUserDefinedOpNames() {
        return this.symtab.getNumberOfUserDefinedOpNames();
    }

    @Override
    public Processor getProcessor() {
        return this.description.getProcessor();
    }

    @Override
    public Register getRegister(AddressSpace addrspc, long offset, int size) {
        return this.getRegister(addrspc.getAddress(offset), size);
    }

    @Override
    public Register getRegister(String name) {
        return this.getRegisterManager().getRegister(name);
    }

    @Override
    public Register getRegister(Address addr, int size) {
        return this.getRegisterManager().getRegister(addr, size);
    }

    @Override
    public Register[] getRegisters(Address address) {
        return this.getRegisterManager().getRegisters(address);
    }

    @Override
    public List<Register> getRegisters() {
        return this.getRegisterManager().getRegisters();
    }

    @Override
    public List<String> getRegisterNames() {
        return this.getRegisterManager().getRegisterNames();
    }

    @Override
    public String getSegmentedSpace() {
        return this.segmentedspace;
    }

    @Override
    public int getVersion() {
        return this.description.getVersion();
    }

    @Override
    public AddressSetView getVolatileAddresses() {
        return this.volatileAddresses;
    }

    @Override
    public boolean isBigEndian() {
        return this.description.getEndian().isBigEndian();
    }

    @Override
    public boolean isVolatile(Address addr) {
        return this.volatileAddresses.contains(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstructionPrototype parse(MemBuffer buf, ProcessorContext context, boolean inDelaySlot) throws InsufficientBytesException, UnknownInstructionException {
        if (this.alignment != 1 && buf.getAddress().getOffset() % (long)this.alignment != 0L) {
            throw new UnknownInstructionException("Instructions must be aligned on " + this.alignment + "byte boundary.");
        }
        SleighInstructionPrototype res = null;
        try {
            SleighInstructionPrototype newProto = new SleighInstructionPrototype(this, buf, context, this.contextcache, inDelaySlot, null);
            Integer hashcode = newProto.hashCode();
            if (!this.instructProtoMap.containsKey(hashcode)) {
                newProto.cacheInfo(buf, context, true);
            }
            LinkedHashMap<Integer, SleighInstructionPrototype> linkedHashMap = this.instructProtoMap;
            synchronized (linkedHashMap) {
                res = this.instructProtoMap.get(hashcode);
                if (res == null) {
                    this.instructProtoMap.put(hashcode, newProto);
                    res = newProto;
                }
                if (inDelaySlot && res.hasDelaySlots()) {
                    throw new NestedDelaySlotException();
                }
            }
        }
        catch (MemoryAccessException e) {
            throw new InsufficientBytesException(e.getMessage());
        }
        try {
            SleighParserContext protoContext = res.getParserContext(buf, context);
            protoContext.applyCommits(context);
        }
        catch (Exception e) {
            throw new UnknownInstructionException();
        }
        return res;
    }

    public DecisionNode getRootDecisionNode() {
        return this.root;
    }

    public SymbolTable getSymbolTable() {
        return this.symtab;
    }

    public SourceFileIndexer getSourceFileIndexer() {
        return this.indexer;
    }

    @Override
    public void reloadLanguage(TaskMonitor monitor) throws IOException {
        this.reloadLanguage(monitor, false);
    }

    private void reloadLanguage(TaskMonitor monitor, boolean calledFromInitialize) throws IOException {
        String[] args;
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        monitor.setMessage("Compiling Language File...");
        ResourceFile slaFile = this.description.getSlaFile();
        String slaName = slaFile.getName();
        int index = slaName.lastIndexOf(46);
        String specName = slaName.substring(0, index);
        String languageName = specName + ".slaspec";
        ResourceFile languageFile = new ResourceFile(slaFile.getParentFile(), languageName);
        ResourceFile sleighArgsFile = null;
        ResourceFile languageModule = Application.getModuleContainingResourceFile((ResourceFile)languageFile);
        if (languageModule != null) {
            sleighArgsFile = SystemUtilities.isInReleaseMode() ? new ResourceFile(languageModule, "data/sleighArgs.txt") : new ResourceFile(languageModule, "build/tmp/sleighArgs.txt");
        }
        if (sleighArgsFile != null && sleighArgsFile.isFile()) {
            Object baseDir = Application.getInstallationDirectory().getAbsolutePath().replace(File.separatorChar, '/');
            if (!((String)baseDir).endsWith("/")) {
                baseDir = (String)baseDir + "/";
            }
            args = new String[]{"-DBaseDir=" + (String)baseDir, "-i", sleighArgsFile.getAbsolutePath(), languageFile.getAbsolutePath(), this.description.getSlaFile().getAbsolutePath()};
        } else {
            args = new String[]{languageFile.getAbsolutePath(), this.description.getSlaFile().getAbsolutePath()};
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (String str : args) {
                buf.append(str);
                buf.append(" ");
            }
            Msg.debug((Object)this, (Object)("Sleigh compile: " + buf));
            int returnCode = SleighCompileLauncher.runMain(args);
            if (returnCode != 0) {
                throw new SleighException("Errors compiling " + languageFile.getAbsolutePath() + " -- please check log messages for details");
            }
        }
        catch (JDOMException e) {
            throw new IOException("JDOMException error recompiling: " + e.getMessage());
        }
        catch (RecognitionException e) {
            throw new IOException("RecognitionException error recompiling: " + e.getMessage());
        }
        if (!calledFromInitialize) {
            monitor.setMessage("Reloading Language...");
            try {
                this.initialize(this.description);
            }
            catch (SAXException e) {
                throw new IOException(e.getMessage());
            }
            catch (UnknownInstructionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public boolean supportsPcode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInitialDescription() throws SAXException, IOException {
        ResourceFile specFile = this.description.getSpecFile();
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)specFile, (ErrorHandler)this.SPEC_ERR_HANDLER, (boolean)false);
        try {
            XmlElement nextElement = parser.peek();
            while (nextElement != null && !nextElement.getName().equals("segmented_address")) {
                parser.next();
                nextElement = parser.peek();
            }
            if (nextElement != null) {
                XmlElement element = parser.start(new String[0]);
                this.segmentedspace = element.getAttribute("space");
                this.segmentType = element.getAttribute("type");
                if (this.segmentType == null) {
                    this.segmentType = "";
                }
            }
        }
        finally {
            parser.dispose();
        }
    }

    private void setDefaultDataSpace(String spaceName) {
        if (spaceName == null) {
            return;
        }
        AddressSpace addressSpace = this.addressFactory.getAddressSpace(spaceName);
        if (addressSpace == null || !addressSpace.isLoadedMemorySpace()) {
            Msg.error((Object)this, (Object)("unknown/invalid BSS space " + spaceName + ": " + this.description.getSpecFile()));
            return;
        }
        this.defaultDataSpace = addressSpace;
        this.defaultPointerWordSize = this.defaultDataSpace.getAddressableUnitSize();
    }

    private void setProgramCounter(String programCounterName) {
        if (programCounterName == null) {
            return;
        }
        Register reg = this.registerBuilder.getRegister(programCounterName);
        if (reg == null) {
            Msg.error((Object)this, (Object)("unknown program counter register " + programCounterName + ": " + this.description.getSpecFile()));
            return;
        }
        this.registerBuilder.setFlag(programCounterName, 4);
        this.programCounter = reg;
    }

    private void addContextSetting(Register reg, BigInteger value, Address begad, Address endad) {
        this.ctxsetting.add(new ContextSetting(reg, value, begad, endad));
    }

    private Pair<Address, Address> parseRange(XmlElement element) {
        String space = element.getAttribute("space");
        AddressSpace addrspace = this.spacetable.get(space);
        if (addrspace == null) {
            throw new SleighException("Invalid address space name: " + space);
        }
        long first = 0L;
        long last = addrspace.getMaxAddress().getOffset();
        String valstring = element.getAttribute("first");
        if (valstring != null) {
            first = SpecXmlUtils.decodeLong((String)valstring);
        }
        if ((valstring = element.getAttribute("last")) != null) {
            last = SpecXmlUtils.decodeLong((String)valstring);
        }
        return new Pair((Object)addrspace.getAddress(first), (Object)addrspace.getAddress(last));
    }

    private void read(XmlPullParser parser) throws XmlParseException {
        HashSet<String> registerDataSet = new HashSet<String>();
        XmlElement el = parser.start(new String[]{"processor_spec"});
        while (parser.peek().isStart()) {
            XmlElement next;
            XmlElement subel;
            String elName = parser.peek().getName();
            if (elName.equals("properties")) {
                subel = parser.start(new String[0]);
                while (!parser.peek().isEnd()) {
                    next = parser.start(new String[]{"property"});
                    String key = next.getAttribute("key");
                    String value = next.getAttribute("value");
                    this.properties.put(key, value);
                    parser.end(next);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("programcounter")) {
                subel = parser.start(new String[0]);
                this.setProgramCounter(subel.getAttribute("register"));
                parser.end(subel);
                continue;
            }
            if (elName.equals("data_space")) {
                subel = parser.start(new String[0]);
                this.setDefaultDataSpace(subel.getAttribute("space"));
                String overrideString = subel.getAttribute("ptr_wordsize");
                if (overrideString != null) {
                    int val = SpecXmlUtils.decodeInt((String)overrideString);
                    if (val <= 0 || val >= 32) {
                        throw new SleighException("Bad ptr_wordsize attribute");
                    }
                    this.defaultPointerWordSize = val;
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("context_data")) {
                subel = parser.start(new String[0]);
                while (!parser.peek().isEnd()) {
                    next = parser.start(new String[0]);
                    boolean isContext = next.getName().equals("context_set");
                    Pair<Address, Address> range = this.parseRange(next);
                    while (parser.peek().getName().equals("set")) {
                        boolean test;
                        BigInteger val;
                        XmlElement set = parser.start(new String[0]);
                        String name = set.getAttribute("name");
                        String sValue = set.getAttribute("val");
                        int radix = 10;
                        if (sValue.startsWith("0x") || sValue.startsWith("0X")) {
                            sValue = sValue.substring(2);
                            radix = 16;
                        }
                        try {
                            val = new BigInteger(sValue, radix);
                        }
                        catch (Exception e) {
                            val = BigInteger.valueOf(0L);
                        }
                        Register reg = this.registerBuilder.getRegister(name);
                        if (isContext) {
                            test = reg == null || !reg.isProcessorContext();
                        } else {
                            boolean bl = test = reg == null || reg.isProcessorContext();
                        }
                        if (test) {
                            throw new SleighException("Bad register name: " + name);
                        }
                        this.addContextSetting(reg, val, (Address)range.first, (Address)range.second);
                        parser.end(set);
                    }
                    parser.end(next);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("volatile")) {
                subel = parser.start(new String[0]);
                while (!parser.peek().getName().equals("volatile")) {
                    next = parser.start(new String[0]);
                    if (next.getName().equals("register")) {
                        throw new SleighException("no support for volatile registers yet");
                    }
                    Pair<Address, Address> range = this.parseRange(next);
                    if (this.volatileAddresses == null) {
                        this.volatileAddresses = new AddressSet();
                    }
                    this.volatileAddresses.addRange((Address)range.first, (Address)range.second);
                    parser.end(next);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("jumpassist")) {
                subel = parser.start(new String[0]);
                String source = "pspec: " + this.getLanguageID().getIdAsString();
                String name = subel.getAttribute("name");
                while (parser.peek().isStart()) {
                    InjectPayloadJumpAssist payload = new InjectPayloadJumpAssist(name, source);
                    ((InjectPayloadSleigh)payload).restoreXml(parser, this);
                    this.addAdditionInject(payload);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("register_data")) {
                subel = parser.start(new String[0]);
                while (parser.peek().getName().equals("register")) {
                    Register register;
                    XmlElement reg = parser.start(new String[0]);
                    String registerName = reg.getAttribute("name");
                    String registerRename = reg.getAttribute("rename");
                    String registerAlias = reg.getAttribute("alias");
                    String groupName = reg.getAttribute("group");
                    boolean isHidden = SpecXmlUtils.decodeBoolean((String)reg.getAttribute("hidden"));
                    if (registerRename != null) {
                        if (!this.registerBuilder.renameRegister(registerName, registerRename)) {
                            throw new SleighException("error renaming " + registerName + " to " + registerRename);
                        }
                        registerName = registerRename;
                    }
                    if ((register = this.registerBuilder.getRegister(registerName)) != null) {
                        String sizes;
                        if (!registerDataSet.add(registerName)) {
                            Msg.error((Object)this, (Object)("duplicate register " + registerName + ": " + this.description.getSpecFile()));
                        }
                        if (registerAlias != null) {
                            this.registerBuilder.addAlias(registerName, registerAlias);
                        }
                        if (groupName != null) {
                            this.registerBuilder.setGroup(registerName, groupName);
                        }
                        if (isHidden) {
                            this.registerBuilder.setFlag(registerName, 32);
                        }
                        if ((sizes = reg.getAttribute("vector_lane_sizes")) != null) {
                            String[] lanes;
                            for (String lane : lanes = sizes.split(",")) {
                                int laneSize = SpecXmlUtils.decodeInt((String)lane.trim());
                                this.registerBuilder.addLaneSize(registerName, laneSize);
                            }
                        }
                    } else {
                        Msg.error((Object)this, (Object)("unknown register " + registerName + ": " + this.description.getSpecFile()));
                    }
                    parser.end(reg);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("default_symbols")) {
                subel = parser.start(new String[0]);
                while (parser.peek().getName().equals("symbol")) {
                    XmlElement symbol = parser.start(new String[0]);
                    String labelName = symbol.getAttribute("name");
                    String addressString = symbol.getAttribute("address");
                    String typeString = symbol.getAttribute("type");
                    ProcessorSymbolType type = ProcessorSymbolType.getType(typeString);
                    boolean isEntry = SpecXmlUtils.decodeBoolean((String)symbol.getAttribute("entry"));
                    Address startAddress = this.addressFactory.getAddress(addressString);
                    int rangeSize = SpecXmlUtils.decodeInt((String)symbol.getAttribute("size"));
                    Boolean isVolatile = SpecXmlUtils.decodeNullableBoolean((String)symbol.getAttribute("volatile"));
                    if (startAddress == null) {
                        Msg.error((Object)this, (Object)("invalid symbol address \"" + addressString + "\": " + this.description.getSpecFile()));
                    } else {
                        AddressLabelInfo info;
                        try {
                            info = new AddressLabelInfo(startAddress, rangeSize, labelName, false, isEntry, type, isVolatile);
                        }
                        catch (AddressOverflowException e) {
                            throw new XmlParseException("invalid symbol definition: " + labelName, (Throwable)((Object)e));
                        }
                        this.defaultSymbols.add(info);
                        if (isVolatile != null) {
                            Address endAddress = info.getEndAddress();
                            if (isVolatile.booleanValue()) {
                                if (this.volatileSymbolAddresses == null) {
                                    this.volatileSymbolAddresses = new AddressSet();
                                }
                                this.volatileSymbolAddresses.addRange(startAddress, endAddress);
                            } else {
                                if (this.nonVolatileSymbolAddresses == null) {
                                    this.nonVolatileSymbolAddresses = new AddressSet();
                                }
                                this.nonVolatileSymbolAddresses.addRange(startAddress, endAddress);
                            }
                        }
                    }
                    parser.end(symbol);
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("default_memory_blocks")) {
                subel = parser.start(new String[0]);
                ArrayList<MemoryBlockDefinition> list = new ArrayList<MemoryBlockDefinition>();
                while (parser.peek().getName().equals("memory_block")) {
                    XmlElement mblock = parser.start(new String[0]);
                    list.add(new MemoryBlockDefinition(mblock));
                    parser.end(mblock);
                }
                parser.end(subel);
                this.defaultMemoryBlocks = new MemoryBlockDefinition[list.size()];
                list.toArray(this.defaultMemoryBlocks);
                continue;
            }
            if (elName.equals("incidentalcopy")) {
                subel = parser.start(new String[0]);
                while (parser.peek().isStart()) {
                    parser.discardSubTree();
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("inferptrbounds")) {
                subel = parser.start(new String[0]);
                while (parser.peek().isStart()) {
                    parser.discardSubTree();
                }
                parser.end(subel);
                continue;
            }
            if (elName.equals("segmentop")) {
                String source = "pspec: " + this.getLanguageID().getIdAsString();
                InjectPayloadSegment payload = new InjectPayloadSegment(source);
                ((InjectPayloadSleigh)payload).restoreXml(parser, this);
                this.addAdditionInject(payload);
                continue;
            }
            if (elName.equals("segmented_address")) {
                subel = parser.start(new String[0]);
                parser.end(subel);
                continue;
            }
            throw new XmlParseException("Unknown pspec tag: " + elName);
        }
        parser.end(el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRemainingSpecification() throws SAXException, IOException {
        ResourceFile specFile = this.description.getSpecFile();
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)specFile, (ErrorHandler)this.SPEC_ERR_HANDLER, (boolean)false);
        try {
            this.read(parser);
        }
        catch (XmlParseException e) {
            Msg.error((Object)this, (Object)("Failed to parse Sleigh Specification (" + specFile.getName() + "): " + e.getMessage()));
        }
        finally {
            parser.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSpecification(final ResourceFile sleighfile) throws SAXException, IOException, UnknownInstructionException {
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error((Object)SleighLanguage.this, (Object)("Error parsing " + sleighfile), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error((Object)SleighLanguage.this, (Object)("Fatal error parsing " + sleighfile), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)SleighLanguage.this, (Object)("Warning parsing " + sleighfile), (Throwable)exception);
            }
        };
        XmlPullParser parser = XmlPullParserFactory.create((ResourceFile)sleighfile, (ErrorHandler)errHandler, (boolean)false);
        try {
            this.restoreXml(parser);
        }
        finally {
            parser.dispose();
        }
    }

    private void restoreXml(XmlPullParser parser) throws UnknownInstructionException {
        String numsecstr;
        XmlElement el = parser.start(new String[]{"sleigh"});
        int version = SpecXmlUtils.decodeInt((String)el.getAttribute("version"));
        if (version != 3) {
            throw new SleighException(".sla file for " + this.getLanguageID() + " has the wrong format");
        }
        String endianAttr = el.getAttribute("bigendian");
        Endian slaEndian = SpecXmlUtils.decodeBoolean((String)endianAttr) ? Endian.BIG : Endian.LITTLE;
        Endian ldefEndian = this.description.getEndian();
        Endian instEndian = this.description.getInstructionEndian();
        if (slaEndian != ldefEndian && instEndian == ldefEndian) {
            throw new SleighException(".ldefs says " + this.getLanguageID() + " is " + ldefEndian + " but .sla says " + slaEndian);
        }
        this.uniqueBase = SpecXmlUtils.decodeLong((String)el.getAttribute("uniqbase"));
        this.alignment = SpecXmlUtils.decodeInt((String)el.getAttribute("align"));
        this.uniqueAllocateMask = 0;
        String uniqmaskstr = el.getAttribute("uniqmask");
        if (uniqmaskstr != null) {
            this.uniqueAllocateMask = SpecXmlUtils.decodeInt((String)uniqmaskstr);
        }
        if ((numsecstr = el.getAttribute("numsections")) != null) {
            this.numSections = SpecXmlUtils.decodeInt((String)numsecstr);
        }
        this.indexer = new SourceFileIndexer();
        this.indexer.restoreXml(parser);
        this.parseSpaces(parser);
        this.symtab = new SymbolTable();
        this.symtab.restoreXml(parser, this);
        this.root = ((SubtableSymbol)this.symtab.getGlobalScope().findSymbol("instruction")).getDecisionNode();
        parser.end(el);
    }

    private void parseSpaces(XmlPullParser parser) {
        Set<String> truncatedSpaceNames = this.description.getTruncatedSpaceNames();
        int truncatedSpaceCnt = truncatedSpaceNames.size();
        XmlElement el = parser.start(new String[]{"spaces"});
        String defname = el.getAttribute("defaultspace");
        this.spacetable = new LinkedHashMap();
        GenericAddressSpace constspc = new GenericAddressSpace("const", 64, 0, 0);
        this.spacetable.put("const", constspc);
        this.default_space = null;
        XmlElement subel = parser.peek();
        if (subel.getName().equals("space_other")) {
            parser.discardSubTree();
        } else {
            throw new SleighException(".sla file missing required OTHER space tag");
        }
        while ((subel = parser.softStart(new String[]{"space", "space_unique"})) != null) {
            GenericAddressSpace spc;
            boolean truncateSpace;
            String name = subel.getAttribute("name");
            int index = SpecXmlUtils.decodeInt((String)subel.getAttribute("index"));
            String typename = subel.getName();
            int delay = SpecXmlUtils.decodeInt((String)subel.getAttribute("delay"));
            int size = SpecXmlUtils.decodeInt((String)subel.getAttribute("size"));
            int type = 14;
            if (typename.equals("space")) {
                type = delay > 0 ? 1 : 4;
            } else if (typename.equals("space_unique")) {
                type = 3;
            }
            if (type == 14) {
                throw new SleighException("Sleigh cannot match new space definition to old type");
            }
            String wSizeString = subel.getAttribute("wordsize");
            int wordsize = 1;
            if (wSizeString != null) {
                wordsize = SpecXmlUtils.decodeInt((String)wSizeString);
            }
            if ((truncateSpace = truncatedSpaceNames.contains(name)) && type != 1) {
                throw new SleighException("Non-ram space does not support truncation: " + name);
            }
            if (this.getSegmentedSpace().equals(name)) {
                if (truncateSpace && type != 1) {
                    throw new SleighException("Segmented space does not support truncation: " + name);
                }
                spc = this.segmentType.equals("protected") ? new ProtectedAddressSpace(name, index) : new SegmentedAddressSpace(name, index);
            } else {
                if (truncateSpace) {
                    int truncatedSize = this.description.getTruncatedSpaceSize(name);
                    if (truncatedSize <= 0 || truncatedSize >= size) {
                        throw new SleighException("Invalid space truncation: " + name + ":" + size + " -> " + truncatedSize);
                    }
                    size = truncatedSize;
                    --truncatedSpaceCnt;
                }
                spc = new GenericAddressSpace(name, 8 * size, wordsize, type, index);
            }
            this.spacetable.put(name, spc);
            parser.end(subel);
        }
        if (truncatedSpaceCnt > 0) {
            throw new SleighException("One or more truncated spaced not applied: " + this.description.getLanguageID());
        }
        this.defaultDataSpace = this.default_space = this.spacetable.get(defname);
        this.defaultPointerWordSize = this.defaultDataSpace.getAddressableUnitSize();
        this.buildAddressSpaceFactory();
        parser.end(el);
    }

    void buildAddressSpaceFactory() {
        AddressSpace[] spaceArray = new GenericAddressSpace[this.spacetable.size()];
        this.spacetable.values().toArray(spaceArray);
        this.addressFactory = new DefaultAddressFactory(spaceArray, this.default_space);
    }

    private void loadRegisters(RegisterBuilder builder) {
        Symbol[] symbollist;
        for (Symbol element : symbollist = this.symtab.getSymbolList()) {
            ValueSymbol sym;
            if (element instanceof VarnodeSymbol) {
                Address a;
                VarnodeData vn = ((VarnodeSymbol)element).getFixedVarnode();
                if (vn.space.getType() == 4) {
                    a = vn.space.getAddress(vn.offset);
                    builder.addRegister(element.getName(), null, a, vn.size, this.description.getEndian().isBigEndian(), 0);
                }
                if (vn.space.getType() != 1) continue;
                a = vn.space.getAddress(vn.offset);
                builder.addRegister(element.getName(), null, a, vn.size, this.description.getEndian().isBigEndian(), 0);
                if (!vn.space.isMemorySpace()) continue;
                this.setHasMappedRegisters(vn.space);
                continue;
            }
            if (element instanceof VarnodeListSymbol) {
                sym = (VarnodeListSymbol)element;
                PatternValue patternValue = sym.getPatternValue();
                if (!(patternValue instanceof ContextField)) continue;
                this.registerContext(sym.getName(), (ContextField)patternValue, builder);
                continue;
            }
            if (!(element instanceof ContextSymbol)) continue;
            sym = (ContextSymbol)element;
            this.registerContext((ContextSymbol)sym, builder);
        }
    }

    private void setHasMappedRegisters(AddressSpace space) {
        if (space instanceof GenericAddressSpace) {
            ((GenericAddressSpace)space).setHasMappedRegisters(true);
        }
    }

    private void registerContext(String name, ContextField field, RegisterBuilder builder) {
        int startbit = field.getStartBit();
        int endbit = field.getEndBit();
        int bitLength = endbit - startbit + 1;
        int contextByteLength = endbit / 8 + 1;
        int contextBitLength = contextByteLength * 8;
        int flags = 8;
        builder.addRegister(name, name, builder.getProcessContextAddress(), contextByteLength, contextBitLength - endbit - 1, bitLength, true, flags);
    }

    private void registerContext(ContextSymbol sym, RegisterBuilder builder) {
        ContextField field = (ContextField)sym.getPatternValue();
        int startbit = field.getStartBit();
        int endbit = field.getEndBit();
        int bitLength = endbit - startbit + 1;
        VarnodeData vn = sym.getVarnode().getFixedVarnode();
        int contextBitLength = vn.size * 8;
        Address a = vn.space.getAddress(vn.offset);
        int flags = 8;
        if (!sym.followsFlow()) {
            flags |= 0x40;
        }
        builder.addRegister(sym.getName(), sym.getName(), a, vn.size, contextBitLength - endbit - 1, bitLength, true, flags);
    }

    private void xrefRegisters() {
        for (Register register : this.getRegisterManager().getContextRegisters()) {
            this.contextcache.registerVariable(register);
        }
    }

    @Override
    public AddressSpace getDefaultSpace() {
        return this.default_space;
    }

    @Override
    public AddressSpace getDefaultDataSpace() {
        return this.defaultDataSpace;
    }

    @Deprecated
    public int getDefaultPointerWordSize() {
        return this.defaultPointerWordSize;
    }

    @Override
    public List<CompilerSpecDescription> getCompatibleCompilerSpecDescriptions() {
        return this.description.getCompatibleCompilerSpecDescriptions();
    }

    @Override
    public CompilerSpec getCompilerSpecByID(CompilerSpecID compilerSpecID) throws CompilerSpecNotFoundException {
        if (!this.compilerSpecDescriptions.containsKey(compilerSpecID)) {
            throw new CompilerSpecNotFoundException(this.getLanguageID(), compilerSpecID);
        }
        SleighCompilerSpecDescription compilerSpecDescription = this.compilerSpecDescriptions.get(compilerSpecID);
        BasicCompilerSpec compilerSpec = this.compilerSpecs.get(compilerSpecID);
        if (compilerSpec == null) {
            compilerSpec = new BasicCompilerSpec((CompilerSpecDescription)compilerSpecDescription, this, compilerSpecDescription.getFile());
            this.compilerSpecs.put(compilerSpecID, compilerSpec);
        }
        return compilerSpec;
    }

    @Override
    public LanguageDescription getLanguageDescription() {
        return this.description;
    }

    @Override
    public CompilerSpec getDefaultCompilerSpec() {
        SleighCompilerSpecDescription compilerSpecDescription = (SleighCompilerSpecDescription)this.description.getCompatibleCompilerSpecDescriptions().iterator().next();
        try {
            return this.getCompilerSpecByID(compilerSpecDescription.getCompilerSpecID());
        }
        catch (CompilerSpecNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String getProperty(String key, String defaultString) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return defaultString;
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultBoolean) {
        if (this.properties.containsKey(key)) {
            return Boolean.parseBoolean(this.properties.get(key));
        }
        return defaultBoolean;
    }

    @Override
    public int getPropertyAsInt(String key, int defaultInt) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.get(key));
        }
        return defaultInt;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public ManualEntry getManualEntry(String instruction) {
        SortedMap<String, ManualEntry> subMap;
        this.initManual();
        if (instruction == null || instruction.length() == 0) {
            return (ManualEntry)this.manual.get(null);
        }
        instruction = instruction.toUpperCase();
        String firstKey = instruction.substring(0, 1);
        String lastKey = Character.toString((char)(firstKey.charAt(0) + '\u0001'));
        SortedMap<String, ManualEntry> tail = this.manual.tailMap(firstKey);
        try {
            subMap = tail.headMap(lastKey);
        }
        catch (IllegalArgumentException e) {
            subMap = tail;
        }
        ManualEntry manualEntry = null;
        int maxInCommon = -1;
        for (Map.Entry<String, ManualEntry> mapEntry : subMap.entrySet()) {
            String key = mapEntry.getKey();
            if (!instruction.startsWith(key) || key.length() <= maxInCommon) continue;
            manualEntry = mapEntry.getValue();
            maxInCommon = key.length();
        }
        if (manualEntry == null) {
            return (ManualEntry)this.manual.get(null);
        }
        return manualEntry;
    }

    @Override
    public Set<String> getManualInstructionMnemonicKeys() {
        this.initManual();
        return Collections.unmodifiableSet(this.manual.keySet());
    }

    private void initManual() {
        if (this.manual == null) {
            this.manual = new TreeMap<String, ManualEntry>(CASE_INSENSITIVE);
            try {
                if (this.description.getManualIndexFile() != null) {
                    this.loadIndex(this.description.getManualIndexFile());
                }
            }
            catch (Exception e) {
                this.manualException = e;
                Msg.error((Object)this, (Object)"error loading manual index", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndex(ResourceFile processorFile) throws IOException {
        ResourceFile manualDirectory = processorFile.getParentFile().getCanonicalFile();
        ResourceFile currentManual = null;
        ResourceFile defaultManual = null;
        String missingDescription = "(no information available)";
        InputStreamReader fr = null;
        BufferedReader buff = null;
        try {
            String line;
            fr = new InputStreamReader(processorFile.getInputStream());
            buff = new BufferedReader(fr);
            while ((line = buff.readLine()) != null) {
                FileResolutionResult result;
                Matcher matcher = COMMENT.matcher(line);
                if (matcher.find()) continue;
                matcher = FILE_INCLUDE.matcher(line);
                if (matcher.find()) {
                    String includeFilePath = matcher.group(1).trim();
                    ResourceFile includedIndexFile = new ResourceFile(manualDirectory, includeFilePath);
                    FileResolutionResult result2 = FileUtilities.existsAndIsCaseDependent((ResourceFile)includedIndexFile);
                    if (!result2.isOk()) {
                        throw new SleighException("manual index file " + includedIndexFile + " is not properly case dependent: " + result2.getMessage());
                    }
                    this.loadIndex(includedIndexFile);
                    continue;
                }
                matcher = FILE_SWITCH_WITH_DESCRIPTION.matcher(line);
                if (matcher.find()) {
                    if (SystemUtilities.isInDevelopmentMode()) {
                        currentManual = Application.findDataFileInAnyModule((String)("manuals/" + matcher.group(1).trim()));
                    }
                    if (currentManual == null) {
                        currentManual = new ResourceFile(manualDirectory, matcher.group(1).trim());
                    }
                    result = FileUtilities.existsAndIsCaseDependent(currentManual);
                    missingDescription = matcher.group(2).trim();
                    if (defaultManual == null) {
                        defaultManual = currentManual;
                    }
                    if (result.isOk()) continue;
                    Msg.warn((Object)this, (Object)("manual file " + currentManual + " not found or is not properly case dependent.\n  >>  " + missingDescription));
                    continue;
                }
                matcher = FILE_SWITCH.matcher(line);
                if (matcher.find()) {
                    currentManual = new ResourceFile(manualDirectory, matcher.group(1).trim());
                    result = FileUtilities.existsAndIsCaseDependent((ResourceFile)currentManual);
                    if (!result.isOk()) {
                        throw new SleighException("manual file " + currentManual + " is not properly case dependent: " + result.getMessage());
                    }
                    missingDescription = "(no information available)";
                    if (defaultManual != null) continue;
                    defaultManual = currentManual;
                    continue;
                }
                matcher = INSTRUCTION.matcher(line);
                if (!matcher.find()) continue;
                if (currentManual == null) {
                    throw new IOException("index file " + processorFile + " does not specify manual first");
                }
                String mnemonic = matcher.group(1).trim().toUpperCase();
                String page = matcher.group(2).trim();
                ManualEntry entry = new ManualEntry(mnemonic, currentManual.getAbsolutePath(), missingDescription, page);
                this.manual.put(mnemonic, entry);
            }
            if (defaultManual != null) {
                this.manual.put(null, new ManualEntry(null, defaultManual.getAbsolutePath(), missingDescription, null));
            }
        }
        finally {
            if (fr != null) {
                ((Reader)fr).close();
            }
            if (buff != null) {
                buff.close();
            }
        }
    }

    @Override
    public Exception getManualException() {
        this.initManual();
        return this.manualException;
    }

    @Override
    public boolean hasManual() {
        this.initManual();
        return this.description.getManualIndexFile() != null && this.manualException == null;
    }

    public void encodeTranslator(Encoder encoder, AddressFactory factory, long uniqueOffset) throws IOException {
        AddressSpace[] spclist = factory.getAllAddressSpaces();
        encoder.openElement(ElementId.ELEM_SLEIGH);
        encoder.writeBool(AttributeId.ATTRIB_BIGENDIAN, this.isBigEndian());
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_UNIQBASE, uniqueOffset);
        encoder.openElement(ElementId.ELEM_SPACES);
        encoder.writeString(AttributeId.ATTRIB_DEFAULTSPACE, factory.getDefaultAddressSpace().getName());
        block6: for (AddressSpace element : spclist) {
            boolean physical;
            int delay;
            ElementId tag;
            if (element instanceof OverlayAddressSpace) {
                OverlayAddressSpace ospace = (OverlayAddressSpace)element;
                encoder.openElement(ElementId.ELEM_SPACE_OVERLAY);
                encoder.writeString(AttributeId.ATTRIB_NAME, ospace.getName());
                encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, ospace.getUnique());
                encoder.writeSpace(AttributeId.ATTRIB_BASE, ospace.getOverlayedSpace());
                encoder.closeElement(ElementId.ELEM_SPACE_OVERLAY);
                continue;
            }
            switch (element.getType()) {
                case 1: {
                    tag = ElementId.ELEM_SPACE;
                    delay = 1;
                    physical = true;
                    break;
                }
                case 4: {
                    tag = ElementId.ELEM_SPACE;
                    delay = 0;
                    physical = true;
                    break;
                }
                case 3: {
                    tag = ElementId.ELEM_SPACE_UNIQUE;
                    delay = 0;
                    physical = true;
                    break;
                }
                case 7: {
                    tag = ElementId.ELEM_SPACE_OTHER;
                    delay = 0;
                    physical = true;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            encoder.openElement(tag);
            encoder.writeString(AttributeId.ATTRIB_NAME, element.getName());
            encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, element.getUnique());
            int size = element.getSize();
            if (element instanceof SegmentedAddressSpace) {
                size = 32;
            }
            if (size > 64) {
                size = 64;
            }
            int bytesize = (size + 7) / 8;
            encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, bytesize);
            if (element.getAddressableUnitSize() > 1) {
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_WORDSIZE, element.getAddressableUnitSize());
            }
            encoder.writeBool(AttributeId.ATTRIB_BIGENDIAN, this.isBigEndian());
            encoder.writeSignedInteger(AttributeId.ATTRIB_DELAY, delay);
            encoder.writeBool(AttributeId.ATTRIB_PHYSICAL, physical);
            encoder.closeElement(tag);
        }
        encoder.closeElement(ElementId.ELEM_SPACES);
        SleighLanguageDescription sleighDescription = (SleighLanguageDescription)this.getLanguageDescription();
        Set<String> truncatedSpaceNames = sleighDescription.getTruncatedSpaceNames();
        if (!truncatedSpaceNames.isEmpty()) {
            for (String spaceName : truncatedSpaceNames) {
                int sz = sleighDescription.getTruncatedSpaceSize(spaceName);
                encoder.openElement(ElementId.ELEM_TRUNCATE_SPACE);
                encoder.writeString(AttributeId.ATTRIB_SPACE, spaceName);
                encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, sz);
                encoder.closeElement(ElementId.ELEM_TRUNCATE_SPACE);
            }
        }
        encoder.closeElement(ElementId.ELEM_SLEIGH);
    }

    private void initParallelHelper() {
        String className = this.getProperty("parallelInstructionHelperClass");
        if (className == null) {
            return;
        }
        try {
            Class<?> helperClass = Class.forName(className);
            if (!ParallelInstructionLanguageHelper.class.isAssignableFrom(helperClass)) {
                Msg.error((Object)this, (Object)("Invalid Class specified for parallelInstructionHelperClass (" + helperClass.getName() + "): " + this.description.getSpecFile()));
            } else {
                this.parallelHelper = (ParallelInstructionLanguageHelper)helperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new SleighException("Failed to instantiate parallelInstructionHelperClass (" + className + "): " + this.description.getSpecFile(), e);
        }
    }

    @Override
    public ParallelInstructionLanguageHelper getParallelInstructionHelper() {
        return this.parallelHelper;
    }

    @Override
    public List<Register> getSortedVectorRegisters() {
        return this.registerManager.getSortedVectorRegisters();
    }

    @Override
    public AddressSetView getRegisterAddresses() {
        return this.registerManager.getRegisterAddresses();
    }
}

