/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DecompilerUtils {
    public static Varnode getVarnodeRef(ClangToken token) {
        Varnode res;
        if (token == null) {
            return null;
        }
        if (token instanceof ClangVariableToken && (res = token.getVarnode()) != null) {
            return res;
        }
        ClangNode parent = token.Parent();
        if (parent instanceof ClangVariableDecl) {
            HighVariable high = ((ClangVariableDecl)parent).getHighVariable();
            if ((parent = parent.Parent()) instanceof ClangFuncProto && high != null) {
                Varnode[] instances;
                for (Varnode instance : instances = high.getInstances()) {
                    if (!instance.isInput()) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    public static Set<Varnode> getForwardSlice(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn)) continue;
            Iterator it = curvn.getDescendants();
            while (it.hasNext()) {
                PcodeOp op = (PcodeOp)it.next();
                if (op == null || (curvn = op.getOutput()) == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
                worklist.add(curvn);
            }
        }
        return varnodes;
    }

    public static Set<Varnode> getBackwardSlice(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            PcodeOp op;
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn) || (op = curvn.getDef()) == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
            for (int j = 0; j < op.getNumInputs(); ++j) {
                curvn = op.getInput(j);
                if (curvn == null) continue;
                worklist.add(curvn);
            }
        }
        return varnodes;
    }

    public static Set<PcodeOp> getForwardSliceToPCodeOps(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        HashSet<PcodeOp> pcodeops = new HashSet<PcodeOp>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            Varnode curvn = (Varnode)worklist.get(i);
            if (!varnodes.add(curvn)) continue;
            Iterator it = curvn.getDescendants();
            while (it.hasNext()) {
                PcodeOp op = (PcodeOp)it.next();
                if (op == null) continue;
                pcodeops.add(op);
                curvn = op.getOutput();
                if (curvn == null || op.getOpcode() == 7 || op.getOpcode() == 8) continue;
                worklist.add(curvn);
            }
        }
        return pcodeops;
    }

    public static Set<PcodeOp> getBackwardSliceToPCodeOps(Varnode seed) {
        HashSet<Varnode> varnodes = new HashSet<Varnode>();
        HashSet<PcodeOp> pcodeops = new HashSet<PcodeOp>();
        ArrayList<Varnode> worklist = new ArrayList<Varnode>();
        worklist.add(seed);
        for (int i = 0; i < worklist.size(); ++i) {
            PcodeOp op;
            Varnode curvn = (Varnode)worklist.get(i);
            worklist.get(i);
            if (!varnodes.add(curvn) || (op = curvn.getDef()) == null) continue;
            pcodeops.add(op);
            if (op.getOpcode() == 7 || op.getOpcode() == 8) continue;
            for (int j = 0; j < op.getNumInputs(); ++j) {
                Varnode input = op.getInput(j);
                if (input == null) continue;
                worklist.add(input);
            }
        }
        return pcodeops;
    }

    public static Function getFunction(Program program, ClangFuncNameToken token) {
        PcodeOp pcodeOp;
        ClangFunction clangFunction;
        ClangNode parent = token.Parent();
        if (parent instanceof ClangFuncProto && (clangFunction = parent.getClangFunction()) != null) {
            return clangFunction.getHighFunction().getFunction();
        }
        if (parent instanceof ClangStatement && (pcodeOp = token.getPcodeOp()) != null && pcodeOp.getOpcode() == 7) {
            Address functionAddr = pcodeOp.getInput(0).getAddress();
            return program.getFunctionManager().getReferencedFunction(functionAddr);
        }
        return null;
    }

    public static int findIndexOfFirstField(List<ClangToken> queryTokens, Field[] fields) {
        if (queryTokens.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < fields.length; ++i) {
            ClangTextField f = (ClangTextField)fields[i];
            List<ClangToken> fieldTokens = f.getTokens();
            for (int j = 0; j < fieldTokens.size(); ++j) {
                ClangNode fieldToken = fieldTokens.get(j);
                if (!queryTokens.contains(fieldToken)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<ClangToken> getTokensFromView(Field[] fields, Address address) {
        AddressSet set = new AddressSet(address);
        ArrayList<ClangToken> result = new ArrayList<ClangToken>();
        for (Field f : fields) {
            ClangTextField tf = (ClangTextField)f;
            List<ClangToken> fieldTokens = tf.getTokens();
            for (ClangToken token : fieldTokens) {
                if (!DecompilerUtils.intersects(token, (AddressSetView)set)) continue;
                result.add(token);
            }
        }
        return result;
    }

    public static List<ClangToken> getTokens(ClangNode root, AddressSetView addressSet) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        DecompilerUtils.collectTokens(tokenList, root, addressSet);
        return tokenList;
    }

    public static List<ClangToken> getTokens(ClangNode root, Address address) {
        AddressSet set = new AddressSet(address);
        return DecompilerUtils.getTokens(root, (AddressSetView)set);
    }

    private static void collectTokens(List<ClangToken> tokenList, ClangNode parentNode, AddressSetView addressSet) {
        int nchild = parentNode.numChildren();
        for (int i = 0; i < nchild; ++i) {
            ClangToken token;
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                DecompilerUtils.collectTokens(tokenList, node, addressSet);
                continue;
            }
            if (!(node instanceof ClangToken) || !DecompilerUtils.intersects(token = (ClangToken)node, addressSet)) continue;
            tokenList.add((ClangToken)node);
        }
    }

    private static boolean intersects(ClangToken token, AddressSetView addressSet) {
        Address minAddress = token.getMinAddress();
        if (minAddress == null) {
            return false;
        }
        Address maxAddress = token.getMaxAddress();
        maxAddress = maxAddress == null ? minAddress : maxAddress;
        return addressSet.intersects(minAddress, maxAddress);
    }

    public static Address getClosestAddress(Program program, ClangToken token) {
        Address address = token.getMinAddress();
        if (address != null) {
            return address;
        }
        ClangToken addressedToken = DecompilerUtils.findClosestAddressedToken(token);
        if (addressedToken == null) {
            return null;
        }
        return addressedToken.getMinAddress();
    }

    public static AddressSet findClosestAddressSet(Program program, AddressSpace functionSpace, List<ClangToken> tokenList) {
        AddressSet addressSet = new AddressSet();
        for (ClangToken tok : tokenList) {
            DecompilerUtils.addTokenAddressRangeToSet(addressSet, tok, functionSpace);
        }
        if (addressSet.isEmpty()) {
            ClangLine lastLine = null;
            for (ClangToken token : tokenList) {
                if (token.getLineParent() == lastLine) continue;
                lastLine = token.getLineParent();
                token = DecompilerUtils.findClosestAddressedToken(token);
                DecompilerUtils.addTokenAddressRangeToSet(addressSet, token, functionSpace);
            }
        }
        return addressSet;
    }

    private static void addTokenAddressRangeToSet(AddressSet addrs, ClangToken token, AddressSpace space) {
        if (token == null || token.getMinAddress() == null) {
            return;
        }
        Address minAddress = token.getMinAddress();
        Address maxAddress = token.getMaxAddress();
        maxAddress = maxAddress == null ? minAddress : maxAddress;
        addrs.addRange(minAddress, maxAddress);
    }

    private static ClangToken findClosestAddressedToken(ClangToken token) {
        int i;
        if (token == null) {
            return null;
        }
        if (token.getMinAddress() != null) {
            return token;
        }
        ArrayList<ClangToken> lineTokens = token.getLineParent().getAllTokens();
        int tokIndex = -1;
        int lastIndex = lineTokens.size() - 1;
        for (i = 0; i <= lastIndex; ++i) {
            if (lineTokens.get(i) != token) continue;
            tokIndex = i;
            break;
        }
        if (tokIndex != -1) {
            ClangToken tok;
            for (i = tokIndex + 1; i <= lastIndex; ++i) {
                tok = (ClangToken)lineTokens.get(i);
                if (tok.getMinAddress() == null) continue;
                return tok;
            }
            for (i = tokIndex - 1; i >= 0; --i) {
                tok = (ClangToken)lineTokens.get(i);
                if (tok.getMinAddress() == null) continue;
                return tok;
            }
        }
        return null;
    }

    public static FieldSelection getFieldSelection(List<ClangToken> tokens) {
        FieldSelection fieldSelection = new FieldSelection();
        for (ClangToken clangToken : tokens) {
            ClangLine lineParent = clangToken.getLineParent();
            if (lineParent == null) continue;
            int lineNumber = lineParent.getLineNumber();
            fieldSelection.addRange(lineNumber - 1, lineNumber);
        }
        return fieldSelection;
    }

    public static List<ClangToken> getTokensInSelection(FieldSelection selection, Field[] lines) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange subSelectionRange = selection.getFieldRange(i);
            DecompilerUtils.addTokensInSelectionRange(tokenList, subSelectionRange, lines);
        }
        return tokenList;
    }

    private static void addTokensInSelectionRange(List<ClangToken> tokenList, FieldRange selectionRange, Field[] lines) {
        FieldLocation end;
        FieldLocation start = selectionRange.getStart();
        if (start.equals((Object)(end = selectionRange.getEnd()))) {
            return;
        }
        if (start.getIndex().intValue() == end.getIndex().intValue()) {
            DecompilerUtils.addTokens(tokenList, lines, start.getIndex().intValue(), start, end);
        } else {
            DecompilerUtils.addTokens(tokenList, lines, start.getIndex().intValue(), start, null);
            for (int i = start.getIndex().intValue() + 1; i < end.getIndex().intValue(); ++i) {
                DecompilerUtils.addTokens(tokenList, lines, i, null, null);
            }
            DecompilerUtils.addTokens(tokenList, lines, end.getIndex().intValue(), null, end);
        }
    }

    private static void addTokens(List<ClangToken> tokenList, Field[] lines, int lineNumber, FieldLocation start, FieldLocation end) {
        int endIndex;
        if (lineNumber >= lines.length) {
            return;
        }
        ClangTextField textLine = (ClangTextField)lines[lineNumber];
        int startIndex = DecompilerUtils.getStartIndex(textLine, start);
        if (startIndex >= (endIndex = DecompilerUtils.getEndIndex(textLine, end))) {
            return;
        }
        tokenList.addAll(textLine.getTokens().subList(startIndex, endIndex));
    }

    private static int getStartIndex(ClangTextField textLine, FieldLocation location) {
        if (location == null) {
            return 0;
        }
        int tokenIndex = textLine.getTokenIndex(location);
        return tokenIndex;
    }

    private static int getEndIndex(ClangTextField textLine, FieldLocation location) {
        if (location == null) {
            return textLine.getTokens().size();
        }
        if (location.row == 0 && location.col == 0) {
            return 0;
        }
        int nextTokenIndex = textLine.getNextTokenIndexStartingAfter(location);
        return nextTokenIndex;
    }

    public static Address findAddressBefore(Field[] lines, ClangToken token) {
        ClangLine lineParent = token.getLineParent();
        int lineNumber = lineParent.getLineNumber();
        for (int i = lineNumber - 1; i >= 0; --i) {
            ClangTextField textLine = (ClangTextField)lines[i];
            List<ClangToken> tokens = textLine.getTokens();
            ClangToken addressedToken = DecompilerUtils.findClosestAddressedToken(tokens.get(0));
            if (addressedToken == null) continue;
            return addressedToken.getMinAddress();
        }
        return null;
    }

    public static ClangLabelToken getGoToTargetToken(ClangTokenGroup root, ClangLabelToken label) {
        ClangNode parent = label.Parent();
        if (!(parent instanceof ClangStatement)) {
            return null;
        }
        ClangStatement statement = (ClangStatement)parent;
        if (!DecompilerUtils.isGoToStatement(statement)) {
            return null;
        }
        String destinationStart = label.getText() + ":";
        Address address = label.getMinAddress();
        List<ClangToken> tokens = DecompilerUtils.getTokens((ClangNode)root, address);
        for (ClangToken token : tokens) {
            ClangNode tokenParent;
            String parentText;
            if (DecompilerUtils.isGoToStatement(token) || !(token instanceof ClangLabelToken) || !(parentText = (tokenParent = token.Parent()).toString()).startsWith(destinationStart)) continue;
            return (ClangLabelToken)token;
        }
        return null;
    }

    public static ClangSyntaxToken getNextBrace(ClangToken startToken, boolean forward) {
        int targetBalance = forward ? -1 : 1;
        Iterator<ClangToken> iter = startToken.iterator(forward);
        iter.next();
        int nestLevel = 0;
        while (iter.hasNext()) {
            String text;
            ClangToken token = iter.next();
            if (!(token instanceof ClangSyntaxToken) || !((text = token.getText()).equals("{") ? ++nestLevel == targetBalance : text.equals("}") && --nestLevel == targetBalance)) continue;
            return (ClangSyntaxToken)token;
        }
        return null;
    }

    public static ClangSyntaxToken getMatchingBrace(ClangSyntaxToken startToken) {
        boolean direction = "{".equals(startToken.getText());
        Iterator<ClangToken> iter = startToken.iterator(direction);
        int nestLevel = 0;
        while (iter.hasNext()) {
            String text;
            ClangToken token = iter.next();
            if (!(token instanceof ClangSyntaxToken) || !((text = token.getText()).equals("{") ? ++nestLevel == 0 : text.equals("}") && --nestLevel == 0)) continue;
            return (ClangSyntaxToken)token;
        }
        return null;
    }

    public static boolean isBrace(ClangToken token) {
        String text = token.getText();
        return "{".equals(text) || "}".equals(text);
    }

    public static boolean isGoToStatement(ClangToken token) {
        ClangNode parent = token.Parent();
        if (!(parent instanceof ClangStatement)) {
            return false;
        }
        return DecompilerUtils.isGoToStatement((ClangStatement)parent);
    }

    private static boolean isGoToStatement(ClangStatement statement) {
        String text = statement.toString();
        return text.startsWith("goto");
    }

    private static int consumeCommentTokens(List<ClangNode> alltoks, int i, ClangCommentToken first, ClangLine current, StringBuilder builder) {
        builder.setLength(0);
        builder.append(first.getText());
        ++i;
        while (i < alltoks.size()) {
            ClangToken tok = (ClangToken)alltoks.get(i);
            if (tok instanceof ClangCommentToken) {
                if (first.getSyntaxType() != tok.getSyntaxType()) break;
                builder.append(tok.getText());
            } else {
                String val;
                if (!(tok instanceof ClangSyntaxToken) || !(val = tok.getText()).isBlank()) break;
                builder.append(val);
            }
            ++i;
        }
        ClangCommentToken commentToken = ClangCommentToken.derive(first, builder.toString());
        commentToken.setLineParent(current);
        current.addToken(commentToken);
        return i;
    }

    public static ArrayList<ClangLine> toLines(ClangTokenGroup group) {
        ClangLine current;
        ClangBreak brk;
        ArrayList<ClangNode> alltoks = new ArrayList<ClangNode>();
        group.flatten(alltoks);
        if (alltoks.isEmpty()) {
            return new ArrayList<ClangLine>();
        }
        int i = 0;
        int lineNumber = 1;
        ArrayList<ClangLine> lines = new ArrayList<ClangLine>();
        if (alltoks.get(0) instanceof ClangBreak) {
            brk = (ClangBreak)alltoks.get(0);
            current = new ClangLine(lineNumber++, brk.getIndent());
            ++i;
        } else {
            current = new ClangLine(lineNumber++, 0);
        }
        StringBuilder commentBuilder = new StringBuilder();
        while (i < alltoks.size()) {
            ClangToken tok = (ClangToken)alltoks.get(i);
            if (tok instanceof ClangBreak) {
                lines.add(current);
                brk = (ClangBreak)tok;
                current = new ClangLine(lineNumber++, brk.getIndent());
            } else if (tok instanceof ClangCommentToken) {
                i = DecompilerUtils.consumeCommentTokens(alltoks, i, (ClangCommentToken)tok, current, commentBuilder);
                --i;
            } else {
                tok.setLineParent(current);
                current.addToken(tok);
            }
            ++i;
        }
        lines.add(current);
        return lines;
    }

    public static DataType getDataType(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        ClangToken token = decompilerPanel.getSelectedToken();
        if (token == null) {
            token = context.getTokenAtCursor();
        }
        return DecompilerUtils.getDataType(token);
    }

    public static DataType getDataType(ClangToken token) {
        DataType dataType;
        HighVariable highVariable;
        Varnode varnode = DecompilerUtils.getVarnodeRef(token);
        if (varnode != null && (highVariable = varnode.getHigh()) != null) {
            DataType dataType2 = highVariable.getDataType();
            return dataType2;
        }
        if (token instanceof ClangTypeToken) {
            dataType = ((ClangTypeToken)token).getDataType();
            return dataType;
        }
        if (token instanceof ClangFieldToken) {
            dataType = ((ClangFieldToken)token).getDataType();
            return dataType;
        }
        return null;
    }
}

