/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.FindDialog;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DualDecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearcher;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import org.apache.commons.lang3.StringUtils;

public class DecompilerDiffViewFindAction
extends DockingAction {
    private FindDialog leftFindDialog;
    private FindDialog rightFindDialog;
    private PluginTool tool;

    public DecompilerDiffViewFindAction(String owner, PluginTool tool) {
        super("Find", owner, true);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        this.setPopupMenuData(new MenuData(new String[]{"Find..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setEnabled(true);
        this.tool = tool;
    }

    public boolean isAddToPopup(ActionContext context) {
        return context instanceof DualDecompilerActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DualDecompilerActionContext)) {
            return false;
        }
        DualDecompilerActionContext dualContext = (DualDecompilerActionContext)context;
        CodeComparisonPanel<? extends FieldPanelCoordinator> compPanel = dualContext.getCodeComparisonPanel();
        if (!(compPanel instanceof DecompilerCodeComparisonPanel)) {
            return false;
        }
        DecompilerCodeComparisonPanel decompilerCompPanel = (DecompilerCodeComparisonPanel)compPanel;
        return true;
    }

    public void actionPerformed(ActionContext context) {
        String text;
        DualDecompilerActionContext dualContext = (DualDecompilerActionContext)context;
        DecompilerCodeComparisonPanel decompilerCompPanel = (DecompilerCodeComparisonPanel)dualContext.getCodeComparisonPanel();
        DecompilerPanel focusedPanel = decompilerCompPanel.getLeftDecompilerPanel();
        FindDialog dialog = this.leftFindDialog;
        if (!decompilerCompPanel.leftPanelHasFocus()) {
            focusedPanel = decompilerCompPanel.getRightDecompilerPanel();
            dialog = this.rightFindDialog;
        }
        if (dialog == null) {
            dialog = this.createFindDialog(focusedPanel, decompilerCompPanel.leftPanelHasFocus());
        }
        if (!StringUtils.isBlank((CharSequence)(text = focusedPanel.getSelectedText()))) {
            dialog.setSearchText(text);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private FindDialog createFindDialog(final DecompilerPanel decompilerPanel, boolean isLeftFocused) {
        Object title = isLeftFocused ? "Left" : "Right";
        title = (String)title + " Decompiler Find Text";
        FindDialog dialog = new FindDialog((String)title, new DecompilerSearcher(decompilerPanel)){

            protected void dialogClosed() {
                decompilerPanel.setSearchResults(null);
            }
        };
        dialog.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        if (isLeftFocused) {
            this.leftFindDialog = dialog;
        } else {
            this.rightFindDialog = dialog;
        }
        return dialog;
    }
}

