/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractWithMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class WithSymbolApplier
extends MsSymbolApplier {
    private AbstractWithMsSymbol symbol;

    public WithSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractWithMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractWithMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.pdbLogAndInfoMessage(this, "Cannot apply " + this.getClass().getSimpleName() + " directly to program");
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        if (applierParam instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applierParam;
            Address address = this.applicator.getAddress(this.symbol);
            functionSymbolApplier.beginBlock(address, this.symbol.getExpression(), this.symbol.getLength());
        }
    }
}

