/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.TrampolineMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DeferrableFunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class TrampolineSymbolApplier
extends MsSymbolApplier
implements DeferrableFunctionSymbolApplier {
    private TrampolineMsSymbol symbol;
    private Address address;

    public TrampolineSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof TrampolineMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (TrampolineMsSymbol)abstractSymbol;
        this.address = applicator.getAddress(this.symbol);
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws CancelledException, PdbException {
        Address targetAddress = this.applicator.getAddress(this.symbol.getSegmentTarget(), this.symbol.getOffsetTarget());
        Function target = null;
        Function thunk = null;
        if (!this.applicator.isInvalidAddress(targetAddress, "thunk target")) {
            target = this.applicator.getExistingOrCreateOneByteFunction(targetAddress);
        }
        if (!this.applicator.isInvalidAddress(this.address, "thunk symbol")) {
            thunk = this.applicator.getExistingOrCreateOneByteFunction(this.address);
        }
        if (target != null && thunk != null) {
            thunk.setThunkedFunction(target);
        }
        this.applicator.scheduleDeferredFunctionWork(this);
    }

    @Override
    public Address getAddress() {
        return this.address;
    }
}

