/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractPublicMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.util.Msg;
import java.util.HashSet;
import java.util.Set;

public class PdbApplicatorMetrics {
    private static final Set<Integer> EXPECTED_GLOBAL_SYMBOLS = Set.of(1025, 4390, 4391, 1027, 4389, 1024, 4392, 4393, 258, 514, 4365, 4104, 257, 513, 4364, 4103, 4381, 4129, 4380, 4128, 526, 4371, 4111, 525, 4370, 4110, 11, 4361, 4100, 4, 4360, 4099, 3, 4359, 4098, 4397);
    private static final Set<Integer> EXPECTED_LINKER_SYMBOLS = Set.of(Integer.valueOf(4406), Integer.valueOf(4396), Integer.valueOf(4353), Integer.valueOf(4412), Integer.valueOf(4374), Integer.valueOf(4115), Integer.valueOf(4413));
    private Set<Class<? extends AbstractMsType>> cannotApplyTypes = new HashSet<Class<? extends AbstractMsType>>();
    private Set<Class<? extends AbstractMsType>> unexpectedMemberFunctionThisPointerTypes = new HashSet<Class<? extends AbstractMsType>>();
    private Set<Class<? extends AbstractMsType>> unexpectedMemberFunctionThisPointerUnderlyingTypes = new HashSet<Class<? extends AbstractMsType>>();
    private Set<Class<? extends AbstractMsType>> unexpectedMemberFunctionContainerTypes = new HashSet<Class<? extends AbstractMsType>>();
    private Set<Class<? extends AbstractMsSymbol>> cannotApplySymbols = new HashSet<Class<? extends AbstractMsSymbol>>();
    private Set<Class<? extends AbstractMsSymbol>> unexpectedGlobalSymbols = new HashSet<Class<? extends AbstractMsSymbol>>();
    private Set<Class<? extends AbstractMsSymbol>> unexpectedPublicSymbols = new HashSet<Class<? extends AbstractMsSymbol>>();
    private boolean witnessEnumerateNarrowing = false;

    void witnessCannotApplyDataType(AbstractMsType type) {
        this.cannotApplyTypes.add(type.getClass());
    }

    void witnessCannotApplySymbolType(AbstractMsSymbol symbol) {
        this.cannotApplySymbols.add(symbol.getClass());
    }

    void witnessGlobalSymbolType(AbstractMsSymbol symbol) {
        if (!EXPECTED_GLOBAL_SYMBOLS.contains(symbol.getPdbId())) {
            this.unexpectedGlobalSymbols.add(symbol.getClass());
        }
    }

    void witnessPublicSymbolType(AbstractMsSymbol symbol) {
        if (!(symbol instanceof AbstractPublicMsSymbol)) {
            this.unexpectedPublicSymbols.add(symbol.getClass());
        }
    }

    void witnessLinkerSymbolType(AbstractMsSymbol symbol) {
        if (!EXPECTED_LINKER_SYMBOLS.contains(symbol.getPdbId())) {
            // empty if block
        }
    }

    void witnessEnumerateNarrowing() {
        this.witnessEnumerateNarrowing = true;
    }

    void witnessMemberFunctionThisPointer(AbstractMsType type) {
        if (type == null) {
            return;
        }
        if (type instanceof AbstractPointerMsType) {
            AbstractPointerMsType ptrType = (AbstractPointerMsType)type;
            this.witnessMemberFunctionThisPointerUnderlyingType(ptrType.getUnderlyingType());
            return;
        }
        this.unexpectedMemberFunctionThisPointerTypes.add(type.getClass());
    }

    void witnessMemberFunctionThisPointerUnderlyingType(AbstractMsType type) {
        if (type == null || type instanceof AbstractCompositeMsType) {
            return;
        }
        if (type instanceof AbstractModifierMsType) {
            return;
        }
        this.unexpectedMemberFunctionThisPointerUnderlyingTypes.add(type.getClass());
    }

    void witnessMemberFunctionContainingType(AbstractMsType type) {
        if (type == null || type instanceof AbstractCompositeMsType) {
            return;
        }
        this.unexpectedMemberFunctionContainerTypes.add(type.getClass());
    }

    void logReport() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.reportNonappliableTypes());
        builder.append(this.reportUnunsualThisPointerTypes());
        builder.append(this.reportUnunsualThisPointerUnderlyingTypes());
        builder.append(this.reportUnunsualMemberFunctionContainerTypes());
        builder.append(this.reportNonappliableSymbols());
        builder.append(this.reportUnexpectedPublicSymbols());
        builder.append(this.reportUnexpectedGlobalSymbols());
        builder.append(this.reportEnumerateNarrowing());
        if (builder.length() == 0) {
            return;
        }
        builder.insert(0, "===Begin PdbApplicatorMetrics Report===\n");
        builder.append("====End PdbApplicatorMetrics Report====\n");
        String text = builder.toString();
        Msg.info((Object)this, (Object)text);
        PdbLog.message(text);
    }

    private String reportNonappliableTypes() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsType> clazz : this.cannotApplyTypes) {
            builder.append("Could not apply one or more instances of an unsupported PDB data type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportUnunsualThisPointerTypes() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsType> clazz : this.unexpectedMemberFunctionThisPointerTypes) {
            builder.append("Unusual this pointer type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportUnunsualThisPointerUnderlyingTypes() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsType> clazz : this.unexpectedMemberFunctionThisPointerUnderlyingTypes) {
            builder.append("Unusual this pointer underlying type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportUnunsualMemberFunctionContainerTypes() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsType> clazz : this.unexpectedMemberFunctionContainerTypes) {
            builder.append("Unusual member function container: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportNonappliableSymbols() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsSymbol> clazz : this.cannotApplySymbols) {
            builder.append("Could not apply one or more instances of an unsupported PDB symbol type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportUnexpectedPublicSymbols() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsSymbol> clazz : this.unexpectedPublicSymbols) {
            builder.append("Unexpected one or more instances of PDB public symbol type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportUnexpectedGlobalSymbols() {
        StringBuilder builder = new StringBuilder();
        for (Class<? extends AbstractMsSymbol> clazz : this.unexpectedGlobalSymbols) {
            builder.append("Unexpected one or more instances of PDB global symbol type: " + clazz.getSimpleName() + "\n");
        }
        return builder.toString();
    }

    private String reportEnumerateNarrowing() {
        if (this.witnessEnumerateNarrowing) {
            return "Enumerate narrowing was witnessed\n";
        }
        return "";
    }
}

