/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;

public class ModifierTypeApplier
extends MsTypeApplier {
    public ModifierTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    RecordNumber getUnderlyingNonModifierRecordNumber(RecordNumber underlyingRecord) {
        return ModifierTypeApplier.getUnderlyingNonModifierRecordNumber(this.applicator, underlyingRecord);
    }

    static RecordNumber getUnderlyingNonModifierRecordNumber(DefaultPdbApplicator applicator, RecordNumber underlyingRecord) {
        AbstractMsType underlyingType = applicator.getPdb().getTypeRecord(underlyingRecord);
        while (underlyingType instanceof AbstractModifierMsType) {
            AbstractModifierMsType modifierType = (AbstractModifierMsType)underlyingType;
            RecordNumber modifiedRecord = modifierType.getModifiedRecordNumber();
            underlyingType = applicator.getPdb().getTypeRecord(modifiedRecord);
        }
        return underlyingType.getRecordNumber();
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        AbstractModifierMsType modifierType = (AbstractModifierMsType)type;
        RecordNumber modifiedRecord = modifierType.getModifiedRecordNumber();
        DataType modifiedType = this.applicator.getProcessedDataType(modifiedRecord, fixupContext, false);
        if (modifiedType != null) {
            this.applicator.putDataType(modifierType, modifiedType);
        }
        return modifiedType;
    }
}

