/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractBlockMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ManagedProcedureSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SeparatedCodeSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class BlockSymbolApplier
extends MsSymbolApplier {
    private AbstractBlockMsSymbol symbol;

    public BlockSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractBlockMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractBlockMsSymbol)abstractSymbol;
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.pdbLogAndInfoMessage(this, "Cannot apply " + this.getClass().getSimpleName() + " directly to program");
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        Address address = this.applicator.getAddress(this.symbol);
        if (applierParam instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applierParam;
            functionSymbolApplier.beginBlock(address, this.symbol.getName(), this.symbol.getLength());
        } else if (applierParam instanceof SeparatedCodeSymbolApplier) {
            SeparatedCodeSymbolApplier separatedCodeSymbolApplier = (SeparatedCodeSymbolApplier)applierParam;
            separatedCodeSymbolApplier.beginBlock(address);
        } else if (applierParam instanceof ManagedProcedureSymbolApplier) {
            ManagedProcedureSymbolApplier procedureSymbolApplier = (ManagedProcedureSymbolApplier)applierParam;
            procedureSymbolApplier.beginBlock(address, this.symbol.getName(), this.symbol.getLength());
        }
    }
}

