/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.pdb.PdbNamespaceUtils;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;

public abstract class AbstractComplexTypeApplier
extends MsTypeApplier {
    public AbstractComplexTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    SymbolPath getSymbolPath(AbstractComplexMsType type) {
        String fullPathName = type.getName();
        return new SymbolPath(SymbolPathParser.parse((String)fullPathName));
    }

    public <T extends AbstractComplexMsType> T getDefinitionType(AbstractComplexMsType mType, Class<T> type) {
        Integer num = this.applicator.getNumber(mType);
        Integer mappedIndex = this.applicator.getMappedComplexType(num);
        if (mappedIndex != null) {
            mType = (AbstractComplexMsType)this.applicator.getPdb().getTypeRecord(RecordNumber.typeRecordNumber(mappedIndex), type);
        }
        return (T)((AbstractComplexMsType)type.cast(mType));
    }

    SymbolPath getFixedSymbolPath(AbstractComplexMsType type) {
        SymbolPath path = this.getSymbolPath(type);
        Integer num = this.applicator.getNumber(type);
        Integer mappedIndex = this.applicator.getMappedComplexType(num);
        if (mappedIndex != null) {
            return PdbNamespaceUtils.convertToGhidraPathName(path, mappedIndex);
        }
        return PdbNamespaceUtils.convertToGhidraPathName(path, num);
    }
}

