/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.data.CategoryPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PdbCategories {
    private CategoryPath pdbRootCategory;
    private CategoryPath pdbUncategorizedCategory;
    private CategoryPath anonymousFunctionsCategory;
    private CategoryPath anonymousTypesCategory;
    private CategoryPath placeholderTypesCategory;
    private CategoryPath baseModuleTypedefsCategory;
    private List<CategoryPath> typedefCategories = new ArrayList<CategoryPath>();

    public PdbCategories(String pdbCategoryName, List<String> moduleNames) {
        Objects.requireNonNull(pdbCategoryName, "pdbCategoryName cannot be null");
        this.pdbRootCategory = new CategoryPath(CategoryPath.ROOT, new String[]{pdbCategoryName});
        this.pdbUncategorizedCategory = new CategoryPath(this.pdbRootCategory, new String[]{"_UNCATEGORIZED_"});
        this.setTypedefCategoryPaths(moduleNames);
        this.anonymousFunctionsCategory = new CategoryPath(this.pdbRootCategory, new String[]{"!_anon_funcs_"});
        this.anonymousTypesCategory = new CategoryPath(this.pdbRootCategory, new String[]{"!_anon_types_"});
        this.placeholderTypesCategory = new CategoryPath(this.pdbRootCategory, new String[]{"!_placeholder_types_"});
    }

    public CategoryPath getRootCategoryPath() {
        return this.pdbRootCategory;
    }

    public CategoryPath getUnCategorizedCategoryPath() {
        return this.pdbUncategorizedCategory;
    }

    private void setTypedefCategoryPaths(List<String> moduleNames) {
        this.baseModuleTypedefsCategory = new CategoryPath(this.pdbRootCategory, new String[]{"!_module_typedefs_"});
        this.typedefCategories.add(this.pdbRootCategory);
        for (String name : moduleNames) {
            CategoryPath categoryPath = name == null ? this.baseModuleTypedefsCategory : new CategoryPath(this.baseModuleTypedefsCategory, new String[]{name});
            this.typedefCategories.add(categoryPath);
        }
    }

    public CategoryPath getCategory(SymbolPath symbolPath) {
        CategoryPath category = this.pdbRootCategory;
        if (symbolPath == null) {
            return category;
        }
        return this.recurseGetCategoryPath(category, symbolPath);
    }

    public CategoryPath getTypedefsCategory(int moduleNumber, SymbolPath symbolPath) {
        CategoryPath category = null;
        if (moduleNumber >= 0 && moduleNumber < this.typedefCategories.size()) {
            category = this.typedefCategories.get(moduleNumber);
        }
        if (category == null) {
            category = this.pdbRootCategory;
        }
        if (symbolPath == null) {
            return category;
        }
        return this.recurseGetCategoryPath(category, symbolPath);
    }

    private CategoryPath recurseGetCategoryPath(CategoryPath category, SymbolPath symbolPath) {
        SymbolPath parent = symbolPath.getParent();
        if (parent != null) {
            category = this.recurseGetCategoryPath(category, parent);
        }
        return new CategoryPath(category, new String[]{symbolPath.getName()});
    }

    public CategoryPath getAnonymousFunctionsCategory() {
        return this.anonymousFunctionsCategory;
    }

    public CategoryPath getAnonymousTypesCategory() {
        return this.anonymousTypesCategory;
    }

    public CategoryPath getPlaceholderTypesCategory() {
        return this.placeholderTypesCategory;
    }
}

