/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.framework.options.Options;
import ghidra.program.model.data.CharsetInfo;
import java.nio.charset.Charset;
import java.util.List;

public class PdbReaderOptions
extends Exception {
    private static final boolean developerMode = false;
    private static final String OPTION_NAME_ONE_BYTE_CHARSET_NAME = "PDB One-Byte Charset Name";
    private static final String OPTION_DESCRIPTION_ONE_BYTE_CHARSET_NAME = "Charset used for processing of one-byte (or multi) encoded Strings: " + PdbReaderOptions.getOneByteCharsetNames();
    private static final String DEFAULT_ONE_BYTE_CHARSET_NAME = "UTF-8";
    private String oneByteCharsetName;
    private static final String OPTION_NAME_WCHAR_CHARSET_NAME = "PDB Wchar_t Charset Name";
    private static final String OPTION_DESCRIPTION_WCHAR_CHARSET_NAME = "Charset used for processing of wchar_t encoded Strings: " + PdbReaderOptions.getTwoByteCharsetNames();
    private static final String DEFAULT_TWO_BYTE_CHARSET_NAME = "UTF-16";
    private String wideCharCharsetName;
    private static List<String> oneByteCharsetNames = CharsetInfo.getInstance().getCharsetNamesWithCharSize(1);
    private static List<String> twoByteCharsetNames = CharsetInfo.getInstance().getCharsetNamesWithCharSize(2);
    private Charset oneByteCharset;
    private Charset wideCharset;

    public PdbReaderOptions() {
        this.setDefaults();
    }

    public void registerOptions(Options options) {
        Object help = null;
    }

    public void loadOptions(Options options) {
    }

    public void setDefaults() {
        this.oneByteCharsetName = DEFAULT_ONE_BYTE_CHARSET_NAME;
        this.wideCharCharsetName = DEFAULT_TWO_BYTE_CHARSET_NAME;
        this.setOneByteCharsetForName(this.oneByteCharsetName);
        this.setWideCharCharsetForName(this.wideCharCharsetName);
    }

    public static List<String> getOneByteCharsetNames() {
        return oneByteCharsetNames;
    }

    public static List<String> getTwoByteCharsetNames() {
        return twoByteCharsetNames;
    }

    public PdbReaderOptions setOneByteCharsetForName(String name) {
        if (!oneByteCharsetNames.contains(name)) {
            throw new IllegalArgumentException("Unknown OneByteCharset: " + name);
        }
        this.oneByteCharset = Charset.forName(name);
        this.oneByteCharsetName = name;
        return this;
    }

    public PdbReaderOptions setWideCharCharsetForName(String name) {
        if (!twoByteCharsetNames.contains(name)) {
            throw new IllegalArgumentException("Unknown TwoByteCharset: " + name);
        }
        this.wideCharset = Charset.forName(name);
        this.wideCharCharsetName = name;
        return this;
    }

    public String getOneByteCharsetName() {
        return this.oneByteCharsetName;
    }

    public String getTwoByteCharsetName() {
        return this.wideCharCharsetName;
    }

    public String getWideCharCharsetName() {
        return this.wideCharCharsetName;
    }

    public Charset getOneByteCharset() {
        return this.oneByteCharset;
    }

    public Charset getTwoByteCharset() {
        return this.wideCharset;
    }

    public Charset getWideCharCharset() {
        return this.wideCharset;
    }
}

