/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledFunctionIndirect;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledFunctionReference;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledString;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.program.model.symbol.SourceType;
import java.util.Iterator;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDString;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDVarArgsType;
import mdemangler.datatype.complex.MDClassType;
import mdemangler.datatype.complex.MDCoclassType;
import mdemangler.datatype.complex.MDCointerfaceType;
import mdemangler.datatype.complex.MDComplexType;
import mdemangler.datatype.complex.MDEnumType;
import mdemangler.datatype.complex.MDStructType;
import mdemangler.datatype.complex.MDUnionType;
import mdemangler.datatype.extended.MDArrayReferencedType;
import mdemangler.datatype.modifier.MDArrayBasicType;
import mdemangler.datatype.modifier.MDCVMod;
import mdemangler.datatype.modifier.MDDataReferenceType;
import mdemangler.datatype.modifier.MDDataRightReferenceType;
import mdemangler.datatype.modifier.MDFunctionIndirectType;
import mdemangler.datatype.modifier.MDModifierType;
import mdemangler.datatype.modifier.MDPointerRefDataType;
import mdemangler.datatype.modifier.MDPointerType;
import mdemangler.datatype.modifier.MDReferenceType;
import mdemangler.datatype.modifier.MDStdNullPtrType;
import mdemangler.functiontype.MDArgumentsList;
import mdemangler.functiontype.MDFunctionType;
import mdemangler.functiontype.MDThrowAttribute;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDQualifiedName;
import mdemangler.naming.MDQualifier;
import mdemangler.object.MDObjectBracket;
import mdemangler.object.MDObjectC;
import mdemangler.object.MDObjectCPP;
import mdemangler.object.MDObjectCodeView;
import mdemangler.object.MDObjectReserved;
import mdemangler.template.MDTemplateNameAndArguments;
import mdemangler.typeinfo.AbstractMDMetaClass;
import mdemangler.typeinfo.MDFunctionInfo;
import mdemangler.typeinfo.MDGuard;
import mdemangler.typeinfo.MDMemberFunctionInfo;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDVCall;
import mdemangler.typeinfo.MDVFAdjustor;
import mdemangler.typeinfo.MDVariableInfo;
import mdemangler.typeinfo.MDVtordisp;
import mdemangler.typeinfo.MDVtordispex;
import mdemangler.typeinfo.MDVxTable;

public class MDMangGhidra
extends MDMang {
    private DemangledObject objectResult;
    private DemangledDataType dataTypeResult;
    private String mangledSource;
    private String demangledSource;

    public DemangledObject getObject() {
        return this.objectResult;
    }

    public DemangledDataType getDataType() {
        return this.dataTypeResult;
    }

    @Override
    public MDParsableItem demangle(String mangledArg, boolean demangleOnlyKnownPatterns) throws MDException {
        if (demangleOnlyKnownPatterns && !mangledArg.startsWith("?") && !mangledArg.startsWith(".") && !mangledArg.startsWith("__") && mangledArg.charAt(0) >= 'a' && mangledArg.charAt(0) <= 'z' && mangledArg.charAt(0) >= 'A' && mangledArg.charAt(0) <= 'Z') {
            return null;
        }
        this.mangledSource = mangledArg;
        MDParsableItem returnedItem = super.demangle(mangledArg, true);
        this.demangledSource = this.item.toString();
        this.objectResult = this.processItem();
        return returnedItem;
    }

    public DemangledType processNamespace(MDQualifiedName qualifiedName) {
        return this.processNamespace(qualifiedName.getQualification());
    }

    private DemangledType processNamespace(MDQualification qualification) {
        DemangledType type;
        Iterator<MDQualifier> it = qualification.iterator();
        if (!it.hasNext()) {
            return null;
        }
        MDQualifier qual = it.next();
        DemangledType parentType = type = new DemangledType(this.mangledSource, this.demangledSource, qual.toString());
        while (it.hasNext()) {
            DemangledType newType;
            qual = it.next();
            if (qual.isNested()) {
                String subMangled = qual.getNested().getMangled();
                newType = new DemangledType(subMangled, this.demangledSource, qual.toString());
            } else {
                newType = new DemangledType(this.mangledSource, this.demangledSource, qual.toString());
            }
            parentType.setNamespace((Demangled)newType);
            parentType = newType;
        }
        return type;
    }

    private DemangledObject processItem() {
        this.objectResult = null;
        if (this.item instanceof MDObjectReserved) {
            this.objectResult = this.processObjectReserved((MDObjectReserved)this.item);
        } else if (this.item instanceof MDObjectCodeView) {
            this.objectResult = this.processObjectCPP((MDObjectCPP)this.item);
            this.objectResult.setSpecialPrefix(((MDObjectCodeView)this.item).getPrefix());
        } else if (this.item instanceof MDObjectCPP) {
            this.objectResult = this.processObjectCPP((MDObjectCPP)this.item);
        } else if (this.item instanceof MDObjectC) {
            this.objectResult = this.processObjectC((MDObjectC)this.item);
        } else if (this.item instanceof MDDataType) {
            this.dataTypeResult = this.processDataType(null, (MDDataType)this.item);
        } else if (this.item instanceof MDTemplateNameAndArguments) {
            this.objectResult = this.processTemplate((MDTemplateNameAndArguments)this.item);
        }
        return this.objectResult;
    }

    private DemangledObject processObjectReserved(MDObjectReserved objectReserved) {
        DemangledObject object = null;
        if (objectReserved.getClass().equals(MDObjectReserved.class)) {
            return null;
        }
        if (objectReserved instanceof MDObjectBracket) {
            MDObjectBracket objectBracket = (MDObjectBracket)objectReserved;
            MDObjectCPP objectCPP = objectBracket.getObjectCPP();
            object = this.processObjectCPP(objectCPP);
            object.setSpecialPrefix(((MDObjectBracket)this.item).getPrefix());
        } else {
            object = new DemangledUnknown(this.mangledSource, this.demangledSource, objectReserved.toString());
        }
        return object;
    }

    private DemangledObject processObjectC(MDObjectC objectC) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DemangledObject processObjectCPP(MDObjectCPP objectCPP) {
        MDTypeInfo typeinfo = objectCPP.getTypeInfo();
        DemangledUnknown resultObject = null;
        if (typeinfo != null) {
            if (typeinfo instanceof MDVariableInfo) {
                DemangledVariable variable;
                MDVariableInfo variableInfo = (MDVariableInfo)typeinfo;
                MDType mdtype = variableInfo.getMDType();
                DemangledDataType dt = this.processDataType(null, (MDDataType)mdtype);
                if ("std::nullptr_t".equals(dt.getName())) {
                    variable = new DemangledVariable(this.mangledSource, this.demangledSource, "");
                } else {
                    variable = new DemangledVariable(this.mangledSource, this.demangledSource, objectCPP.getName());
                    variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                }
                variable.setDatatype(dt);
                resultObject = variable;
                variable.setConst(variableInfo.isConst());
                variable.setVolatile(variableInfo.isVolatile());
                variable.setPointer64(variableInfo.isPointer64());
                if (variableInfo.isRestrict()) {
                    variable.setRestrict();
                }
                if (variableInfo.isUnaligned()) {
                    variable.setUnaligned();
                }
                variable.setBasedName(variableInfo.getBasedName());
                if (variableInfo.isMember()) {
                    variable.setMemberScope(variableInfo.getMemberScope());
                }
            } else if (typeinfo instanceof MDFunctionInfo) {
                if (typeinfo.getSpecialHandlingCode() == 'F') {
                    resultObject = new DemangledUnknown(this.mangledSource, this.demangledSource, null);
                } else {
                    DemangledFunction function = new DemangledFunction(this.mangledSource, this.demangledSource, objectCPP.getName());
                    function.setSignatureSourceType(SourceType.IMPORTED);
                    function.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                    resultObject = function;
                    this.objectResult = this.processFunction((MDFunctionInfo)typeinfo, function);
                    if (!(!(typeinfo instanceof MDMemberFunctionInfo) || typeinfo instanceof MDVCall || typeinfo instanceof MDVFAdjustor || typeinfo instanceof MDVtordisp || typeinfo instanceof MDVtordispex)) {
                        // empty if block
                    }
                }
            } else if (typeinfo instanceof MDVxTable) {
                MDVxTable vxtable = (MDVxTable)typeinfo;
                DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, objectCPP.getName());
                variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                variable.setConst(vxtable.isConst());
                variable.setVolatile(vxtable.isVolatile());
                variable.setPointer64(vxtable.isPointer64());
                resultObject = variable;
            } else if (typeinfo instanceof AbstractMDMetaClass) {
                DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, objectCPP.getName());
                variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                resultObject = variable;
            } else if (typeinfo instanceof MDGuard) {
                DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, objectCPP.getName());
                variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                resultObject = variable;
            } else {
                DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, objectCPP.getName());
                variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
                resultObject = variable;
            }
            if (typeinfo.isPrivate()) {
                resultObject.setVisibilty("private");
            } else if (typeinfo.isProtected()) {
                resultObject.setVisibilty("protected");
            } else if (typeinfo.isPublic()) {
                resultObject.setVisibilty("public");
            }
            resultObject.setStatic(typeinfo.isStatic());
            resultObject.setVirtual(typeinfo.isVirtual());
            resultObject.setThunk(typeinfo.isThunk());
            if (!typeinfo.isExternC()) return resultObject;
            resultObject.setSpecialPrefix("extern \"C\"");
            return resultObject;
        }
        String baseName = objectCPP.getName();
        if (objectCPP.isString()) {
            MDString mstring = objectCPP.getMDString();
            DemangledString demangledString = new DemangledString(this.mangledSource, this.demangledSource, mstring.getName(), mstring.toString(), mstring.getLength(), mstring.isUnicode());
            return demangledString;
        }
        if (baseName.length() == 0) return resultObject;
        DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, baseName);
        variable.setNamespace((Demangled)this.processNamespace(objectCPP.getQualification()));
        return variable;
    }

    private DemangledVariable processTemplate(MDTemplateNameAndArguments template) {
        DemangledVariable variable = new DemangledVariable(this.mangledSource, this.demangledSource, template.toString());
        return variable;
    }

    private DemangledFunction processFunction(MDFunctionInfo functionInfo, DemangledFunction function) {
        MDThrowAttribute ta;
        MDCVMod thisPointerCVMod;
        MDDataType retType;
        MDFunctionType functionType = (MDFunctionType)functionInfo.getMDType();
        String convention = functionType.getCallingConvention().toString();
        if ("__cdecl".equals(convention) && functionInfo.isMember() && !functionInfo.isStatic()) {
            convention = "__thiscall";
        }
        function.setCallingConvention(convention);
        if (functionType.hasReturn() && functionType.getReturnType() != null && !(retType = functionType.getReturnType()).toString().isEmpty()) {
            function.setReturnType(this.processDataType(null, retType));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                function.addParameter(this.processDataType(null, args.getArg(index)));
            }
        }
        if (functionType.isTypeCast()) {
            function.setTypeCast();
        }
        if ((thisPointerCVMod = functionType.getThisPointerCVMod()) != null) {
            if (thisPointerCVMod.isConst()) {
                function.setTrailingConst();
            }
            if (thisPointerCVMod.isVolatile()) {
                function.setTrailingVolatile();
            }
            if (thisPointerCVMod.isPointer64()) {
                function.setTrailingPointer64();
            }
            if (thisPointerCVMod.isRestricted()) {
                function.setTrailingRestrict();
            }
            if (thisPointerCVMod.isUnaligned()) {
                function.setTrailingUnaligned();
            }
        }
        if ((ta = functionType.getThrowAttribute()) != null) {
            function.setThrowAttribute(ta.toString());
        }
        return function;
    }

    private DemangledFunctionPointer processDemangledFunctionPointer(MDPointerType pointerType) {
        MDCVMod thisPointerCVMod;
        DemangledFunctionPointer functionPointer = new DemangledFunctionPointer(this.mangledSource, this.demangledSource);
        MDFunctionType functionType = (MDFunctionType)pointerType.getReferencedType();
        functionPointer.setCallingConvention(functionType.getCallingConvention().toString());
        functionPointer.setModifier(pointerType.getCVMod().toString());
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionPointer.setReturnType(this.processDataType(null, functionType.getReturnType()));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionPointer.addParameter(this.processDataType(null, args.getArg(index)));
            }
        }
        if ((thisPointerCVMod = functionType.getThisPointerCVMod()) != null) {
            if (thisPointerCVMod.isConst()) {
                functionPointer.setConst();
            }
            if (thisPointerCVMod.isVolatile()) {
                functionPointer.setVolatile();
            }
            if (thisPointerCVMod.isPointer64()) {
                functionPointer.setTrailingPointer64();
            }
            if (thisPointerCVMod.isRestricted()) {
                functionPointer.setTrailingRestrict();
            }
            if (thisPointerCVMod.isUnaligned()) {
                functionPointer.setTrailingUnaligned();
            }
        }
        return functionPointer;
    }

    private DemangledFunctionReference processDemangledFunctionReference(MDModifierType refType) {
        if (!(refType instanceof MDReferenceType) && !(refType instanceof MDDataRightReferenceType)) {
            return null;
        }
        DemangledFunctionReference functionReference = new DemangledFunctionReference(this.mangledSource, this.demangledSource);
        MDFunctionType functionType = (MDFunctionType)refType.getReferencedType();
        functionReference.setCallingConvention(functionType.getCallingConvention().toString());
        functionReference.setModifier(refType.getCVMod().toString());
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionReference.setReturnType(this.processDataType(null, functionType.getReturnType()));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionReference.addParameter(this.processDataType(null, args.getArg(index)));
            }
        }
        return functionReference;
    }

    private DemangledFunctionIndirect processDemangledFunctionIndirect(MDFunctionIndirectType functionIndirectType) {
        DemangledFunctionIndirect functionDefinition = new DemangledFunctionIndirect(this.mangledSource, this.demangledSource);
        MDFunctionType functionType = (MDFunctionType)functionIndirectType.getReferencedType();
        functionDefinition.setCallingConvention(functionType.getCallingConvention().toString());
        functionDefinition.setModifier(functionIndirectType.getCVMod().toString());
        functionDefinition.incrementPointerLevels();
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionDefinition.setReturnType(this.processDataType(null, functionType.getReturnType()));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionDefinition.addParameter(this.processDataType(null, args.getArg(index)));
            }
        }
        return functionDefinition;
    }

    private DemangledFunctionIndirect processDemangledFunctionQuestion(MDModifierType modifierType) {
        DemangledFunctionIndirect functionDefinition = new DemangledFunctionIndirect(this.mangledSource, this.demangledSource);
        MDFunctionType functionType = (MDFunctionType)modifierType.getReferencedType();
        functionDefinition.setCallingConvention(functionType.getCallingConvention().toString());
        functionDefinition.setModifier(modifierType.getCVMod().toString());
        functionDefinition.incrementPointerLevels();
        if (functionType.hasReturn() && functionType.getReturnType() != null) {
            functionDefinition.setReturnType(this.processDataType(null, functionType.getReturnType()));
        }
        MDArgumentsList args = functionType.getArgumentsList();
        if (functionType.hasArgs() && args != null) {
            for (int index = 0; index < args.getNumArgs(); ++index) {
                functionDefinition.addParameter(this.processDataType(null, args.getArg(index)));
            }
        }
        return functionDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DemangledDataType processDataType(DemangledDataType resultDataType, MDDataType datatype) {
        if (resultDataType == null) {
            resultDataType = new DemangledDataType(this.mangledSource, this.demangledSource, this.getDataTypeName(datatype));
        }
        if (datatype.isSpecifiedSigned()) {
            resultDataType.setSigned();
        }
        if (datatype.isUnsigned()) {
            resultDataType.setUnsigned();
        }
        if (datatype instanceof MDModifierType) {
            MDModifierType modifierType = (MDModifierType)datatype;
            if (modifierType.isConst()) {
                resultDataType.setConst();
            }
            if (modifierType.isVolatile()) {
                resultDataType.setVolatile();
            }
            if (modifierType.isPointer64()) {
                resultDataType.setPointer64();
            }
            if (modifierType.isRestrict()) {
                resultDataType.setRestrict();
            }
            if (modifierType.isUnaligned()) {
                resultDataType.setUnaligned();
            }
            resultDataType.setBasedName(modifierType.getBasedName());
            resultDataType.setMemberScope(modifierType.getMemberScope());
            if (modifierType instanceof MDArrayBasicType) {
                resultDataType.setArray(1);
                if (modifierType.getReferencedType() instanceof MDFunctionType || !(modifierType.getReferencedType() instanceof MDDataType)) return resultDataType;
                return this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
            }
            if (modifierType instanceof MDPointerType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    DemangledFunctionPointer fp = this.processDemangledFunctionPointer((MDPointerType)modifierType);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fp.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fp.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fp.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fp;
                    fp.setPointer64();
                    return fp;
                }
                DemangledDataType newResult = this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
                newResult.incrementPointerLevels();
                if (modifierType.getCVMod().isConst()) {
                    newResult.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    newResult.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return newResult;
                newResult.setPointer64();
                return newResult;
            }
            if (modifierType instanceof MDReferenceType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    DemangledFunctionReference fr = this.processDemangledFunctionReference(modifierType);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fr.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fr.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fr.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fr;
                    fr.setPointer64();
                    return fr;
                }
                DemangledDataType newResult = this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
                newResult.setLValueReference();
                if (modifierType.getCVMod().isConst()) {
                    newResult.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    newResult.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return newResult;
                newResult.setPointer64();
                return newResult;
            }
            if (modifierType instanceof MDFunctionIndirectType) {
                DemangledFunctionIndirect fd = this.processDemangledFunctionIndirect((MDFunctionIndirectType)modifierType);
                for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                    fd.incrementPointerLevels();
                }
                if (resultDataType.isConst()) {
                    fd.setConst();
                }
                if (resultDataType.isVolatile()) {
                    fd.setVolatile();
                }
                if (!resultDataType.isPointer64()) return fd;
                fd.setPointer64();
                return fd;
            }
            if (modifierType instanceof MDPointerRefDataType) {
                resultDataType.setName(this.getDataTypeName(datatype));
                return this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
            }
            if (modifierType instanceof MDDataReferenceType) {
                this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
                if (modifierType.getCVMod().isConst()) {
                    resultDataType.setConst();
                }
                if (!modifierType.getCVMod().isVolatile()) return resultDataType;
                resultDataType.setVolatile();
                return resultDataType;
            }
            if (modifierType instanceof MDDataRightReferenceType) {
                if (modifierType.getReferencedType() instanceof MDFunctionType) {
                    resultDataType.setName(this.getDataTypeName(datatype));
                    DemangledFunctionReference fr = this.processDemangledFunctionReference(modifierType);
                    for (int i = 0; i < resultDataType.getPointerLevels(); ++i) {
                        fr.incrementPointerLevels();
                    }
                    if (resultDataType.isConst()) {
                        fr.setConst();
                    }
                    if (resultDataType.isVolatile()) {
                        fr.setVolatile();
                    }
                    if (!resultDataType.isPointer64()) return fr;
                    fr.setPointer64();
                    return fr;
                }
                this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
                resultDataType.setRValueReference();
                if (modifierType.getCVMod().isConst()) {
                    resultDataType.setConst();
                }
                if (modifierType.getCVMod().isVolatile()) {
                    resultDataType.setVolatile();
                }
                if (!modifierType.getCVMod().isPointer64()) return resultDataType;
                resultDataType.setPointer64();
                return resultDataType;
            }
            if (modifierType.getReferencedType() instanceof MDFunctionType) {
                DemangledFunctionIndirect fx = this.processDemangledFunctionQuestion(modifierType);
                if (resultDataType.isConst()) {
                    fx.setConst();
                }
                if (resultDataType.isVolatile()) {
                    fx.setVolatile();
                }
                if (!resultDataType.isPointer64()) return fx;
                fx.setPointer64();
                return fx;
            }
            DemangledDataType dataType = this.processDataType(resultDataType, (MDDataType)modifierType.getReferencedType());
            if (modifierType.getCVMod().isConst()) {
                resultDataType.setConst();
            }
            if (modifierType.getCVMod().isVolatile()) {
                resultDataType.setVolatile();
            }
            if (!modifierType.getCVMod().isPointer64()) return dataType;
            resultDataType.setPointer64();
            return dataType;
        }
        if (datatype instanceof MDComplexType) {
            MDComplexType complexType = (MDComplexType)datatype;
            resultDataType.setName(complexType.getNamespace().getName());
            resultDataType.setNamespace((Demangled)this.processNamespace(complexType.getNamespace()));
            if (datatype instanceof MDEnumType) {
                resultDataType.setEnum();
                MDEnumType enumType = (MDEnumType)datatype;
                resultDataType.setEnumType(enumType.getUnderlyingFullTypeName());
                return resultDataType;
            } else if (datatype instanceof MDClassType) {
                resultDataType.setClass();
                return resultDataType;
            } else if (datatype instanceof MDStructType) {
                resultDataType.setStruct();
                return resultDataType;
            } else if (datatype instanceof MDUnionType) {
                resultDataType.setUnion();
                return resultDataType;
            } else if (datatype instanceof MDCoclassType) {
                resultDataType.setCoclass();
                return resultDataType;
            } else {
                if (!(datatype instanceof MDCointerfaceType)) return resultDataType;
                resultDataType.setCointerface();
            }
            return resultDataType;
        } else if (datatype instanceof MDReferenceType) {
            resultDataType.setLValueReference();
            return resultDataType;
        } else if (datatype instanceof MDArrayBasicType) {
            resultDataType.setArray(1);
            return resultDataType;
        } else if (datatype instanceof MDVarArgsType) {
            resultDataType.setVarArgs();
            return resultDataType;
        } else {
            if (datatype instanceof MDArrayReferencedType) {
                MDArrayReferencedType arrRefType = (MDArrayReferencedType)datatype;
                return this.processDataType(resultDataType, arrRefType.getReferencedType());
            }
            if (datatype instanceof MDStdNullPtrType) {
                resultDataType.setName(datatype.toString());
                return resultDataType;
            } else {
                resultDataType.setName(this.getDataTypeName(datatype));
            }
        }
        return resultDataType;
    }

    private String getDataTypeName(MDDataType dataType) {
        String name = dataType.getName();
        if (!name.isBlank()) {
            return name;
        }
        name = dataType.getTypeName();
        if (!name.isBlank()) {
            return name;
        }
        return dataType.toString();
    }
}

