/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTSession;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public abstract class VtTask
extends Task {
    private static final int MAX_ERRORS = 10;
    protected final VTSession session;
    private boolean success = false;
    private boolean cancelled = false;
    private List<String> errors = new ArrayList<String>();

    protected VtTask(String title, VTSession session) {
        super(title, true, true, true, true);
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(TaskMonitor monitor) {
        boolean restoreEvents = this.suspendEvents();
        try {
            this.success = this.doWork(monitor);
        }
        catch (CancelledException e) {
            this.cancelled = true;
        }
        catch (Exception e) {
            this.reportError(e);
        }
        finally {
            if (restoreEvents) {
                this.session.setEventsEnabled(true);
            }
        }
    }

    private boolean suspendEvents() {
        if (this.session == null) {
            return false;
        }
        if (!this.shouldSuspendSessionEvents()) {
            return false;
        }
        if (!this.session.isSendingEvents()) {
            return false;
        }
        this.session.setEventsEnabled(false);
        return true;
    }

    protected boolean shouldSuspendSessionEvents() {
        return false;
    }

    protected abstract boolean doWork(TaskMonitor var1) throws Exception;

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public boolean wasSuccessfull() {
        return this.success;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void showErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        String title = this.getErrorDialogTitle();
        String message = this.getErrorDetails();
        Msg.showError((Object)((Object)this), null, (String)title, (Object)message);
    }

    protected String getErrorHeader() {
        return "Errors encountered for task \"" + this.getTaskTitle() + "\":";
    }

    public void logErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder(this.getErrorHeader());
        buf.append("\n");
        for (String error : this.errors) {
            buf.append("\t").append(error).append("\n");
        }
        Msg.error((Object)((Object)this), (Object)buf.toString());
    }

    private String getErrorDialogTitle() {
        if (this.success) {
            return "Task \"" + this.getTaskTitle() + "\" Partially Completed";
        }
        return "Task Failed: " + this.getTaskTitle();
    }

    public String getErrorDetails() {
        StringBuilder buf = new StringBuilder("<html>" + this.getErrorHeader());
        int errorCount = 0;
        buf.append("<blockquote><br>");
        for (String error : this.errors) {
            buf.append(error).append("<br>");
            if (++errorCount <= 10) continue;
            buf.append("...and " + (this.errors.size() - errorCount) + " more!");
            break;
        }
        return buf.toString();
    }

    protected void reportError(Exception e) {
        Object message;
        Throwable t = e;
        Throwable cause = e.getCause();
        if (cause != null) {
            t = cause;
        }
        if ((message = t.getMessage()) == null) {
            message = "Unexpected Exception: " + e.toString();
        }
        this.errors.add((String)message);
    }

    protected void reportError(String message) {
        this.errors.add(message);
    }

    protected void addErrors(VtTask task) {
        this.errors.addAll(task.errors);
    }
}

