/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui;

import ghidra.framework.task.GScheduledTask;
import ghidra.framework.task.GTaskListenerAdapter;
import ghidra.framework.task.GTaskManager;
import ghidra.framework.task.GTaskResult;
import ghidra.framework.task.gui.GTaskListModel;
import ghidra.framework.task.gui.GTaskResultInfo;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CompletedTaskListModel
extends GTaskListModel<GTaskResultInfo> {
    private static final int MIN_DELAY = 250;
    private static final int MAX_DELAY = 1000;
    private static final int PRUNE_SIZE = 10;
    private static final int MAX_SIZE = 200;
    private List<GTaskResultInfo> list = new ArrayList<GTaskResultInfo>();
    private GTaskManager taskManager;
    private CompletedPanelTaskListener taskListener;
    private Queue<Runnable> runnableQueue = new ConcurrentLinkedQueue<Runnable>();
    private SwingUpdateManager updateManager;

    CompletedTaskListModel(GTaskManager taskMgr) {
        this.taskManager = taskMgr;
        this.taskListener = new CompletedPanelTaskListener();
        this.updateManager = new SwingUpdateManager(250, 1000, new Runnable(){

            @Override
            public void run() {
                while (!CompletedTaskListModel.this.runnableQueue.isEmpty()) {
                    Runnable runnable = CompletedTaskListModel.this.runnableQueue.poll();
                    runnable.run();
                }
            }
        });
        taskMgr.addTaskListener(this.taskListener);
    }

    public void dispose() {
        this.taskManager.removeTaskListener(this.taskListener);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public GTaskResultInfo getElementAt(int index) {
        return this.list.get(index);
    }

    private void pruneList() {
        if (this.list.size() > 200) {
            this.list.subList(0, 10).clear();
            this.fireIntervalRemoved(0, 9);
        }
    }

    private class CompletedPanelTaskListener
    extends GTaskListenerAdapter {
        private CompletedPanelTaskListener() {
        }

        @Override
        public void taskCompleted(GScheduledTask task, GTaskResult result) {
            CompletedTaskListModel.this.runnableQueue.add(new CompletedTaskRunnable(result));
            CompletedTaskListModel.this.updateManager.update();
        }

        @Override
        public void initialize() {
            CompletedTaskListModel.this.runnableQueue.add(new InitializeRunnable());
            CompletedTaskListModel.this.updateManager.update();
        }
    }

    private class InitializeRunnable
    implements Runnable {
        private InitializeRunnable() {
        }

        @Override
        public void run() {
            List<GTaskResult> taskResults = CompletedTaskListModel.this.taskManager.getTaskResults();
            GTaskResult lastResult = null;
            for (GTaskResult gTaskResult : taskResults) {
                if (gTaskResult.hasSameTransaction(lastResult)) {
                    CompletedTaskListModel.this.list.add(new GTaskResultInfo(null));
                }
                CompletedTaskListModel.this.list.add(new GTaskResultInfo(gTaskResult));
            }
        }
    }

    private class CompletedTaskRunnable
    implements Runnable {
        private GTaskResult result;

        CompletedTaskRunnable(GTaskResult result) {
            this.result = result;
        }

        @Override
        public void run() {
            int startInterval = CompletedTaskListModel.this.list.size();
            if (this.isNewTransaction()) {
                CompletedTaskListModel.this.list.add(new GTaskResultInfo(null));
            }
            CompletedTaskListModel.this.list.add(new GTaskResultInfo(this.result));
            CompletedTaskListModel.this.fireIntervalAdded(startInterval, CompletedTaskListModel.this.list.size() - 1);
            CompletedTaskListModel.this.pruneList();
        }

        private boolean isNewTransaction() {
            if (CompletedTaskListModel.this.list.isEmpty()) {
                return false;
            }
            GTaskResultInfo element = CompletedTaskListModel.this.list.get(CompletedTaskListModel.this.list.size() - 1);
            GTaskResult lastResult = element.getResult();
            if (lastResult == null) {
                return false;
            }
            return !lastResult.hasSameTransaction(this.result);
        }
    }
}

