/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.Handler;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GhidraURL {
    public static final String PROTOCOL = "ghidra";
    private static final String PROTOCOL_URL_START = "ghidra:/";
    private static Pattern IS_REMOTE_URL_PATTERN = Pattern.compile("^ghidra://[^/].*");
    private static Pattern IS_LOCAL_URL_PATTERN = Pattern.compile("^ghidra:/[^/].*");
    public static final String MARKER_FILE_EXTENSION = ".gpr";
    public static final String PROJECT_DIRECTORY_EXTENSION = ".rep";

    private GhidraURL() {
    }

    public static boolean localProjectExists(URL url) {
        ProjectLocator loc = GhidraURL.getProjectStorageLocator(url);
        return loc != null && loc.exists();
    }

    public static boolean isGhidraURL(String str) {
        return str != null && str.startsWith(PROTOCOL_URL_START);
    }

    public static boolean isGhidraURL(URL url) {
        return url != null && url.getProtocol().equals(PROTOCOL);
    }

    public static boolean isLocalGhidraURL(String str) {
        return IS_LOCAL_URL_PATTERN.matcher(str).matches();
    }

    public static boolean isServerURL(String str) {
        return IS_REMOTE_URL_PATTERN.matcher(str).matches();
    }

    public static boolean isLocalProjectURL(URL url) {
        return GhidraURL.isLocalGhidraURL(url.toExternalForm());
    }

    public static ProjectLocator getProjectStorageLocator(URL localProjectURL) {
        if (!GhidraURL.isLocalProjectURL(localProjectURL)) {
            throw new IllegalArgumentException("Invalid local Ghidra project URL");
        }
        String path = localProjectURL.getPath();
        int index = path.lastIndexOf(47);
        String dirPath = index != 0 ? path.substring(0, index) : "/";
        String name = path.substring(index + 1);
        if (name.length() == 0) {
            return null;
        }
        return new ProjectLocator(dirPath, name);
    }

    public static String getRepositoryName(URL url) {
        int ix;
        if (!GhidraURL.isServerRepositoryURL(url)) {
            return null;
        }
        String path = url.getPath();
        if (!path.startsWith("/")) {
            try {
                URL extensionURL = new URL(path);
                path = extensionURL.getPath();
            }
            catch (MalformedURLException e) {
                path = "";
            }
        }
        if ((ix = (path = path.substring(1)).indexOf("/")) > 0) {
            path = path.substring(0, ix);
        }
        return path;
    }

    public static boolean isServerRepositoryURL(URL url) {
        if (!GhidraURL.isServerURL(url)) {
            return false;
        }
        String path = url.getPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        if (!path.startsWith("/")) {
            try {
                URL extensionURL = new URL(path);
                path = extensionURL.getPath();
                if (StringUtils.isBlank((CharSequence)path)) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return path.charAt(0) == '/' && path.length() > 1 && path.charAt(1) != '/';
    }

    public static boolean isServerURL(URL url) {
        if (!PROTOCOL.equals(url.getProtocol())) {
            return false;
        }
        return Handler.isSupportedURL(url);
    }

    private static String checkAbsolutePath(String path) {
        int scanIndex = 0;
        path = ((String)path).replace('\\', '/');
        int len = ((String)path).length();
        if (!((String)path).startsWith("/")) {
            if (len < 3 || !GhidraURL.hasAbsoluteDriveLetter((String)path, 0)) {
                throw new IllegalArgumentException("absolute path required");
            }
            path = "/" + (String)path;
            scanIndex = 3;
        } else if (len >= 3 && GhidraURL.hasDriveLetter((String)path, 1)) {
            if (len < 4 || ((String)path).charAt(3) != '/') {
                throw new IllegalArgumentException("absolute path required");
            }
            scanIndex = 4;
        }
        GhidraURL.checkInvalidChar("path", (String)path, scanIndex);
        return path;
    }

    private static boolean hasDriveLetter(String path, int index) {
        return Character.isLetter(path.charAt(index++)) && path.charAt(index) == ':';
    }

    private static boolean hasAbsoluteDriveLetter(String path, int index) {
        int pathIndex = index + 2;
        return path.length() > pathIndex && GhidraURL.hasDriveLetter(path, index) && path.charAt(pathIndex) == '/';
    }

    private static void checkInvalidChar(String type, String str, int startIndex) {
        for (int i = startIndex; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!ProjectLocator.DISALLOWED_CHARS.contains(Character.valueOf(c))) continue;
            throw new IllegalArgumentException(type + " contains invalid character: '" + c + "'");
        }
    }

    public static URL toURL(String projectPathOrURL) {
        if (!projectPathOrURL.startsWith("ghidra:")) {
            if (projectPathOrURL.endsWith(PROJECT_DIRECTORY_EXTENSION) || projectPathOrURL.endsWith(MARKER_FILE_EXTENSION)) {
                String ext = projectPathOrURL.substring(projectPathOrURL.lastIndexOf(46));
                throw new IllegalArgumentException("Project path must omit extension: " + ext);
            }
            if (projectPathOrURL.contains("?") || projectPathOrURL.contains("#")) {
                throw new IllegalArgumentException("Unsupported query/ref used with project path");
            }
            int minSplitIndex = (projectPathOrURL = GhidraURL.checkAbsolutePath(projectPathOrURL)).charAt(2) == ':' ? 3 : 0;
            int splitIndex = projectPathOrURL.lastIndexOf(47);
            if (splitIndex < minSplitIndex || projectPathOrURL.length() == splitIndex + 1) {
                throw new IllegalArgumentException("Absolute project path is missing project name");
            }
            String location = projectPathOrURL.substring(0, ++splitIndex);
            String projectName = projectPathOrURL.substring(splitIndex);
            return GhidraURL.makeURL(location, projectName);
        }
        try {
            return new URL(projectPathOrURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL getProjectURL(URL ghidraUrl) {
        if (!PROTOCOL.equals(ghidraUrl.getProtocol())) {
            throw new IllegalArgumentException("ghidra protocol required");
        }
        if (GhidraURL.isLocalProjectURL(ghidraUrl)) {
            String urlStr = ghidraUrl.toExternalForm();
            int queryIx = urlStr.indexOf(63);
            if (queryIx < 0) {
                return ghidraUrl;
            }
            urlStr = urlStr.substring(0, queryIx);
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            int queryIx;
            int refIx;
            String path = ghidraUrl.getPath();
            if (!path.startsWith("/")) {
                try {
                    URL extensionURL = new URL(path);
                    path = extensionURL.getPath();
                }
                catch (MalformedURLException e) {
                    path = "/";
                }
            }
            String urlStr = ghidraUrl.toExternalForm();
            String tail = null;
            int ix = path.indexOf(47, 1);
            if (ix > 0) {
                tail = path.substring(ix);
            }
            if ((refIx = urlStr.indexOf(35)) > 0) {
                urlStr = urlStr.substring(0, refIx);
            }
            if ((queryIx = urlStr.indexOf(63)) > 0) {
                urlStr = urlStr.substring(0, queryIx);
            }
            if (tail != null) {
                urlStr = urlStr.substring(0, urlStr.lastIndexOf(tail));
            }
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid project/repository URL: " + ghidraUrl);
    }

    public static String getProjectPathname(URL ghidraUrl) {
        if (GhidraURL.isLocalProjectURL(ghidraUrl)) {
            String query = ghidraUrl.getQuery();
            return StringUtils.isBlank((CharSequence)query) ? "/" : query;
        }
        if (GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            int ix;
            String path = ghidraUrl.getPath();
            if (!path.startsWith("/")) {
                try {
                    URL extensionURL = new URL(path);
                    path = extensionURL.getPath();
                }
                catch (MalformedURLException e) {
                    path = "/";
                }
            }
            if ((ix = path.indexOf(47, 1)) > 1) {
                return path.substring(ix);
            }
            return "/";
        }
        throw new IllegalArgumentException("not project/repository URL");
    }

    private static String getHostAsIpAddress(String host) {
        if (!StringUtils.isBlank((CharSequence)host)) {
            try {
                InetAddress addr = InetAddress.getByName(host);
                host = addr.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return host;
    }

    public static URL getNormalizedURL(URL url) {
        String revisedHost;
        String host = url.getHost();
        if (Objects.equals(host, revisedHost = GhidraURL.getHostAsIpAddress(host)) && url.getRef() == null) {
            return url;
        }
        Object file = url.getPath();
        String query = url.getQuery();
        if (!StringUtils.isBlank((CharSequence)query)) {
            file = (String)file + "?" + query;
        }
        try {
            return new URL(PROTOCOL, revisedHost, url.getPort(), (String)file);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDisplayString(URL url) {
        if (GhidraURL.isLocalProjectURL(url) && StringUtils.isBlank((CharSequence)url.getQuery()) && StringUtils.isBlank((CharSequence)url.getRef())) {
            String path = url.getPath();
            if (path.indexOf(":/") == 2 && Character.isLetter(path.charAt(1))) {
                path = path.substring(1);
                path = path.replace('/', '\\');
            }
            return path;
        }
        return url.toString();
    }

    public static URL makeURL(String dirPath, String projectName) {
        return GhidraURL.makeURL(dirPath, projectName, null, null);
    }

    public static URL makeURL(ProjectLocator projectLocator) {
        return GhidraURL.makeURL(projectLocator, null, null);
    }

    public static URL makeURL(String projectLocation, String projectName, String projectFilePath, String ref) {
        if (StringUtils.isBlank((CharSequence)projectLocation) || StringUtils.isBlank((CharSequence)projectName)) {
            throw new IllegalArgumentException("Invalid project location and/or name");
        }
        Object path = GhidraURL.checkAbsolutePath(projectLocation);
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        StringBuilder buf = new StringBuilder(PROTOCOL);
        buf.append(":");
        buf.append((String)path);
        buf.append(projectName);
        if (!StringUtils.isBlank((CharSequence)projectFilePath)) {
            if (!projectFilePath.startsWith("/") || projectFilePath.contains("\\")) {
                throw new IllegalArgumentException("Invalid project file path");
            }
            buf.append("?");
            buf.append(projectFilePath);
        }
        if (!StringUtils.isBlank((CharSequence)ref)) {
            buf.append("#");
            buf.append(ref);
        }
        try {
            return new URL(buf.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL makeURL(ProjectLocator projectLocator, String projectFilePath, String ref) {
        return GhidraURL.makeURL(projectLocator.getLocation(), projectLocator.getName(), projectFilePath, ref);
    }

    private static String[] splitOffName(String path) {
        int index;
        String name = "";
        if (!StringUtils.isBlank((CharSequence)path) && !path.endsWith("/") && (index = path.lastIndexOf(47)) >= 0) {
            name = path.substring(index + 1);
            path = path.substring(0, index);
        }
        return new String[]{path, name};
    }

    public static URL makeURL(String host, int port, String repositoryName, String repositoryPath) {
        String[] splitName = GhidraURL.splitOffName(repositoryPath);
        return GhidraURL.makeURL(host, port, repositoryName, splitName[0], splitName[1], null);
    }

    public static URL makeURL(String host, int port, String repositoryName, String repositoryPath, String ref) {
        String[] splitName = GhidraURL.splitOffName(repositoryPath);
        return GhidraURL.makeURL(host, port, repositoryName, splitName[0], splitName[1], ref);
    }

    public static URL makeURL(String host, int port, String repositoryName, String repositoryFolderPath, String fileName, String ref) {
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new IllegalArgumentException("host required");
        }
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            throw new IllegalArgumentException("repository name required");
        }
        if (port == 0 || port == 13100) {
            port = -1;
        }
        String path = "/" + repositoryName;
        if (!StringUtils.isBlank((CharSequence)repositoryFolderPath)) {
            if (!repositoryFolderPath.startsWith("/") || repositoryFolderPath.indexOf(92) >= 0) {
                throw new IllegalArgumentException("Invalid repository path");
            }
            if (!(path = path + repositoryFolderPath).endsWith("/")) {
                path = path + "/";
            }
        }
        if (!StringUtils.isBlank((CharSequence)fileName)) {
            if (fileName.contains("/")) {
                throw new IllegalArgumentException("Invalid folder/file name: " + fileName);
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + fileName;
        }
        if (!StringUtils.isBlank((CharSequence)ref)) {
            path = path + "#" + ref;
        }
        try {
            return new URL(PROTOCOL, host, port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL makeURL(String host, int port, String repositoryName) {
        return GhidraURL.makeURL(host, port, repositoryName, null);
    }
}

