/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.func.SarifFunctionWriter;
import sarif.managers.DtParser;
import sarif.managers.SarifMgr;

public class FunctionsSarifMgr
extends SarifMgr {
    public static String KEY = "FUNCTIONS";
    public static final String LIB_BOOKMARK_CATEGORY = "Library Identification";
    public static final String FID_BOOKMARK_CATEGORY = "Function ID Analyzer";
    public static final Set<String> LIBRARY_BOOKMARK_CATEGORY_STRINGS = Set.of("Library Identification", "Function ID Analyzer");
    private DtParser dtParser;
    private Library extenalNamespace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionsSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        int txId = program.startTransaction("SARIF FunctionMgr");
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            Symbol extLib = symbolTable.getLibrarySymbol("<EXTERNAL>");
            if (extLib == null) {
                this.extenalNamespace = symbolTable.createExternalLibrary("<EXTERNAL>", SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
        finally {
            program.endTransaction(txId, true);
        }
    }

    @Override
    protected void readResults(List<Map<String, Object>> list, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        if (list != null) {
            monitor.setMessage("Processing " + this.key + "...");
            monitor.setMaximum((long)(list.size() * 2));
            this.firstPass = true;
            for (Map<String, Object> result : list) {
                monitor.checkCancelled();
                this.read(result, options, monitor);
                monitor.increment();
            }
            this.firstPass = false;
            for (Map<String, Object> result : list) {
                monitor.checkCancelled();
                this.read(result, options, monitor);
                monitor.increment();
            }
            monitor.incrementProgress();
        } else {
            monitor.setMessage("Skipping over " + this.key + " ...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        DataTypeManager dataManager = this.listing.getDataTypeManager();
        try (BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();){
            boolean isThunk;
            block13: {
                boolean process;
                this.dtParser = new DtParser(dataManager);
                String key = (String)result.get("Message");
                isThunk = (Boolean)result.get("isThunk");
                boolean bl = process = this.firstPass && !isThunk || !this.firstPass && isThunk;
                if (key.equals("Function") && process) break block13;
                boolean bl2 = true;
                return bl2;
            }
            try {
                Address entryPoint = this.getEntryPoint(result);
                Symbol[] symbols = this.program.getSymbolTable().getSymbols(entryPoint);
                Function func = this.createFunction(result, isThunk, entryPoint);
                for (Symbol symbol : symbols) {
                    SourceType srcType = symbol.getSource();
                    if (srcType.equals((Object)SourceType.DEFAULT)) continue;
                    this.program.getSymbolTable().createLabel(entryPoint, symbol.getName(true), srcType);
                }
                String source = (String)result.get("sourceType");
                SourceType sourceType = source.equals("DEFAULT") ? SourceType.IMPORTED : this.getSourceType(source);
                String typeInfoComment = this.setProperties(result, func, entryPoint);
                ArrayList<Variable> stackParams = new ArrayList<Variable>();
                List regVars = (List)result.get("regVars");
                for (Map var : regVars) {
                    this.readRegisterVars(var, func, stackParams);
                }
                Map stack = (Map)result.get("stack");
                this.readStackFrame(stack, func, stackParams, sourceType);
                List parms = (List)result.get("params");
                ArrayList<Variable> formalParams = new ArrayList<Variable>();
                for (Map p : parms) {
                    this.readParameter(p, func, formalParams);
                }
                Map ret = (Map)result.get("ret");
                ReturnParameterImpl retImpl = null;
                if (ret != null) {
                    retImpl = this.readReturnType(ret, func);
                }
                ArrayList<Variable> plist = stackParams;
                if (typeInfoComment != null) {
                    plist = formalParams;
                }
                if (plist != null) {
                    this.updateFunction(func, retImpl, plist, sourceType);
                }
                this.postProcess(result, func, stack);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
        }
        return true;
    }

    private Address getEntryPoint(Map<String, Object> result) throws AddressFormatException {
        String entryPointStr = (String)result.get("location");
        if (entryPointStr == null) {
            throw new RuntimeException("No entry point provided.");
        }
        Address entryPoint = FunctionsSarifMgr.parseAddress(this.factory, entryPointStr);
        if (entryPoint == null) {
            throw new AddressFormatException("Incompatible Function Entry Point Address: " + entryPointStr);
        }
        return entryPoint;
    }

    private Function createFunction(Map<String, Object> result, boolean isThunk, Address entryPoint) throws InvalidInputException, OverlappingFunctionException, DuplicateNameException, AddressOverflowException {
        AddressSet body = new AddressSet(entryPoint, entryPoint);
        this.getLocations(result, body);
        Function func = this.program.getFunctionManager().getFunctionAt(entryPoint);
        if (func == null) {
            String source = (String)result.get("sourceType");
            SourceType sourceType = this.getSourceType(source);
            func = this.program.getFunctionManager().createFunction(null, null, entryPoint, (AddressSetView)body, sourceType);
        }
        String name = (String)result.get("name");
        if (isThunk) {
            this.createThunk(result, func);
        }
        this.setName(entryPoint, func, name, result);
        return func;
    }

    private void setName(Address entryPoint, Function func, String name, Map<String, Object> result) {
        SymbolPath path = new SymbolPath(name);
        if (name != null) {
            String nss = (String)result.get("namespace");
            boolean isThunk = (Boolean)result.get("isThunk");
            if (nss != null && !isThunk) {
                SymbolPath parentPath = new SymbolPath(nss);
                if (!name.startsWith(nss)) {
                    path = new SymbolPath(parentPath, name);
                }
            }
            name = path.getName();
        }
        Symbol symbol = func.getSymbol();
        if (path != null) {
            try {
                Namespace ns = NamespaceUtils.getFunctionNamespaceAt((Program)this.program, (SymbolPath)path, (Address)entryPoint);
                if (ns == null) {
                    ns = this.program.getGlobalNamespace();
                    SymbolPath parent = path.getParent();
                    if (parent != null && !parent.getName().equals(ns.getName())) {
                        Boolean isClass = (Boolean)result.get("namespaceIsClass");
                        String source = (String)result.get("sourceType");
                        SourceType sourceType = source.equals("DEFAULT") ? SourceType.IMPORTED : this.getSourceType(source);
                        ns = this.walkNamespace(this.program.getGlobalNamespace(), parent.getPath() + "::", entryPoint, sourceType, isClass);
                        symbol.setNameAndNamespace(name, ns, this.getSourceType("DEFAULT"));
                        return;
                    }
                }
                if (path != null && path.getName().contains("<EXTERNAL>")) {
                    ns = this.extenalNamespace;
                }
                if (ns.getParentNamespace() == null) {
                    symbol.setName(name, this.getSourceType("DEFAULT"));
                } else {
                    symbol.setNameAndNamespace(name, ns.getParentNamespace(), this.getSourceType("DEFAULT"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String setProperties(Map<String, Object> result, Function func, Address entryPoint) throws InvalidInputException {
        String callingConvention;
        boolean isLibrary = (Boolean)result.get("isLibrary");
        if (isLibrary) {
            BookmarkManager bm = this.program.getBookmarkManager();
            BookmarkType bt = bm.getBookmarkType("IMPORTED");
            if (bt == null) {
                GIcon icon = new GIcon("icon.base.util.xml.functions.bookmark");
                bt = bm.defineType("IMPORTED", (Icon)icon, (Color)GThemeDefaults.Colors.Palette.DARK_GRAY, 0);
            }
            bm.setBookmark(entryPoint, "IMPORTED", LIB_BOOKMARK_CATEGORY, "Library function");
        }
        if ((callingConvention = (String)result.get("callingConvention")) != null) {
            func.setCallingConvention(callingConvention);
        }
        boolean hasVarArgs = (Boolean)result.get("hasVarArgs");
        boolean isInline = (Boolean)result.get("isInline");
        boolean hasNoReturn = (Boolean)result.get("hasNoReturn");
        boolean hasCustomStorage = (Boolean)result.get("hasCustomStorage");
        func.setVarArgs(hasVarArgs);
        func.setInline(isInline);
        func.setNoReturn(hasNoReturn);
        func.setCustomVariableStorage(hasCustomStorage);
        String regularComment = (String)result.get("comment");
        func.setComment(regularComment);
        String repeatableComment = (String)result.get("repeatableComment");
        func.setRepeatableComment(repeatableComment);
        String typeInfoComment = (String)result.get("value");
        return typeInfoComment;
    }

    private void updateFunction(Function func, ReturnParameterImpl retImpl, List<Variable> plist, SourceType sourceType) {
        try {
            Variable[] arr = new Variable[plist.size()];
            int i = 0;
            for (Variable variable : plist) {
                arr[i++] = variable;
            }
            Function.FunctionUpdateType type = func.hasCustomVariableStorage() ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS;
            func.updateFunction(func.getCallingConventionName(), (Variable)retImpl, type, true, SourceType.IMPORTED, arr);
        }
        catch (DuplicateNameException e) {
            this.log.appendMsg("Could not set name of a parameter in function: " + FunctionsSarifMgr.funcDesc(func) + ": " + e.getMessage());
        }
        catch (InvalidInputException iie) {
            this.log.appendMsg("Bad parameter definition in function: " + FunctionsSarifMgr.funcDesc(func) + ": " + iie.getMessage());
        }
    }

    private void postProcess(Map<String, Object> result, Function func, Map<String, Object> stack) {
        String signatureSource = (String)result.get("signatureSource");
        if (signatureSource != null) {
            SourceType signatureSourceType = this.getSourceType(signatureSource);
            func.setSignatureSource(signatureSourceType);
        }
        Boolean purgeValid = (Boolean)result.get("isStackPurgeSizeValid");
        Double purgeSize = (Double)stack.get("purgeSize");
        if (purgeSize != null) {
            if (purgeValid == null) {
                func.setStackPurgeSize((int)purgeSize.doubleValue());
            } else {
                func.setStackPurgeSize(purgeValid != false ? (int)purgeSize.doubleValue() : Integer.MAX_VALUE);
            }
        }
    }

    private void createThunk(Map<String, Object> result, Function func) throws InvalidInputException, DuplicateNameException {
        String thunkStr = (String)result.get("thunkAddress");
        if (thunkStr == null) {
            throw new RuntimeException("No thunk address provided.");
        }
        Function thunkFn = null;
        Address thunk = FunctionsSarifMgr.parseAddress(this.factory, thunkStr);
        if (thunk.isExternalAddress()) {
            Symbol symbol = ((ExternalLocation)externalMap.get(thunkStr)).getSymbol();
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                thunkFn = (Function)symbol.getObject();
                func.setThunkedFunction(thunkFn);
            }
        } else {
            thunkFn = this.program.getFunctionManager().getFunctionAt(thunk);
            if (thunkFn == null) {
                CreateFunctionCmd cmd = new CreateFunctionCmd(thunk);
                if (!cmd.applyTo((DomainObject)this.program)) {
                    Msg.error((Object)this, (Object)("Failed to create function at " + thunk + ": " + cmd.getStatusMsg()));
                }
                thunkFn = cmd.getFunction();
            }
            func.setThunkedFunction(thunkFn);
        }
    }

    private void addLocalVar(Function function, Variable v, SourceType sourceType, boolean overwriteConflicts) throws InvalidInputException {
        VariableUtilities.checkVariableConflict((Function)function, (Variable)v, (VariableStorage)v.getVariableStorage(), (boolean)overwriteConflicts);
        try {
            function.addLocalVariable(v, sourceType);
        }
        catch (DuplicateNameException e) {
            this.log.appendMsg("Could not add local variable to function " + FunctionsSarifMgr.funcDesc(function) + ": " + v.getName() + ": " + e.getMessage());
        }
    }

    private static String funcDesc(Function func) {
        return func.getName() + "[" + func.getEntryPoint().toString() + "]";
    }

    private DataType findDataType(Map<String, Object> result) {
        String name = (String)result.get("name");
        if (name == null) {
            return DataType.DEFAULT;
        }
        CategoryPath cp = new CategoryPath((String)result.get("location"));
        Double size = (Double)result.get("size");
        return this.dtParser.parseDataType(name, cp, size == null ? -1 : (int)size.doubleValue());
    }

    private void readStackFrame(Map<String, Object> result, Function func, List<Variable> stackParams, SourceType sourceType) {
        Double retOffset;
        if (func == null) {
            return;
        }
        StackFrame frame = func.getStackFrame();
        Double localVarSize = (Double)result.get("localVarSize");
        if (localVarSize != null) {
            frame.setLocalSize((int)localVarSize.doubleValue());
        }
        if ((retOffset = (Double)result.get("returnAddressOffset")) != null) {
            frame.setReturnAddressOffset((int)retOffset.doubleValue());
        }
        List stackVars = (List)result.get("stackVars");
        for (Map var : stackVars) {
            this.readVariable(var, func, stackParams, sourceType);
        }
    }

    private void readVariable(Map<String, Object> result, Function function, List<Variable> stackParams, SourceType sourceType) {
        String name;
        int offset = (int)((Double)result.get("offset")).doubleValue();
        int size = (int)((Double)result.get("size")).doubleValue();
        Map type = (Map)result.get("type");
        DataType dt = this.findDataType(type);
        if (dt == null) {
            this.log.appendMsg("Missing datatype: " + type.get("name"));
            dt = Undefined.getUndefinedDataType((int)size);
        }
        if ((name = (String)result.get("name")) != null) {
            name = this.getUniqueVarName(function, name, offset);
        }
        try {
            LocalVariableImpl var = new LocalVariableImpl(name, dt, offset, this.program);
            VariableUtilities.checkVariableConflict((Function)function, (Variable)var, (VariableStorage)var.getVariableStorage(), (boolean)true);
            StackFrame stackFrame = function.getStackFrame();
            boolean isParameter = stackFrame.isParameterOffset(offset);
            if (!isParameter) {
                isParameter = stackFrame.isParameterOffset(offset + size - 1);
            }
            if (isParameter) {
                var = new ParameterImpl(name, dt, offset, this.program);
                stackParams.add((Variable)var);
            } else {
                var = new LocalVariableImpl(name, dt, offset, this.program);
                this.addLocalVar(function, (Variable)var, sourceType, true);
            }
            String regularComment = (String)result.get("comment");
            var.setComment(regularComment);
        }
        catch (InvalidInputException e) {
            this.log.appendException((Throwable)e);
        }
    }

    private DataType readParameter(Map<String, Object> result, Function function, List<Variable> formalParams) {
        String name = (String)result.get("name");
        int size = (int)((Double)result.get("size")).doubleValue();
        String regularComment = (String)result.get("comment");
        Map type = (Map)result.get("formalType");
        DataType dt = this.findDataType(type);
        if (dt == null) {
            this.log.appendMsg("Missing datatype: " + type.get("name"));
            dt = Undefined.getUndefinedDataType((int)size);
        }
        try {
            ProgramContext context = this.program.getProgramContext();
            List rnames = (List)result.get("registers");
            if (rnames != null) {
                if (formalParams != null) {
                    for (String r : rnames) {
                        Register register = context.getRegister(r);
                        ParameterImpl var = new ParameterImpl(name, dt, register, this.program);
                        var.setComment(regularComment);
                        formalParams.add((Variable)var);
                    }
                }
                return dt;
            }
            int offset = (int)((Double)result.get("stackOffset")).doubleValue();
            if (formalParams != null) {
                ParameterImpl var = new ParameterImpl(name, dt, offset, this.program);
                var.setComment(regularComment);
                formalParams.add((Variable)var);
            }
            return dt;
        }
        catch (InvalidInputException e) {
            this.log.appendException((Throwable)e);
            return null;
        }
    }

    private ReturnParameterImpl readReturnType(Map<String, Object> result, Function function) {
        int size = (int)((Double)result.get("size")).doubleValue();
        int offset = (int)((Double)result.get("stackOffset")).doubleValue();
        Map type = (Map)result.get("formalType");
        DataType dt = this.findDataType(type);
        if (dt == null) {
            this.log.appendMsg("Missing datatype: " + type.get("name"));
            dt = Undefined.getUndefinedDataType((int)size);
        }
        try {
            List rnames = (List)result.get("registers");
            if (rnames != null) {
                List<Varnode> vnodes = this.convertRegisterListToVarnodeStorage(rnames, dt.getLength(), offset);
                VariableStorage returnStorage = new VariableStorage((ProgramArchitecture)this.program, vnodes);
                return new ReturnParameterImpl(dt, returnStorage, true, this.program);
            }
            if (offset >= 0) {
                return new ReturnParameterImpl(dt, offset, this.program);
            }
            return new ReturnParameterImpl(dt, this.program);
        }
        catch (InvalidInputException e) {
            this.log.appendException((Throwable)e);
            return null;
        }
    }

    private String getUniqueVarName(Function function, String name, int offset) {
        Variable v;
        Symbol s = this.program.getSymbolTable().getVariableSymbol(name, function);
        if (s == null) {
            return name;
        }
        SymbolType st = s.getSymbolType();
        if ((st == SymbolType.LOCAL_VAR || st == SymbolType.PARAMETER) && (v = (Variable)s.getObject()).isStackVariable() && offset == v.getStackOffset()) {
            return name;
        }
        return name + "_" + offset;
    }

    private void readRegisterVars(Map<String, Object> result, Function function, List<Variable> stackParams) {
        try {
            ProgramContext context = this.program.getProgramContext();
            String name = (String)result.get("name");
            String registerName = (String)result.get("register");
            if (registerName == null) {
                return;
            }
            Register register = context.getRegister(registerName);
            Map type = (Map)result.get("type");
            DataType dt = this.findDataType(type);
            if (dt != null && dt.getLength() > register.getMinimumByteSize()) {
                this.log.appendMsg("Data type [" + result.get("type") + "] too large for register [" + registerName + "]");
                dt = null;
            }
            ParameterImpl registerParam = new ParameterImpl(name, dt, register, this.program);
            String comment = (String)result.get("comment");
            registerParam.setComment(comment);
            stackParams.add((Variable)registerParam);
        }
        catch (InvalidInputException e) {
            this.log.appendException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.log.appendException((Throwable)e);
        }
    }

    public List<Varnode> convertRegisterListToVarnodeStorage(List<String> registNames, int dataTypeSize, int stackOffset) {
        ArrayList<Varnode> results = new ArrayList<Varnode>();
        ProgramContext context = this.program.getProgramContext();
        for (String rname : registNames) {
            Register reg = context.getRegister(rname);
            int regSize = reg.getMinimumByteSize();
            int bytesUsed = Math.min(dataTypeSize, regSize);
            Address addr = reg.getAddress();
            if (reg.isBigEndian() && bytesUsed < regSize) {
                addr = addr.add((long)(regSize - bytesUsed));
            }
            results.add(new Varnode(addr, bytesUsed));
            dataTypeSize -= bytesUsed;
        }
        if (dataTypeSize != 0 && stackOffset >= 0) {
            results.add(new Varnode(this.program.getAddressFactory().getStackSpace().getAddress((long)stackOffset), dataTypeSize));
        }
        return results;
    }

    void write(JsonArray results, AddressSetView addrs, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing FUNCTIONS ...");
        ArrayList<Function> request = new ArrayList<Function>();
        FunctionIterator iter = this.listing.getFunctions(addrs, true);
        while (iter.hasNext()) {
            request.add((Function)iter.next());
        }
        FunctionsSarifMgr.writeAsSARIF(this.program, request, results);
    }

    public static void writeAsSARIF(Program program, List<Function> request, JsonArray results) throws IOException {
        SarifFunctionWriter writer = new SarifFunctionWriter(program.getFunctionManager(), request, null);
        new TaskLauncher((Task)new SarifWriterTask("Functions", writer, results), null);
    }
}

