/*
 * Decompiled with CFR 0.152.
 */
package sarif.export;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ISF.IsfObject;

public class SarifObject
implements IsfObject {
    public static boolean SARIF = true;
    protected JsonObject message;
    protected String kind;
    protected String level;
    protected String ruleId;
    protected JsonArray locations;
    protected JsonObject properties;
    protected JsonObject element;

    public SarifObject(String key, String ruleKey, JsonElement element) {
        if (SARIF) {
            this.message = new JsonObject();
            this.message.addProperty("text", key);
            this.kind = "INFORMATIONAL";
            this.level = "NONE";
            this.ruleId = ruleKey;
            this.properties = new JsonObject();
            this.properties.add("additionalProperties", element);
        } else {
            this.element = (JsonObject)element;
            this.element.addProperty("key", key);
            this.element.addProperty("rule", ruleKey);
        }
    }

    public SarifObject(String key, String ruleKey, JsonElement tree, Address min, Address max) {
        this(key, ruleKey, tree);
        if (min != null) {
            this.writeLocations(min, max);
        }
    }

    public SarifObject(String key, String ruleKey, JsonElement tree, AddressSetView body) {
        this(key, ruleKey, tree);
        if (body != null) {
            this.writeLocations(body);
        }
    }

    protected void writeLocations(Address min, Address max) {
        if (SARIF) {
            this.locations = new JsonArray();
            JsonObject element = new JsonObject();
            this.locations.add((JsonElement)element);
            JsonObject ploc = new JsonObject();
            element.add("physicalLocation", (JsonElement)ploc);
            JsonObject address = new JsonObject();
            ploc.add("address", (JsonElement)address);
            address.addProperty("absoluteAddress", (Number)min.getOffset());
            address.addProperty("length", (Number)(max.subtract(min) + 1L));
            Address minAddress = min;
            if (minAddress.getAddressSpace().getType() != 1) {
                JsonObject artifact = new JsonObject();
                ploc.add("artifactLocation", (JsonElement)artifact);
                artifact.addProperty("uri", minAddress.toString());
            }
        } else {
            this.element.addProperty("startAddress", min.toString(true));
            this.element.addProperty("stopAddress", max.toString(true));
        }
    }

    protected void writeLocations(AddressSetView set) {
        if (SARIF) {
            this.locations = new JsonArray();
            AddressRangeIterator addressRanges = set.getAddressRanges();
            while (addressRanges.hasNext()) {
                JsonObject element = new JsonObject();
                this.locations.add((JsonElement)element);
                AddressRange next = (AddressRange)addressRanges.next();
                JsonObject ploc = new JsonObject();
                element.add("physicalLocation", (JsonElement)ploc);
                JsonObject address = new JsonObject();
                ploc.add("address", (JsonElement)address);
                address.addProperty("absoluteAddress", (Number)next.getMinAddress().getOffset());
                address.addProperty("length", (Number)next.getLength());
                Address minAddress = next.getMinAddress();
                if (minAddress.getAddressSpace().getType() == 1) continue;
                JsonObject artifact = new JsonObject();
                ploc.add("artifactLocation", (JsonElement)artifact);
                artifact.addProperty("uri", minAddress.toString());
            }
        } else {
            this.element.addProperty("startAddress", set.getMinAddress().toString(true));
            this.element.addProperty("stopAddress", set.getMaxAddress().toString(true));
        }
    }
}

