/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.SarifSchema210;
import com.google.gson.JsonSyntaxException;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramVisibilityChangePluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.bean.opteditor.OptionsVetoException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import resources.ResourceManager;
import sarif.SarifController;
import sarif.io.SarifGsonIO;
import sarif.io.SarifIO;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Miscellaneous", category="Analysis", shortDescription="Sarif Plugin.", description="From sarif parsing to DL modelling")
public class SarifPlugin
extends ProgramPlugin
implements OptionsChangeListener {
    public static final String NAME = "Sarif";
    public static final Icon SARIF_ICON = ResourceManager.loadImage((String)"images/peach_16.png");
    private Map<Program, SarifController> sarifControllers = new HashMap<Program, SarifController>();
    private SarifIO io = new SarifGsonIO();
    private boolean displayGraphsByDefault = false;
    private boolean displayArtifactsByDefault = false;
    private int maxGraphSize = 1000;
    private boolean appendToCurrentGraph = false;

    public SarifPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.createActions();
        this.initializeOptions();
    }

    public void readFile(File file) {
        if (file != null) {
            try {
                this.showSarif(file.getName(), this.io.readSarif(file));
            }
            catch (JsonSyntaxException | IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"File parse error", (Object)"Invalid Sarif File");
            }
        }
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        Program eventProgram = null;
        if (event instanceof ProgramActivatedPluginEvent) {
            ev = (ProgramActivatedPluginEvent)event;
            eventProgram = ev.getActiveProgram();
        } else if (event instanceof ProgramOpenedPluginEvent) {
            ev = (ProgramOpenedPluginEvent)event;
            eventProgram = ev.getProgram();
        } else if (event instanceof ProgramClosedPluginEvent) {
            ev = (ProgramClosedPluginEvent)event;
            eventProgram = ev.getProgram();
        } else if (event instanceof ProgramClosedPluginEvent) {
            ev = (ProgramClosedPluginEvent)event;
            eventProgram = ev.getProgram();
        } else if (event instanceof ProgramVisibilityChangePluginEvent) {
            ev = (ProgramVisibilityChangePluginEvent)event;
            eventProgram = ev.getProgram();
        }
        SarifController controller = this.sarifControllers.get(eventProgram);
        if (controller != null) {
            if (event instanceof ProgramClosedPluginEvent) {
                controller.dispose();
                this.sarifControllers.remove(eventProgram, controller);
            } else if (event instanceof ProgramVisibilityChangePluginEvent) {
                ProgramVisibilityChangePluginEvent ev = (ProgramVisibilityChangePluginEvent)event;
                controller.showTable(ev.isProgramVisible());
            } else {
                controller.showTable(true);
            }
        }
    }

    public void showSarif(String logName, SarifSchema210 sarif) {
        this.currentProgram = this.getCurrentProgram();
        if (this.currentProgram != null) {
            SarifController currentController;
            if (!this.sarifControllers.containsKey(this.currentProgram)) {
                SarifController controller = new SarifController(this.currentProgram, this);
                this.sarifControllers.put(this.currentProgram, controller);
            }
            if ((currentController = this.sarifControllers.get(this.currentProgram)) != null) {
                currentController.showTable(logName, sarif);
                return;
            }
        }
        Msg.showError((Object)((Object)this), (Component)this.tool.getActiveWindow(), (String)"File parse error", (Object)"No current program");
    }

    public void makeSelection(List<Address> addrs) {
        AddressSet selection = new AddressSet();
        for (Address addr : addrs) {
            selection.add(addr);
        }
        this.setSelection((AddressSetView)selection);
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Read", this.getName()).menuPath(new String[]{NAME, "Read File"})).menuGroup("sarif", "1")).enabledWhen(ctx -> this.getCurrentProgram() != null)).onAction(e -> {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.readFile(chooser.getSelectedFile());
        })).buildAndInstall((Tool)this.tool);
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Graph");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        HelpLocation help = new HelpLocation(this.getName(), "Options");
        Options sarifOptions = options.getOptions(NAME);
        this.registerOptions(sarifOptions, help);
        this.loadOptions(sarifOptions);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) throws OptionsVetoException {
        Options sarifOptions = options.getOptions(NAME);
        this.loadOptions(sarifOptions);
    }

    public void registerOptions(Options options, HelpLocation help) {
        options.setOptionsHelpLocation(help);
        options.registerOption("Display Artifacts", (Object)this.displayArtifacts(), help, "Display artifacts by default");
        options.registerOption("Display Graphs", (Object)this.displayGraphs(), help, "Display graphs by default");
        options.registerOption("Max Graph Size", (Object)this.getGraphSize(), help, "Maximum number of nodes per graph");
        options.registerOption("Append Graphs", (Object)this.appendToGraph(), help, "Append to existing graph");
    }

    public void loadOptions(Options options) {
        this.displayArtifactsByDefault = options.getBoolean("Display Artifacts", this.displayArtifacts());
        this.displayGraphsByDefault = options.getBoolean("Display Graphs", this.displayGraphs());
        this.maxGraphSize = options.getInt("Max Graph Size", this.getGraphSize());
        this.appendToCurrentGraph = options.getBoolean("Append Graphs", this.appendToGraph());
    }

    public boolean displayGraphs() {
        return this.displayGraphsByDefault;
    }

    public boolean displayArtifacts() {
        return this.displayArtifactsByDefault;
    }

    public int getGraphSize() {
        return this.maxGraphSize;
    }

    public boolean appendToGraph() {
        return this.appendToCurrentGraph;
    }
}

