/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import ghidra.dbg.jdi.manager.JdiConsoleOutputListener;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.jdi.model.iface1.JdiModelSelectableObject;
import ghidra.dbg.jdi.model.iface1.JdiModelTargetConsole;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Process", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="state", type=TargetExecutionStateful.TargetExecutionState.class, hidden=true), @TargetAttributeType(type=Void.class)})
public class JdiModelTargetProcess
extends JdiModelTargetObjectImpl
implements JdiModelTargetConsole,
JdiConsoleOutputListener,
JdiModelSelectableObject {
    static String STATE_ATTRIBUTE_NAME = "_state";
    protected final Process process;
    private Thread input;
    private Thread error;

    public static String getUniqueId(Process obj) {
        return Long.toHexString(obj.pid());
    }

    public JdiModelTargetProcess(JdiModelTargetVM vm, Process process, boolean isElement) {
        super(vm, JdiModelTargetProcess.getUniqueId(process), process, isElement);
        this.process = process;
        this.input = new Thread(() -> this.readStream(process.getInputStream(), TargetConsole.Channel.STDOUT), "JDI process input reader");
        this.input.start();
        this.error = new Thread(() -> this.readStream(process.getErrorStream(), TargetConsole.Channel.STDERR), "JDI process error reader");
        this.error.start();
        this.changeAttributes(List.of(), List.of(), Map.of(STATE_ATTRIBUTE_NAME, this.convertState(process.isAlive()), "_display", this.getDisplay()), "Initialized");
    }

    @Override
    public String getDisplay() {
        if (this.process == null) {
            return super.getDisplay();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Process " + this.process.pid());
        sb.append(" alive=");
        sb.append(this.process.isAlive());
        return sb.toString();
    }

    protected TargetExecutionStateful.TargetExecutionState convertState(boolean isAlive) {
        return isAlive ? TargetExecutionStateful.TargetExecutionState.ALIVE : TargetExecutionStateful.TargetExecutionState.TERMINATED;
    }

    @Override
    @Internal
    public CompletableFuture<Void> setActive() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void output(TargetConsole.Channel channel, String out) {
        switch (channel) {
            case STDOUT: {
                channel = TargetConsole.Channel.STDOUT;
                break;
            }
            case STDERR: {
                channel = TargetConsole.Channel.STDERR;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.broadcast().consoleOutput((TargetObject)this, channel, out);
    }

    private void readStream(InputStream in, TargetConsole.Channel channel) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while (this.process.isAlive() && null != (line = reader.readLine())) {
                System.err.println(line);
                this.output(channel, line);
            }
        }
        catch (Throwable e) {
            Msg.debug((Object)this, (Object)(channel + ", reader exiting because " + e));
        }
    }

    public CompletableFuture<Void> write(byte[] data) {
        return null;
    }
}

