/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBHandle;
import db.DBRecord;
import db.Table;
import db.TableStatistics;
import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import docking.framework.DockingApplicationConfiguration;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import generic.application.GenericApplicationLayout;
import ghidra.app.plugin.debug.dbtable.DbSmallTableModel;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import utility.application.ApplicationLayout;

public class DbViewer
extends JFrame {
    private static final String LAST_BUFFER_FILE_DIRECTORY = "LastBufferFileDirectory";
    private File dbFile;
    private DBHandle dbh;
    private JMenuItem openItem;
    private JMenuItem closeItem;
    private JPanel mainPanel;
    private JPanel southPanel;
    private JComboBox<String> combo;
    private Table[] tables;
    private Hashtable<String, TableStatistics[]> tableStats = new Hashtable();
    private GTableFilterPanel<DBRecord> tableFilterPanel;

    DbViewer() {
        super("Database Viewer");
        this.setDefaultCloseOperation(3);
        this.buildGui();
    }

    void buildGui() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        this.openItem = new JMenuItem("Open Database...");
        menu.add(this.openItem);
        this.openItem.addActionListener(e -> this.openDb());
        this.closeItem = new JMenuItem("Close Database");
        menu.add(this.closeItem);
        this.closeItem.setEnabled(false);
        this.closeItem.addActionListener(e -> this.closeDb());
        JMenuItem exitItem = new JMenuItem("Exit");
        menu.add(exitItem);
        exitItem.addActionListener(e -> System.exit(0));
        this.setJMenuBar(menuBar);
    }

    private void openDb() {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this);
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter("gbf", "Ghidra Buffer File"));
        fileChooser.setCurrentDirectory(new File("C:\\"));
        fileChooser.setLastDirectoryPreference(LAST_BUFFER_FILE_DIRECTORY);
        File selectedFile = fileChooser.getSelectedFile(true);
        fileChooser.dispose();
        if (selectedFile == null) {
            return;
        }
        if (this.dbh != null) {
            this.closeDb();
        }
        Msg.debug((Object)this, (Object)("Buffer file = " + selectedFile.getName()));
        this.tables = new Table[0];
        try {
            this.dbFile = selectedFile;
            LocalBufferFile bf = new LocalBufferFile(selectedFile, true);
            this.dbh = new DBHandle((BufferFile)bf);
            this.tables = this.dbh.getTables();
            Arrays.sort(this.tables, new TableNameComparator());
        }
        catch (IOException e) {
            try {
                PackedDatabase pdb = PackedDatabase.getPackedDatabase((File)selectedFile, (TaskMonitor)TaskMonitor.DUMMY);
                this.dbh = pdb.open(TaskMonitor.DUMMY);
                this.tables = this.dbh.getTables();
                Arrays.sort(this.tables, new TableNameComparator());
            }
            catch (Exception e1) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                return;
            }
        }
        this.createMainPanel();
        this.closeItem.setEnabled(true);
    }

    private void closeDb() {
        this.dbh.close();
        this.dbh = null;
        this.getContentPane().remove(this.mainPanel);
        this.closeItem.setEnabled(false);
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new FlowLayout(0));
        JPanel subNorthPanel = new JPanel((LayoutManager)new PairLayout(4, 10));
        subNorthPanel.add((Component)new GLabel("Database:"));
        subNorthPanel.add((Component)new GLabel(this.dbFile.getName()));
        subNorthPanel.add((Component)new GLabel("Tables:"));
        Object[] names = new String[this.tables.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.tables[i].getName() + " (" + Integer.toString(this.tables[i].getRecordCount()) + ")";
        }
        this.combo = new GComboBox(names);
        this.combo.addActionListener(e -> this.updateTable());
        subNorthPanel.add(this.combo);
        northPanel.add(subNorthPanel);
        this.mainPanel.add((Component)northPanel, "North");
        this.getContentPane().add(this.mainPanel);
        this.southPanel = this.createSouthPanel(this.tables[0]);
        this.mainPanel.add((Component)this.southPanel, "Center");
        this.validate();
    }

    private void updateTable() {
        Table table = this.tables[this.combo.getSelectedIndex()];
        this.mainPanel.remove(this.southPanel);
        this.southPanel = this.createSouthPanel(table);
        this.mainPanel.add((Component)this.southPanel, "Center");
        this.validate();
    }

    private JPanel createSouthPanel(Table table) {
        JPanel panel = new JPanel(new BorderLayout());
        DbSmallTableModel model = new DbSmallTableModel((ServiceProvider)new ServiceProviderStub(), table);
        GTable gTable = new GTable((TableModel)model);
        this.tableFilterPanel = new GTableFilterPanel((JTable)gTable, (RowObjectTableModel)model);
        JScrollPane scroll = new JScrollPane((Component)gTable);
        panel.add((Component)scroll, "Center");
        panel.add((Component)this.tableFilterPanel, "South");
        TableStatistics[] stats = this.getStats(table);
        String recCnt = "Records: " + Integer.toString(table.getRecordCount());
        Object intNodeCnt = "";
        Object recNodeCnt = "";
        Object chainBufCnt = "";
        Object size = "";
        if (stats != null) {
            intNodeCnt = "Interior Nodes: " + Integer.toString(stats[0].interiorNodeCnt);
            recNodeCnt = "Record Nodes: " + Integer.toString(stats[0].recordNodeCnt);
            chainBufCnt = "Chained Buffers: " + Integer.toString(stats[0].chainedBufferCnt);
            size = "Size (KB): " + Integer.toString(stats[0].size / 1024);
            if (stats.length > 1) {
                intNodeCnt = (String)intNodeCnt + " / " + Integer.toString(stats[1].interiorNodeCnt);
                recNodeCnt = (String)recNodeCnt + " / " + Integer.toString(stats[1].recordNodeCnt);
                chainBufCnt = (String)chainBufCnt + " / " + Integer.toString(stats[1].chainedBufferCnt);
                size = (String)size + " / " + Integer.toString(stats[1].size / 1024);
            }
        }
        GDLabel statsLabel = new GDLabel(recCnt + "   " + (String)intNodeCnt + "   " + (String)recNodeCnt + "   " + (String)chainBufCnt + "   " + (String)size);
        panel.add((Component)statsLabel, "South");
        return panel;
    }

    private TableStatistics[] getStats(Table table) {
        TableStatistics[] stats = this.tableStats.get(table.getName());
        if (stats == null) {
            try {
                stats = table.getAllStatistics();
                for (int i = 2; i < stats.length; ++i) {
                    stats[1].bufferCount += stats[i].bufferCount;
                    stats[1].chainedBufferCnt += stats[i].chainedBufferCnt;
                    stats[1].interiorNodeCnt += stats[i].interiorNodeCnt;
                    stats[1].recordNodeCnt += stats[i].recordNodeCnt;
                    stats[1].size += stats[i].size;
                }
                this.tableStats.put(table.getName(), stats);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Exception loading stats", (Throwable)e);
            }
        }
        return stats;
    }

    public static void main(String[] args) throws FileNotFoundException {
        GenericApplicationLayout layout = new GenericApplicationLayout("DB Viewer", "1.0");
        DockingApplicationConfiguration configuration = new DockingApplicationConfiguration();
        configuration.setShowSplashScreen(false);
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        DbViewer viewer = new DbViewer();
        viewer.setSize(new Dimension(500, 400));
        viewer.setVisible(true);
    }

    private class TableNameComparator
    implements Comparator<Table> {
        private TableNameComparator() {
        }

        @Override
        public int compare(Table t1, Table t2) {
            return t1.getName().compareTo(t2.getName());
        }
    }
}

