/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.target;

import java.util.HashMap;
import java.util.Map;

public record ActionName(String name, boolean builtIn) {
    private static final Map<String, ActionName> NAMES = new HashMap<String, ActionName>();
    public static final ActionName REFRESH = ActionName.builtIn("refresh");
    public static final ActionName ACTIVATE = ActionName.builtIn("activate");
    public static final ActionName FOCUS = ActionName.builtIn("focus");
    public static final ActionName TOGGLE = ActionName.builtIn("toggle");
    public static final ActionName DELETE = ActionName.builtIn("delete");
    public static final ActionName EXECUTE = ActionName.builtIn("execute");
    public static final ActionName CONNECT = ActionName.extended("connect");
    public static final ActionName ATTACH = ActionName.extended("attach");
    public static final ActionName DETACH = ActionName.extended("detach");
    public static final ActionName LAUNCH = ActionName.extended("launch");
    public static final ActionName KILL = ActionName.builtIn("kill");
    public static final ActionName RESUME = ActionName.builtIn("resume");
    public static final ActionName INTERRUPT = ActionName.builtIn("interrupt");
    public static final ActionName STEP_INTO = ActionName.builtIn("step_into");
    public static final ActionName STEP_OVER = ActionName.builtIn("step_over");
    public static final ActionName STEP_OUT = ActionName.builtIn("step_out");
    public static final ActionName STEP_SKIP = ActionName.builtIn("step_skip");
    public static final ActionName STEP_BACK = ActionName.builtIn("step_back");
    public static final ActionName STEP_EXT = ActionName.extended("step_ext");
    public static final ActionName BREAK_SW_EXECUTE = ActionName.builtIn("break_sw_execute");
    public static final ActionName BREAK_HW_EXECUTE = ActionName.builtIn("break_hw_execute");
    public static final ActionName BREAK_READ = ActionName.builtIn("break_read");
    public static final ActionName BREAK_WRITE = ActionName.builtIn("break_write");
    public static final ActionName BREAK_ACCESS = ActionName.builtIn("break_access");
    public static final ActionName BREAK_EXT = ActionName.extended("break_ext");
    public static final ActionName READ_MEM = ActionName.builtIn("read_mem");
    public static final ActionName WRITE_MEM = ActionName.builtIn("write_mem");
    public static final ActionName WRITE_REG = ActionName.builtIn("write_reg");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionName name(String name) {
        Map<String, ActionName> map = NAMES;
        synchronized (map) {
            return NAMES.computeIfAbsent(name, n -> new ActionName((String)n, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionName builtIn(String name) {
        Map<String, ActionName> map = NAMES;
        synchronized (map) {
            ActionName action = new ActionName(name, true);
            if (NAMES.put(name, action) != null) {
                throw new AssertionError();
            }
            return action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ActionName extended(String name) {
        Map<String, ActionName> map = NAMES;
        synchronized (map) {
            ActionName action = new ActionName(name, false);
            if (NAMES.put(name, action) != null) {
                throw new AssertionError();
            }
            return action;
        }
    }
}

