/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.model;

import ghidra.debug.api.model.DebuggerTargetTraceMapper;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface DebuggerMappingOffer {
    public static DebuggerTargetTraceMapper first(Collection<DebuggerMappingOffer> offers) {
        for (DebuggerMappingOffer offer : offers) {
            if (offer.isOverride()) continue;
            try {
                DebuggerTargetTraceMapper mapper = offer.take();
                Msg.info(DebuggerMappingOffer.class, (Object)("Selected first mapping offer: " + offer));
                return mapper;
            }
            catch (Throwable t) {
                Msg.error(DebuggerMappingOffer.class, (Object)("Offer " + offer + " failed to take. Trying next."));
            }
        }
        return null;
    }

    public static DebuggerMappingOffer unique(Collection<DebuggerMappingOffer> offers) {
        List filt = offers.stream().filter(o -> !o.isOverride()).collect(Collectors.toList());
        if (filt.size() != 1) {
            return null;
        }
        return (DebuggerMappingOffer)filt.get(0);
    }

    public int getConfidence();

    default public boolean isOverride() {
        return this.getConfidence() < 0;
    }

    public String getDescription();

    public LanguageID getTraceLanguageID();

    public CompilerSpecID getTraceCompilerSpecID();

    public DebuggerTargetTraceMapper take();
}

