/*
 * Decompiled with CFR 0.152.
 */
package ghidra.codecompare;

import docking.ActionContext;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DualDecompilerActionContext;
import ghidra.app.decompiler.component.DualDecompilerFieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.services.FunctionComparisonService;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.codecompare.AbstractMatchedTokensAction;
import ghidra.codecompare.DecompilerDiffCodeComparisonPanel;
import ghidra.codecompare.TokenPair;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

public class CompareFuncsFromMatchedTokensAction
extends AbstractMatchedTokensAction {
    private PluginTool tool;
    private static final String ACTION_NAME = "Compare Matching Callees";
    private static final String MENU_GROUP = "A1_Compare";
    private static final String HELP_TOPIC = "FunctionComparison";

    public CompareFuncsFromMatchedTokensAction(DecompilerDiffCodeComparisonPanel diffPanel, PluginTool tool) {
        super(ACTION_NAME, tool.getName(), diffPanel, false);
        this.tool = tool;
        FunctionComparisonService service = (FunctionComparisonService)tool.getService(FunctionComparisonService.class);
        if (service != null) {
            MenuData menuData = new MenuData(new String[]{ACTION_NAME}, null, MENU_GROUP);
            this.setPopupMenuData(menuData);
            this.setEnabled(true);
            this.setHelpLocation(new HelpLocation(HELP_TOPIC, ACTION_NAME));
        }
    }

    @Override
    protected boolean enabledForTokens(TokenPair tokenPair) {
        if (tokenPair == null) {
            return false;
        }
        if (tokenPair.leftToken() == null || tokenPair.rightToken() == null) {
            return false;
        }
        PcodeOp leftOp = tokenPair.leftToken().getPcodeOp();
        PcodeOp rightOp = tokenPair.rightToken().getPcodeOp();
        if (leftOp == null || rightOp == null) {
            return false;
        }
        if (leftOp.getOpcode() != 7 || rightOp.getOpcode() != 7) {
            return false;
        }
        return tokenPair.leftToken() instanceof ClangFuncNameToken && tokenPair.rightToken() instanceof ClangFuncNameToken;
    }

    public void actionPerformed(ActionContext context) {
        if (!(context instanceof DualDecompilerActionContext)) {
            return;
        }
        DualDecompilerActionContext compareContext = (DualDecompilerActionContext)context;
        CodeComparisonPanel codeComparisonPanel = compareContext.getCodeComparisonPanel();
        if (!(codeComparisonPanel instanceof DecompilerCodeComparisonPanel)) {
            return;
        }
        DecompilerCodeComparisonPanel decompPanel = (DecompilerCodeComparisonPanel)codeComparisonPanel;
        TokenPair currentPair = this.getCurrentTokenPair((DecompilerCodeComparisonPanel<? extends DualDecompilerFieldPanelCoordinator>)decompPanel);
        if (currentPair == null || currentPair.leftToken() == null || currentPair.rightToken() == null) {
            return;
        }
        ClangFuncNameToken leftFuncToken = (ClangFuncNameToken)currentPair.leftToken();
        ClangFuncNameToken rightFuncToken = (ClangFuncNameToken)currentPair.rightToken();
        Function leftFunction = this.getFuncFromToken(leftFuncToken, decompPanel.getLeftProgram());
        Function rightFunction = this.getFuncFromToken(rightFuncToken, decompPanel.getRightProgram());
        if (leftFunction == null || rightFunction == null) {
            return;
        }
        FunctionComparisonService service = (FunctionComparisonService)this.tool.getService(FunctionComparisonService.class);
        if (service == null) {
            Msg.error((Object)((Object)this), (Object)"Function Comparison Service not found!");
            return;
        }
        FunctionComparisonProvider comparisonProvider = service.createFunctionComparisonProvider();
        comparisonProvider.removeAddFunctionsAction();
        comparisonProvider.getModel().compareFunctions(leftFunction, rightFunction);
    }

    private Function getFuncFromToken(ClangFuncNameToken funcToken, Program program) {
        Address callTarget = funcToken.getPcodeOp().getInput(0).getAddress();
        Function func = program.getFunctionManager().getFunctionAt(callTarget);
        if (func == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare Callees", (Object)("Can't compare callees - null Function for " + funcToken.getText()));
            return null;
        }
        if (func.isExternal()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare Callees", (Object)("Can't compare callees - " + func.getName() + " is external"));
            return null;
        }
        if (!func.isThunk()) {
            return func;
        }
        if ((func = func.getThunkedFunction(true)).isExternal()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare", (Object)("Can't compare callees - " + func.getName() + " is external"));
            return null;
        }
        return func;
    }
}

