/*
 * Decompiled with CFR 0.152.
 */
package ghidra.codecompare;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.DecompilerCodeComparisonPanel;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DualDecompilerActionContext;
import ghidra.app.decompiler.component.DualDecompilerFieldPanelCoordinator;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.codecompare.DecompilerDiffCodeComparisonPanel;
import ghidra.codecompare.TokenPair;
import ghidra.codecompare.graphanalysis.TokenBin;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.List;

public abstract class AbstractMatchedTokensAction
extends DockingAction {
    protected DecompilerDiffCodeComparisonPanel diffPanel;
    protected boolean disableOnReadOnly;

    public AbstractMatchedTokensAction(String actionName, String owner, DecompilerDiffCodeComparisonPanel diffPanel, boolean disableOnReadOnly) {
        super(actionName, owner);
        this.diffPanel = diffPanel;
        this.disableOnReadOnly = disableOnReadOnly;
    }

    protected abstract boolean enabledForTokens(TokenPair var1);

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DualDecompilerActionContext)) {
            return false;
        }
        DualDecompilerActionContext compareContext = (DualDecompilerActionContext)context;
        CodeComparisonPanel codeComparisonPanel = compareContext.getCodeComparisonPanel();
        if (!(codeComparisonPanel instanceof DecompilerCodeComparisonPanel)) {
            return false;
        }
        DecompilerCodeComparisonPanel decompPanel = (DecompilerCodeComparisonPanel)codeComparisonPanel;
        if (this.disableOnReadOnly) {
            Program program = decompPanel.getLeftProgram();
            if (program == null) {
                return false;
            }
            if (!decompPanel.leftPanelHasFocus()) {
                program = decompPanel.getRightProgram();
            }
            if (!program.canSave()) {
                return false;
            }
        }
        TokenPair currentPair = this.getCurrentTokenPair((DecompilerCodeComparisonPanel<? extends DualDecompilerFieldPanelCoordinator>)decompPanel);
        return this.enabledForTokens(currentPair);
    }

    protected TokenPair getCurrentTokenPair(DecompilerCodeComparisonPanel<? extends DualDecompilerFieldPanelCoordinator> decompPanel) {
        DecompilerPanel focusedPanel = decompPanel.getFocusedDecompilerPanel().getDecompilerPanel();
        ProgramLocation programLocation = focusedPanel.getCurrentLocation();
        if (!(programLocation instanceof DecompilerLocation)) {
            return null;
        }
        DecompilerLocation focusedLocation = (DecompilerLocation)programLocation;
        ClangToken focusedToken = focusedLocation.getToken();
        if (focusedToken == null) {
            return null;
        }
        List<TokenBin> tokenBin = this.diffPanel.getHighBins();
        if (tokenBin == null) {
            return null;
        }
        TokenBin containingBin = TokenBin.getBinContainingToken(tokenBin, focusedToken);
        if (containingBin == null) {
            return null;
        }
        TokenBin matchedBin = containingBin.getMatch();
        if (matchedBin == null) {
            return null;
        }
        for (ClangToken currentMatch : matchedBin) {
            if (!currentMatch.getClass().equals(focusedToken.getClass())) continue;
            return decompPanel.leftPanelHasFocus() ? new TokenPair(focusedToken, currentMatch) : new TokenPair(currentMatch, focusedToken);
        }
        return null;
    }
}

