/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.plugin.core.debug.stack.SavedRegisterMap;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.trace.util.TraceRegisterUtils;
import java.util.Map;

public record UnwindInfo(Function function, Long depth, Long adjust, Address ofReturn, Map<Register, Address> saved, StackUnwindWarningSet warnings, Exception error) {
    public static UnwindInfo errorOnly(Exception error) {
        return new UnwindInfo(null, null, null, null, null, new StackUnwindWarningSet(), error);
    }

    public Address ofReturn(Address base) {
        if (this.ofReturn.isRegisterAddress()) {
            return this.ofReturn;
        }
        if (this.ofReturn.isStackAddress()) {
            return base.add(this.ofReturn.getOffset());
        }
        throw new AssertionError();
    }

    public Address computeBase(Address spVal) {
        return this.depth == null ? null : spVal.subtract(this.depth.longValue());
    }

    public <T> void restoreRegisters(Address base, PcodeExecutorState<T> state) {
        for (Map.Entry<Register, Address> ent : this.saved.entrySet()) {
            Register reg = ent.getKey();
            Address offset = ent.getValue();
            assert (offset.isStackAddress());
            Address address = base.add(offset.getOffset());
            Object value = state.getVar(address, reg.getNumBytes(), true, PcodeExecutorStatePiece.Reason.INSPECT);
            state.setVar(reg, value);
        }
    }

    public void mapSavedRegisters(Address base, SavedRegisterMap map) {
        for (Map.Entry<Register, Address> ent : this.saved.entrySet()) {
            Register reg = ent.getKey();
            Address offset = ent.getValue();
            assert (offset.isStackAddress());
            Address address = base.add(offset.getOffset());
            map.put(TraceRegisterUtils.rangeForRegister((Register)reg), address);
        }
    }

    public <T> T computeNextPc(Address base, PcodeExecutorState<T> state, Register pc) {
        return (T)state.getVar(this.ofReturn(base), pc.getNumBytes(), true, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    public <T> Address computeNextPc(Address base, PcodeExecutorState<T> state, AddressSpace codeSpace, Register pc) {
        T value = this.computeNextPc(base, state, pc);
        long concrete = state.getArithmetic().toLong(value, PcodeArithmetic.Purpose.INSPECT);
        return codeSpace.getAddress(concrete);
    }

    public Address computeNextSp(Address base) {
        return base.add(this.adjust.longValue());
    }

    public int computeParamSize() {
        return this.function.getStackFrame().getParameterSize();
    }
}

