/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.ReusableDialogComponentProvider;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.app.services.DebuggerModelService;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.datastruct.CollectionChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.View;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;

public class DebuggerConnectDialog
extends ReusableDialogComponentProvider
implements PropertyChangeListener {
    private static final String KEY_CURRENT_FACTORY_CLASSNAME = "currentFactoryCls";
    private static final String KEY_SUCCESS_FACTORY_CLASSNAME = "successFactoryCls";
    private static final String HTML_BOLD_DESCRIPTION = "<html><b>Description:</b> ";
    private DebuggerModelService modelService;
    private DebuggerModelFactory currentFactory;
    private DebuggerModelFactory successFactory;
    private final Map<DebuggerModelFactory, FactoryEntry> factories = new HashMap<DebuggerModelFactory, FactoryEntry>();
    private FactoriesChangedListener listener = new FactoriesChangedListener();
    private JComboBox<FactoryEntry> dropdown;
    protected final DefaultComboBoxModel<FactoryEntry> dropdownModel = new DefaultComboBoxModel();
    private final BidiMap<ConfigurableFactory.Property<?>, PropertyEditor> propertyEditors = new DualLinkedHashBidiMap();
    private final Map<ConfigurableFactory.Property<?>, Component> components = new LinkedHashMap();
    protected JLabel description;
    protected JPanel gridPanel;
    protected JButton connectButton;
    protected CompletableFuture<? extends DebuggerObjectModel> futureConnect;
    protected CompletableFuture<DebuggerObjectModel> result;

    public DebuggerConnectDialog() {
        super("Connect", true, true, true, false);
        this.populateComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFactories() {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            this.factories.clear();
            SwingUtilities.invokeLater(() -> this.dropdownModel.removeAllElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFactories() {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            ArrayList<FactoryEntry> toAdd = new ArrayList<FactoryEntry>();
            Set current = this.modelService.getModelFactories();
            for (DebuggerModelFactory element : current) {
                FactoryEntry entry = new FactoryEntry(element);
                this.factories.put(element, entry);
                toAdd.add(entry);
            }
            SwingUtilities.invokeLater(() -> {
                toAdd.sort(Comparator.comparing(FactoryEntry::toString, NameComparator.INSTANCE));
                for (FactoryEntry entry : toAdd) {
                    this.dropdownModel.addElement(entry);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFactory(DebuggerModelFactory element) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            if (this.factories.containsKey(element)) {
                return;
            }
            FactoryEntry entry = new FactoryEntry(element);
            this.factories.put(element, entry);
            SwingUtilities.invokeLater(() -> this.dropdownModel.addElement(entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFactory(DebuggerModelFactory element) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            FactoryEntry entry = this.factories.remove(element);
            if (entry == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> this.dropdownModel.removeElement(entry));
        }
    }

    public void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeFactoriesChangedListener((CollectionChangeListener)this.listener);
            this.clearFactories();
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addFactoriesChangedListener((CollectionChangeListener)this.listener);
            this.loadFactories();
        }
    }

    public void dispose() {
        this.modelService.removeFactoriesChangedListener((CollectionChangeListener)this.listener);
        this.clearFactories();
        super.dispose();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Box topBox = Box.createVerticalBox();
        this.dropdown = new JComboBox<FactoryEntry>(this.dropdownModel);
        topBox.add(this.dropdown);
        JPanel inner = new JPanel(new BorderLayout());
        this.description = new JLabel("<html><b>Description:</b> </html>");
        this.description.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.description.setPreferredSize(new Dimension(400, 150));
        inner.add(this.description);
        topBox.add(inner);
        panel.add((Component)topBox, "North");
        this.gridPanel = new JPanel(new GridBagLayout());
        JPanel centering = new JPanel(new FlowLayout(1));
        JScrollPane scrolling = new JScrollPane(centering, 20, 31);
        scrolling.setPreferredSize(new Dimension(100, 200));
        panel.add((Component)scrolling, "Center");
        centering.add(this.gridPanel);
        this.addWorkPanel(panel);
        this.connectButton = new JButton();
        DebuggerResources.AbstractConnectAction.styleButton(this.connectButton);
        this.addButton(this.connectButton);
        this.addCancelButton();
        this.dropdown.addItemListener(this::itemSelected);
        this.connectButton.addActionListener(this::connect);
    }

    private void itemSelected(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            this.gridPanel.removeAll();
        } else if (evt.getStateChange() == 1) {
            FactoryEntry ent = (FactoryEntry)evt.getItem();
            this.currentFactory = ent.factory;
            this.populateOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(ActionEvent evt) {
        this.connectButton.setEnabled(false);
        for (Map.Entry ent : this.propertyEditors.entrySet()) {
            ConfigurableFactory.Property prop;
            ConfigurableFactory.Property objProp = prop = (ConfigurableFactory.Property)ent.getKey();
            objProp.setValue(((PropertyEditor)ent.getValue()).getValue());
        }
        this.setStatusText("Connecting...");
        DebuggerConnectDialog debuggerConnectDialog = this;
        synchronized (debuggerConnectDialog) {
            this.futureConnect = this.currentFactory.build();
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.futureConnect.thenCompose(m -> m.fetchModelRoot())).thenAcceptAsync(r -> {
            DebuggerObjectModel m = r.getModel();
            this.modelService.addModel(m);
            this.setStatusText("");
            this.close();
            this.modelService.activateModel(m);
            DebuggerConnectDialog debuggerConnectDialog = this;
            synchronized (debuggerConnectDialog) {
                this.result.completeAsync(() -> m);
                this.result = null;
            }
        }, (Executor)SwingExecutorService.LATER)).exceptionally(e -> {
            if (!((e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof CancellationException)) {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Could not connect", (Object)e);
            }
            this.setStatusText("Could not connect: " + e.getMessage(), MessageType.ERROR);
            return null;
        })).whenComplete((v, e) -> {
            DebuggerConnectDialog debuggerConnectDialog = this;
            synchronized (debuggerConnectDialog) {
                this.futureConnect = null;
            }
            this.successFactory = this.currentFactory;
            this.connectButton.setEnabled(true);
        });
    }

    protected void cancelCallback() {
        if (this.futureConnect != null) {
            this.futureConnect.cancel(false);
        }
        if (this.result != null) {
            this.result.cancel(false);
        }
        super.cancelCallback();
    }

    public synchronized void setFactoryByBrief(String brief) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            for (FactoryEntry fe : this.factories.values()) {
                if (!Objects.equals(brief, fe.factory.getBrief())) continue;
                this.dropdownModel.setSelectedItem(fe);
                return;
            }
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized CompletableFuture<DebuggerObjectModel> reset(DebuggerModelFactory factory, Program program) {
        if (factory != null) {
            Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
            synchronized (map) {
                this.dropdownModel.setSelectedItem(this.factories.get(factory));
            }
            this.dropdown.setEnabled(false);
        } else {
            this.selectCompatibleFactory(program);
            this.dropdown.setEnabled(true);
        }
        if (this.result != null) {
            this.result.cancel(false);
        }
        this.result = new CompletableFuture();
        this.setStatusText("");
        this.connectButton.setEnabled(true);
        return this.result;
    }

    protected void syncOptionsEnabled() {
        for (Map.Entry<ConfigurableFactory.Property<?>, Component> ent : this.components.entrySet()) {
            ent.getValue().setEnabled(ent.getKey().isEnabled());
        }
    }

    protected void populateOptions() {
        GridBagConstraints constraints;
        this.description.setText(HTML_BOLD_DESCRIPTION + this.currentFactory.getHtmlDetails());
        this.propertyEditors.clear();
        this.components.clear();
        Map optsMap = this.currentFactory.getOptions();
        this.gridPanel.removeAll();
        if (optsMap.isEmpty()) {
            JLabel label = new JLabel("<html>There are no configuration options for this connector.");
            constraints = new GridBagConstraints();
            this.gridPanel.add((Component)label, constraints);
        }
        int i = 0;
        for (Map.Entry opt : optsMap.entrySet()) {
            ConfigurableFactory.Property property = (ConfigurableFactory.Property)opt.getValue();
            JLabel label = new JLabel("<html>" + HTMLUtilities.escapeHTML((String)((String)opt.getKey()))){

                @Override
                public Dimension getPreferredSize() {
                    View v = (View)this.getClientProperty("html");
                    if (v == null) {
                        return super.getPreferredSize();
                    }
                    v.setSize(200.0f, 0.0f);
                    float height = v.getPreferredSpan(1);
                    return new Dimension(200, (int)height);
                }
            };
            constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.insets = new Insets(i == 0 ? 0 : 5, 0, 0, 5);
            this.gridPanel.add((Component)label, constraints);
            Class type = property.getValueClass();
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                throw new RuntimeException("Could not find editor for " + property.getValueClass());
            }
            editor.setValue(property.getValue());
            editor.addPropertyChangeListener(this);
            Component editorComponent = MiscellaneousUtils.getEditorComponent(editor);
            if (editorComponent instanceof JTextField) {
                JTextField textField = (JTextField)editorComponent;
                textField.setColumns(13);
            }
            constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = i;
            constraints.insets = new Insets(i == 0 ? 0 : 5, 0, 0, 0);
            this.gridPanel.add(editorComponent, constraints);
            this.propertyEditors.put((Object)property, (Object)editor);
            this.components.put(property, editorComponent);
            ++i;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ConfigurableFactory.Property prop;
        PropertyEditor editor = (PropertyEditor)evt.getSource();
        ConfigurableFactory.Property objProp = prop = (ConfigurableFactory.Property)this.propertyEditors.getKey((Object)editor);
        objProp.setValue(editor.getValue());
        this.syncOptionsEnabled();
    }

    public void writeConfigState(SaveState saveState) {
        if (this.currentFactory != null) {
            saveState.putString(KEY_CURRENT_FACTORY_CLASSNAME, this.currentFactory.getClass().getName());
        }
        if (this.successFactory != null) {
            saveState.putString(KEY_SUCCESS_FACTORY_CLASSNAME, this.successFactory.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FactoryEntry getByName(String className) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            for (FactoryEntry ent : this.factories.values()) {
                String name = ent.factory.getClass().getName();
                if (!className.equals(name)) continue;
                return ent;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<PrioritizedFactory> getByPriority(Program program) {
        Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
        synchronized (map) {
            return this.factories.values().stream().map(e -> new PrioritizedFactory((FactoryEntry)e, program)).sorted(Comparator.comparing(pf -> -pf.priority())).toList();
        }
    }

    protected PrioritizedFactory getFirstCompatibleByPriority(Program program) {
        Iterator<PrioritizedFactory> iterator = this.getByPriority(program).iterator();
        if (iterator.hasNext()) {
            PrioritizedFactory pf = iterator.next();
            if (pf.priority >= 0) {
                return pf;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectCompatibleFactory(Program program) {
        if (this.currentFactory != null && this.currentFactory.isCompatible(program)) {
            return;
        }
        if (this.successFactory != null && this.successFactory.isCompatible(program)) {
            this.currentFactory = this.successFactory;
            Map<DebuggerModelFactory, FactoryEntry> map = this.factories;
            synchronized (map) {
                this.dropdown.setSelectedItem(this.factories.get(this.successFactory));
            }
            return;
        }
        PrioritizedFactory compat = this.getFirstCompatibleByPriority(program);
        if (compat == null) {
            return;
        }
        this.currentFactory = compat.entry.factory;
        this.dropdown.setSelectedItem(compat.entry);
    }

    public void readConfigState(SaveState saveState) {
        String currentFactoryName = saveState.getString(KEY_CURRENT_FACTORY_CLASSNAME, null);
        FactoryEntry restoreCurrent = currentFactoryName == null ? null : this.getByName(currentFactoryName);
        this.currentFactory = restoreCurrent == null ? null : restoreCurrent.factory;
        this.dropdown.setSelectedItem(restoreCurrent);
        String successFactoryName = saveState.getString(KEY_SUCCESS_FACTORY_CLASSNAME, null);
        FactoryEntry restoreSuccess = successFactoryName == null ? null : this.getByName(successFactoryName);
        this.successFactory = restoreSuccess == null ? null : restoreSuccess.factory;
    }

    protected class FactoriesChangedListener
    implements CollectionChangeListener<DebuggerModelFactory> {
        protected FactoriesChangedListener() {
        }

        public void elementAdded(DebuggerModelFactory element) {
            DebuggerConnectDialog.this.addFactory(element);
        }

        public void elementModified(DebuggerModelFactory element) {
        }

        public void elementRemoved(DebuggerModelFactory element) {
            DebuggerConnectDialog.this.removeFactory(element);
        }
    }

    protected record FactoryEntry(DebuggerModelFactory factory) {
        @Override
        public String toString() {
            return this.factory.getBrief();
        }
    }

    protected record PrioritizedFactory(FactoryEntry entry, int priority) {
        public PrioritizedFactory(FactoryEntry ent, Program program) {
            this(ent, ent.factory.getPriority(program));
        }
    }

    protected static enum NameComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String o1, String o2) {
            boolean p1 = o1.startsWith("PROTOTYPE:");
            boolean p2 = o2.startsWith("PROTOTYPE:");
            if (p1 && !p2) {
                return 1;
            }
            if (!p1 && p2) {
                return -1;
            }
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    }
}

