/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.dbgeng;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.mapping.AbstractDebuggerPlatformOpinion;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerPlatformMapper;
import ghidra.app.plugin.core.debug.platform.dbgeng.DbgengX64DisassemblyInject;
import ghidra.debug.api.platform.DebuggerPlatformMapper;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.util.Collection;
import java.util.Set;

public class DbgengDebuggerPlatformOpinion
extends AbstractDebuggerPlatformOpinion {
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");
    protected static final Set<DisassemblyInject> INJECTS = Set.of(new DbgengX64DisassemblyInject());

    @Override
    protected Set<DebuggerPlatformOffer> getOffers(TraceObject object, long snap, TraceObject env, String debugger, String arch, String os, Endian endian, boolean includeOverrides) {
        boolean is64Bit;
        if (debugger == null || arch == null || !debugger.toLowerCase().contains("dbg")) {
            return Set.of();
        }
        boolean bl = is64Bit = arch.contains("x86_64") || arch.contains("x64_32");
        if (!is64Bit) {
            return Set.of();
        }
        return Set.of(Offers.X64);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Offers implements DebuggerPlatformOffer
    {
        X64{

            @Override
            public String getDescription() {
                return "Dbgeng on Windows x64";
            }

            @Override
            public int getConfidence() {
                return 100;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return this.getCompilerSpec(LANG_ID_X86_64, COMP_ID_VS);
            }

            @Override
            public DebuggerPlatformMapper take(PluginTool tool, Trace trace) {
                return new DbgengX64DebuggerPlatformMapper(tool, trace, this.getCompilerSpec());
            }

            @Override
            public boolean isCreatorOf(DebuggerPlatformMapper mapper) {
                return mapper.getClass() == DbgengX64DebuggerPlatformMapper.class;
            }
        };

    }

    protected static class DbgengX64DebuggerPlatformMapper
    extends DefaultDebuggerPlatformMapper {
        public DbgengX64DebuggerPlatformMapper(PluginTool tool, Trace trace, CompilerSpec cSpec) {
            super(tool, trace, cSpec);
        }

        @Override
        protected Collection<DisassemblyInject> getDisassemblyInjections(TraceObject object) {
            return INJECTS;
        }
    }
}

