/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import db.Transaction;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.DateUtils;
import java.util.Date;

public class SnapshotRow {
    private final Trace trace;
    private final TraceSnapshot snapshot;

    public SnapshotRow(Trace trace, TraceSnapshot snapshot) {
        this.trace = snapshot.getTrace();
        this.snapshot = snapshot;
    }

    public TraceSnapshot getSnapshot() {
        return this.snapshot;
    }

    public long getSnap() {
        return this.snapshot.getKey();
    }

    public String getTimeStamp() {
        return DateUtils.formatDateTimestamp((Date)new Date(this.snapshot.getRealTime()));
    }

    public String getEventThreadName() {
        TraceThread thread = this.snapshot.getEventThread();
        return thread == null ? "" : thread.getName();
    }

    public String getSchedule() {
        return this.snapshot.getScheduleString();
    }

    public String getDescription() {
        return this.snapshot.getDescription();
    }

    public void setDescription(String description) {
        try (Transaction tx = this.trace.openTransaction("Modify snapshot description");){
            this.snapshot.setDescription(description);
        }
    }
}

