/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.pcode;

import db.Transaction;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GColor;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.pcode.BranchPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.DebuggerPcodeStepperPlugin;
import ghidra.app.plugin.core.debug.gui.pcode.EnumPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.FallthroughPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.OpPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.PcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.UniqueRow;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.pcode.Appender;
import ghidra.async.SwingExecutorService;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.debug.api.emulation.DebuggerPcodeMachine;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.ColorUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.WebColors;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerPcodeStepperProvider
extends ComponentProviderAdapter {
    private static final FontRenderContext METRIC_FRC = new FontRenderContext(new AffineTransform(), false, false);
    private static final Color COLOR_BACKGROUND = new GColor("color.bg.listing");
    private static final Color COLOR_BACKGROUND_CURSOR = new GColor("color.bg.currentline.listing");
    private static final Color COLOR_BACKGROUND_COUNTER = new GColor("color.debugger.plugin.resources.pcode.counter");
    private static final Color COLOR_FOREGROUND_ADDRESS = new GColor("color.fg.listing.address");
    private static final Color COLOR_FOREGROUND_REGISTER = new GColor("color.fg.listing.register");
    private static final Color COLOR_FOREGROUND_SCALAR = new GColor("color.fg.listing.constant");
    private static final Color COLOR_FOREGROUND_LOCAL = new GColor("color.fg.listing.label.local");
    private static final Color COLOR_FOREGROUND_MNEMONIC = new GColor("color.fg.listing.mnemonic");
    private static final Color COLOR_FOREGROUND_UNIMPL = new GColor("color.fg.listing.mnemonic.unimplemented");
    private static final Color COLOR_FOREGROUND_SEPARATOR = new GColor("color.fg.listing.separator");
    private static final Color COLOR_FOREGROUND_LINE_LABEL = new GColor("color.fg.listing.pcode.label");
    private static final Color COLOR_FOREGROUND_SPACE = new GColor("color.fg.listing.pcode.address.space");
    private static final Color COLOR_FOREGROUND_RAW = new GColor("color.fg.listing.pcode.varnode");
    private static final Color COLOR_FOREGROUND_USEROP = new GColor("color.fg.listing.pcode.userop");
    protected static final Comparator<Varnode> UNIQUE_COMPARATOR = (u1, u2) -> {
        assert (u1.isUnique() && u2.isUnique());
        return u1.getAddress().compareTo((Object)u2.getAddress());
    };
    private final DebuggerPcodeStepperPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationService;
    private AutoService.Wiring autoServiceWiring;
    JSplitPane mainPanel = new JSplitPane(1);
    final UniqueTableModel uniqueTableModel;
    GhidraTable uniqueTable;
    GhidraTableFilterPanel<UniqueRow> uniqueFilterPanel;
    final PcodeTableModel pcodeTableModel;
    GhidraTable pcodeTable;
    JLabel instructionLabel;
    PcodeCellRenderer codeColRenderer;
    DockingAction actionStepBackward;
    DockingAction actionStepForward;

    protected static String htmlColor(Color color, String display) {
        return String.format("<font color=\"%s\">%s</font>", WebColors.toString((Color)color, (boolean)false), HTMLUtilities.escapeHTML((String)display));
    }

    protected static String createColoredStyle(String cls, Color color) {
        if (color == null) {
            return "";
        }
        return " ." + cls + " { color:" + HTMLUtilities.toHexString((Color)color) + "; }";
    }

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getThread(), b.getThread());
    }

    public DebuggerPcodeStepperProvider(DebuggerPcodeStepperPlugin plugin) {
        super(plugin.getTool(), "Pcode Stepper", plugin.getName(), null);
        this.plugin = plugin;
        this.uniqueTableModel = new UniqueTableModel(this.tool);
        this.pcodeTableModel = new PcodeTableModel(this.tool);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_PCODE);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_PCODE);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.createActions();
        this.setVisible(true);
        this.contextChanged();
    }

    protected int measureColWidth(JLabel renderer, String sample) {
        Font font = renderer.getFont();
        Insets insets = renderer.getBorder().getBorderInsets(renderer);
        return (int)font.getStringBounds(sample, METRIC_FRC).getWidth() + insets.left + insets.right;
    }

    protected int measureWidthHtml(JLabel renderer, String sampleHtml) {
        String sampleText = HTMLUtilities.fromHTML((String)sampleHtml);
        return this.measureColWidth(renderer, sampleText);
    }

    protected void buildMainPanel() {
        JPanel pcodeTablePanel = new JPanel(new BorderLayout());
        this.pcodeTable = new GhidraTable((TableModel)((Object)this.pcodeTableModel));
        pcodeTablePanel.add((Component)this.pcodeTable, "Center");
        this.pcodeTable.setBackground(COLOR_BACKGROUND);
        this.pcodeTable.setSelectionBackground(COLOR_BACKGROUND_CURSOR);
        JScrollPane pcodeScrollPane = new JScrollPane(pcodeTablePanel, 20, 30);
        JPanel pcodePanel = new JPanel(new BorderLayout());
        pcodePanel.add((Component)pcodeScrollPane, "Center");
        this.instructionLabel = new JLabel();
        pcodePanel.add((Component)this.instructionLabel, "North");
        this.mainPanel.setLeftComponent(pcodePanel);
        JPanel uniquePanel = new JPanel(new BorderLayout());
        this.uniqueTable = new GhidraTable((TableModel)((Object)this.uniqueTableModel));
        uniquePanel.add(new JScrollPane((Component)this.uniqueTable));
        this.uniqueFilterPanel = new GhidraTableFilterPanel((JTable)this.uniqueTable, (RowObjectTableModel)this.uniqueTableModel);
        uniquePanel.add((Component)this.uniqueFilterPanel, "South");
        this.mainPanel.setRightComponent(uniquePanel);
        this.pcodeTable.setTableHeader(null);
        this.pcodeTable.setBackground(COLOR_BACKGROUND);
        this.pcodeTable.setSelectionBackground(COLOR_BACKGROUND_CURSOR);
        this.pcodeTable.setSelectionMode(0);
        this.pcodeTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.uniqueTableModel.fireTableDataChanged();
        });
        TableColumnModel pcodeColModel = this.pcodeTable.getColumnModel();
        TableColumn seqCol = pcodeColModel.getColumn(PcodeTableColumns.SEQUENCE.ordinal());
        CounterBackgroundCellRenderer seqColRenderer = new CounterBackgroundCellRenderer();
        seqCol.setCellRenderer((TableCellRenderer)((Object)seqColRenderer));
        int seqColWidth = this.measureColWidth((JLabel)((Object)seqColRenderer), "00");
        seqCol.setMinWidth(seqColWidth);
        seqCol.setMaxWidth(seqColWidth);
        TableColumn labelCol = pcodeColModel.getColumn(PcodeTableColumns.LABEL.ordinal());
        this.codeColRenderer = new PcodeCellRenderer();
        labelCol.setCellRenderer((TableCellRenderer)((Object)this.codeColRenderer));
        int labelColWidth = this.measureColWidth((JLabel)((Object)this.codeColRenderer), "<00>");
        labelCol.setMinWidth(labelColWidth);
        labelCol.setMaxWidth(labelColWidth);
        TableColumn codeCol = pcodeColModel.getColumn(PcodeTableColumns.CODE.ordinal());
        codeCol.setCellRenderer((TableCellRenderer)((Object)this.codeColRenderer));
        TableColumnModel uniqueColModel = this.uniqueTable.getColumnModel();
        TableColumn refCol = uniqueColModel.getColumn(UniqueTableColumns.REF.ordinal());
        refCol.setCellRenderer((TableCellRenderer)((Object)new UniqueRefCellRenderer()));
        refCol.setMinWidth(24);
        refCol.setMaxWidth(24);
        TableColumn uniqCol = uniqueColModel.getColumn(UniqueTableColumns.UNIQUE.ordinal());
        uniqCol.setPreferredWidth(45);
        TableColumn bytesCol = uniqueColModel.getColumn(UniqueTableColumns.BYTES.ordinal());
        bytesCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        bytesCol.setPreferredWidth(65);
        TableColumn valCol = uniqueColModel.getColumn(UniqueTableColumns.VALUE.ordinal());
        valCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_BIG_HEX);
        valCol.setPreferredWidth(45);
        TableColumn typeCol = uniqueColModel.getColumn(UniqueTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new UniqueDataTypeEditor()));
        typeCol.setPreferredWidth(45);
        TableColumn reprCol = uniqueColModel.getColumn(UniqueTableColumns.REPR.ordinal());
        reprCol.setPreferredWidth(45);
    }

    protected void createActions() {
        this.actionStepBackward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulatePcodeBackwardAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null && this.current.getTime().pTickCount() != 0L)).onAction(c -> this.stepBackwardActivated())).buildAndInstallLocal((ComponentProvider)this);
        this.actionStepForward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulatePcodeForwardAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.stepForwardActivated())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void stepBackwardActivated() {
        if (this.current.getTrace() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedPcodeBackward(1);
        if (time == null) {
            return;
        }
        this.traceManager.activateTime(time);
    }

    private void stepForwardActivated() {
        if (this.current.getThread() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedPcodeForward(this.current.getThread(), 1);
        this.traceManager.activateTime(time);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerPcodeStepperProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.previous = this.current;
        this.current = coordinates;
        this.doLoadPcodeFrame();
        this.setSubTitle(this.current.getTime().toString());
        this.contextChanged();
    }

    protected void populateSingleton(PcodeRow row) {
        this.pcodeTableModel.add(row);
    }

    protected <T> void populateFromFrame(PcodeFrame frame, PcodeExecutorState<T> state, PcodeArithmetic<T> arithmetic) {
        this.populatePcode(frame);
        this.populateUnique(frame, state, arithmetic);
    }

    protected int computeCodeColWidth(List<PcodeRow> rows) {
        return rows.stream().map(r -> this.measureWidthHtml((JLabel)((Object)this.codeColRenderer), r.getCode())).reduce(0, Integer::max);
    }

    protected void adjustCodeColWidth(List<PcodeRow> rows) {
        TableColumn codeCol = this.pcodeTable.getColumnModel().getColumn(PcodeTableColumns.CODE.ordinal());
        int width = this.computeCodeColWidth(rows);
        codeCol.setMinWidth(width);
        codeCol.setPreferredWidth(width);
    }

    protected void populatePcode(PcodeFrame frame) {
        Language language = this.current.getPlatform().getLanguage();
        PcodeRowHtmlFormatter formatter = new PcodeRowHtmlFormatter(language, frame);
        List<PcodeRow> toAdd = formatter.getRows();
        int sel = formatter.nextRowIndex;
        if (frame.isBranch()) {
            sel = frame.getCode().size() + 1;
            toAdd.add(new BranchPcodeRow(sel, frame.getBranched()));
        } else if (frame.isFallThrough()) {
            sel = frame.getCode().size();
        }
        this.adjustCodeColWidth(toAdd);
        this.pcodeTableModel.addAll(toAdd);
        this.pcodeTable.getSelectionModel().setSelectionInterval(sel, sel);
        this.pcodeTable.scrollToSelectedRow();
    }

    protected <T> void populateUnique(PcodeFrame frame, PcodeExecutorState<T> state, PcodeArithmetic<T> arithmetic) {
        Language language = this.current.getPlatform().getLanguage();
        TreeSet<Varnode> uniques = new TreeSet<Varnode>(UNIQUE_COMPARATOR);
        for (PcodeOp op : frame.getCode()) {
            Varnode out = op.getOutput();
            if (out != null && out.isUnique()) {
                uniques.add(out);
            }
            for (Varnode in : op.getInputs()) {
                if (!in.isUnique()) continue;
                uniques.add(in);
            }
        }
        List toAdd = uniques.stream().map(u -> new UniqueRow(this, language, state, arithmetic, (Varnode)u)).collect(Collectors.toList());
        this.uniqueTableModel.addAll(toAdd);
    }

    protected void clear() {
        this.pcodeTableModel.clear();
        this.uniqueTableModel.clear();
    }

    protected void doLoadPcodeFrame() {
        if (this.instructionLabel != null) {
            this.instructionLabel.setText("(no instruction)");
        }
        if (this.emulationService == null) {
            this.clear();
            return;
        }
        DebuggerCoordinates current = this.current;
        Trace trace = current.getTrace();
        if (trace == null) {
            this.clear();
            return;
        }
        if (current.getThread() == null) {
            this.clear();
            this.populateSingleton(EnumPcodeRow.NO_THREAD);
            return;
        }
        TraceSchedule time = current.getTime();
        if (time.pTickCount() == 0L) {
            this.clear();
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        DebuggerPcodeMachine emu = this.emulationService.getCachedEmulator(trace, time);
        if (emu != null) {
            this.clear();
            this.doLoadPcodeFrameFromEmulator(emu);
            return;
        }
        this.emulationService.backgroundEmulate(current.getPlatform(), time).thenAcceptAsync(__ -> {
            this.clear();
            if (current != this.current) {
                return;
            }
            this.doLoadPcodeFrameFromEmulator(this.emulationService.getCachedEmulator(trace, time));
        }, (Executor)SwingExecutorService.LATER);
    }

    protected <T> void doLoadPcodeFrameFromEmulator(DebuggerPcodeMachine<T> emu) {
        PcodeThread thread = emu.getThread(this.current.getThread().getPath(), false);
        if (thread == null) {
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        Instruction instruction = thread.getInstruction();
        if (instruction == null) {
            this.instructionLabel.setText("(no instruction)");
        } else {
            this.instructionLabel.setText(instruction.toString());
        }
        PcodeFrame frame = thread.getFrame();
        if (frame == null) {
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        this.populateFromFrame(frame, (PcodeExecutorState<T>)thread.getState(), (PcodeArithmetic<T>)thread.getArithmetic());
    }

    @AutoServiceConsumed
    private void setEmulationService(DebuggerEmulationService emulationService) {
        this.doLoadPcodeFrame();
    }

    protected static class UniqueTableModel
    extends DefaultEnumeratedColumnTableModel<UniqueTableColumns, UniqueRow> {
        public UniqueTableModel(PluginTool tool) {
            super(tool, "Unique", UniqueTableColumns.class);
        }

        public List<UniqueTableColumns> defaultSortOrder() {
            return List.of(UniqueTableColumns.UNIQUE);
        }
    }

    protected static class PcodeTableModel
    extends DefaultEnumeratedColumnTableModel<PcodeTableColumns, PcodeRow> {
        public PcodeTableModel(PluginTool tool) {
            super(tool, "p-code", PcodeTableColumns.class);
        }

        public List<PcodeTableColumns> defaultSortOrder() {
            return List.of(PcodeTableColumns.SEQUENCE);
        }
    }

    protected static enum PcodeTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<PcodeTableColumns, PcodeRow>
    {
        SEQUENCE("Sequence", Integer.class, PcodeRow::getSequence),
        LABEL("Label", String.class, PcodeRow::getLabel),
        CODE("Code", String.class, PcodeRow::getCode);

        private final String header;
        private final Function<PcodeRow, ?> getter;
        private final Class<?> cls;

        private <T> PcodeTableColumns(String header, Class<T> cls, Function<PcodeRow, T> getter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(PcodeRow row) {
            return this.getter.apply(row);
        }

        public boolean isSortable() {
            return this == SEQUENCE;
        }
    }

    class CounterBackgroundCellRenderer
    extends AbstractGColumnRenderer<String> {
        Color foregroundColor = this.getForeground();

        CounterBackgroundCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            this.setForeground(DebuggerPcodeStepperProvider.this.pcodeTable.getForeground());
            PcodeRow row = (PcodeRow)data.getRowObject();
            if (data.isSelected()) {
                Color blend;
                if (row.isNext() && (blend = ColorUtils.blend((Color)COLOR_BACKGROUND_COUNTER, (Color)COLOR_BACKGROUND_CURSOR, (double)0.5)) != null) {
                    this.setBackground(blend);
                }
            } else if (row.isNext()) {
                this.setBackground(COLOR_BACKGROUND_COUNTER);
            } else {
                this.setBackground(DebuggerPcodeStepperProvider.this.pcodeTable.getBackground());
                this.setOpaque(true);
            }
            this.setBorder(this.noFocusBorder);
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    class PcodeCellRenderer
    extends CounterBackgroundCellRenderer {
        PcodeCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        protected void configureFont(JTable table, TableModel model, int column) {
            this.setFont(this.fixedWidthFont);
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            String text = this.getText(value);
            this.setText(text);
            return this;
        }
    }

    protected static enum UniqueTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<UniqueTableColumns, UniqueRow>
    {
        REF("Ref", UniqueRow.RefType.class, UniqueRow::getRefType),
        UNIQUE("Unique", String.class, UniqueRow::getName),
        BYTES("Bytes", String.class, UniqueRow::getBytes),
        VALUE("Value", BigInteger.class, UniqueRow::getValue),
        TYPE("Type", DataType.class, UniqueRow::getDataType, UniqueRow::setDataType),
        REPR("Repr", String.class, UniqueRow::getValueRepresentation);

        private final String header;
        private final Function<UniqueRow, ?> getter;
        private final BiConsumer<UniqueRow, Object> setter;
        private final Class<?> cls;

        private <T> UniqueTableColumns(String header, Class<T> cls, Function<UniqueRow, T> getter, BiConsumer<UniqueRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> UniqueTableColumns(String header, Class<T> cls, Function<UniqueRow, T> getter) {
            this(header, cls, getter, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(UniqueRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public void setValueOf(UniqueRow row, Object value) {
            this.setter.accept(row, value);
        }

        public boolean isEditable(UniqueRow row) {
            return this.setter != null;
        }
    }

    class UniqueRefCellRenderer
    extends AbstractGColumnRenderer<UniqueRow.RefType> {
        UniqueRefCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            this.setText("");
            switch ((UniqueRow.RefType)((Object)data.getValue())) {
                case NONE: {
                    this.setIcon(null);
                    break;
                }
                case READ: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_READ);
                    break;
                }
                case WRITE: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_WRITE);
                    break;
                }
                case READ_WRITE: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_RW);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this;
        }

        public String getFilterString(UniqueRow.RefType t, Settings settings) {
            return t.name();
        }
    }

    class UniqueDataTypeEditor
    extends DataTypeTableCellEditor {
        public UniqueDataTypeEditor() {
            super(DebuggerPcodeStepperProvider.this.plugin.getTool());
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            try (Transaction tid = DebuggerPcodeStepperProvider.this.current.getTrace().openTransaction("Resolve DataType");){
                DataType dataType2 = DebuggerPcodeStepperProvider.this.current.getTrace().getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    class PcodeRowHtmlFormatter
    extends AbstractPcodeFormatter<List<PcodeRow>, ToPcodeRowsAppender> {
        private final Language language;
        private final PcodeFrame frame;
        private int index;
        private int nextRowIndex;

        public PcodeRowHtmlFormatter(Language language, PcodeFrame frame) {
            this.language = language;
            this.frame = frame;
        }

        List<PcodeRow> getRows() {
            return (List)this.formatOps(this.language, this.frame.getCode());
        }

        protected ToPcodeRowsAppender createAppender(Language lang, boolean indent) {
            return new ToPcodeRowsAppender(lang, this.frame);
        }

        public AbstractPcodeFormatter.FormatResult formatOpTemplate(ToPcodeRowsAppender appender, OpTpl template) {
            if (PcodeRowHtmlFormatter.isLineLabel((OpTpl)template)) {
                appender.startRow(null, false);
            } else {
                boolean isNext;
                PcodeOp op = (PcodeOp)this.frame.getCode().get(this.index++);
                boolean bl = isNext = op.getSeqnum().getTime() == this.frame.index();
                if (isNext) {
                    this.nextRowIndex = appender.rows.size();
                }
                appender.startRow(op, isNext);
            }
            AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate((Appender)appender, template);
            appender.endRow();
            return result;
        }
    }

    class ToPcodeRowsAppender
    extends AbstractAppender<List<PcodeRow>> {
        private final List<PcodeRow> rows;
        private final PcodeFrame frame;
        private boolean hasLabel;
        private StringBuilder labelHtml;
        private StringBuilder codeHtml;
        private PcodeOp op;
        private boolean isNext;

        public ToPcodeRowsAppender(Language language, PcodeFrame frame) {
            super(language, false);
            this.rows = new ArrayList<PcodeRow>();
            this.frame = frame;
        }

        void startRow(PcodeOp op, boolean isNext) {
            if (!this.hasLabel || this.op != null) {
                this.labelHtml = new StringBuilder("<html>");
                this.hasLabel = false;
                this.codeHtml = new StringBuilder("<html>");
            }
            this.op = op;
            this.isNext = isNext;
        }

        void endRow() {
            if (!this.hasLabel || this.op != null) {
                this.labelHtml.append("</html>");
                this.codeHtml.append("</html>");
                this.rows.add(new OpPcodeRow(this.language, this.op, this.isNext, this.labelHtml.toString(), this.codeHtml.toString()));
                this.hasLabel = false;
                this.op = null;
            }
        }

        public void appendAddressWordOffcut(long wordOffset, long offcut) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_ADDRESS, this.stringifyWordOffcut(wordOffset, offcut)));
        }

        public void appendCharacter(char c) {
            if (c == '=') {
                this.codeHtml.append("&nbsp;");
                this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_SEPARATOR, "="));
                this.codeHtml.append("&nbsp;");
            } else if (c == ' ') {
                this.codeHtml.append("&nbsp;");
            } else {
                this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_SEPARATOR, Character.toString(c)));
            }
        }

        public void appendIndent() {
        }

        public void appendLabel(String label) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_LOCAL, label));
        }

        public void appendLineLabel(long label) {
            this.hasLabel = true;
            this.labelHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_LINE_LABEL, this.stringifyLineLabel(label)));
        }

        public void appendLineLabelRef(long label) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_LINE_LABEL, this.stringifyLineLabel(label)));
        }

        public void appendMnemonic(int opcode) {
            Color style = opcode == 0 ? COLOR_FOREGROUND_UNIMPL : COLOR_FOREGROUND_MNEMONIC;
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(style, this.stringifyOpMnemonic(opcode)));
        }

        public void appendRawVarnode(AddressSpace space, long offset, long size) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_RAW, this.stringifyRawVarnode(space, offset, size)));
        }

        public void appendRegister(Register register) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_REGISTER, this.stringifyRegister(register)));
        }

        public void appendScalar(long value) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_SCALAR, this.stringifyScalarValue(value)));
        }

        public void appendSpace(AddressSpace space) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_SPACE, this.stringifySpace(space)));
        }

        public void appendUnique(long offset) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_LOCAL, this.stringifyUnique(offset)));
        }

        public void appendUserop(int id) {
            this.codeHtml.append(DebuggerPcodeStepperProvider.htmlColor(COLOR_FOREGROUND_USEROP, this.stringifyUserop(this.language, id)));
        }

        protected String stringifyUseropUnchecked(Language lang, int id) {
            String name = super.stringifyUseropUnchecked(lang, id);
            if (name != null) {
                return name;
            }
            return this.frame.getUseropName(id);
        }

        public List<PcodeRow> finish() {
            String label;
            if (this.hasLabel) {
                this.labelHtml.append("</html>");
                label = this.labelHtml.toString();
            } else {
                label = "";
            }
            this.rows.add(new FallthroughPcodeRow(this.frame.getCode().size(), this.frame.isFallThrough(), label));
            return this.rows;
        }
    }
}

