/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.ComponentProvider;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.EnumeratedColumnTableModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectAttributeRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectElementRow;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectPane;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTableCellRenderer;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;

public class ObjectTable<R>
implements ObjectPane {
    public static final Icon ICON_TABLE = new GIcon("icon.debugger.table.object");
    private final ObjectContainer container;
    private final Class<R> clazz;
    private final AbstractSortedTableModel<R> model;
    private final GhidraTable table;
    private final JScrollPane component;

    public ObjectTable(ObjectContainer container, Class<R> clazz, AbstractSortedTableModel<R> model) {
        this.table = new GhidraTable(model);
        this.component = new JScrollPane((Component)this.table);
        this.container = container;
        this.clazz = clazz;
        this.model = model;
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            DebuggerObjectsProvider provider = container.getProvider();
            provider.getTool().contextChanged((ComponentProvider)provider);
        });
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ObjectTableCellRenderer(container.getProvider())));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ObjectTableCellRenderer(container.getProvider())));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ObjectTable.this.activateOrNavigateSelectedObject();
                }
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ObjectTable.this.activateOrNavigateSelectedObject();
                    e.consume();
                }
            }
        });
        container.subscribe();
        this.signalUpdate(container);
    }

    private void activateOrNavigateSelectedObject() {
        TargetObject object;
        int selectedRow = this.table.getSelectedRow();
        int selectedColumn = this.table.getSelectedColumn();
        Object value = this.table.getValueAt(selectedRow, selectedColumn);
        if (this.container.getProvider().navigateToSelectedObject(this.container.getTargetObject(), value) != null) {
            return;
        }
        Object row = this.model.getModelData().get(selectedRow);
        if (row instanceof ObjectElementRow) {
            ObjectElementRow eRow = (ObjectElementRow)row;
            object = eRow.getTargetObject();
        } else if (row instanceof ObjectAttributeRow) {
            ObjectAttributeRow aRow = (ObjectAttributeRow)row;
            object = aRow.getTargetObject();
        } else {
            return;
        }
        if (object instanceof DummyTargetObject) {
            return;
        }
        DebugModelConventions.requestActivation((TargetObject)object).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not activate " + object), (Throwable)ex);
            return null;
        });
    }

    @Override
    public ObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public TargetObject getTargetObject() {
        return this.container.getTargetObject();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public JComponent getPrincipalComponent() {
        return this.table;
    }

    @Override
    public String getName() {
        TargetObject targetObject = this.getTargetObject();
        return targetObject == null ? "Main" : targetObject.getName();
    }

    @Override
    public void signalDataChanged(ObjectContainer oc) {
        Swing.runIfSwingOrRunLater(() -> this.update(oc));
    }

    @Override
    public void signalContentsChanged(ObjectContainer oc) {
        Swing.runIfSwingOrRunLater(() -> this.update(oc));
    }

    @Override
    public void signalUpdate(ObjectContainer oc) {
        Swing.runIfSwingOrRunLater(() -> this.update(oc));
    }

    @Override
    public List<? extends Object> update(ObjectContainer changed) {
        ObjectElementRow match;
        if (changed.equals(this.container) && (this.clazz.equals(ObjectElementRow.class) && changed.hasElements() || this.clazz.equals(ObjectAttributeRow.class) && !changed.hasElements())) {
            return this.generateRows(changed);
        }
        if (this.clazz.equals(ObjectElementRow.class) && !changed.hasElements() && (match = this.findMatch(changed)) != null) {
            return this.updateMatch(match);
        }
        return new ArrayList();
    }

    private List<R> generateRows(ObjectContainer changed) {
        ArrayList<R> list = new ArrayList<R>();
        for (ObjectContainer child : changed.getCurrentChildren()) {
            if (!child.isVisible() && this.getContainer().getProvider().isHideIntrinsics()) continue;
            TargetObject to = child.getTargetObject();
            try {
                R r = this.clazz.getDeclaredConstructor(TargetObject.class, DebuggerObjectsProvider.class).newInstance(to, this.container.getProvider());
                list.add(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.model instanceof EnumeratedColumnTableModel) {
            EnumeratedColumnTableModel m = (EnumeratedColumnTableModel)this.model;
            m.clear();
            m.addAll(list);
        }
        for (ObjectContainer child : changed.getCurrentChildren()) {
            if (!child.isVisible()) continue;
            this.update(child);
        }
        this.model.fireTableStructureChanged();
        return list;
    }

    private ObjectElementRow findMatch(ObjectContainer changed) {
        TargetObject changedTarget = changed.getTargetObject();
        ObjectElementRow match = null;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            ObjectElementRow row;
            Object r = this.model.getRowObject(i);
            if (!(r instanceof ObjectElementRow) || !(row = (ObjectElementRow)r).getTargetObject().equals((Object)changedTarget)) continue;
            row.setAttributes(changed.getAttributeMap());
            match = row;
            break;
        }
        return match;
    }

    private List<R> updateMatch(ObjectElementRow match) {
        ObjectEnumeratedColumnTableModel m = (ObjectEnumeratedColumnTableModel)this.model;
        m.updateColumns(match);
        m.fireTableDataChanged();
        ArrayList<ObjectElementRow> list = new ArrayList<ObjectElementRow>();
        if (match != null) {
            list.add(match);
            this.model.setLastSelectedObjects(list);
            this.model.fireTableStructureChanged();
        }
        return list;
    }

    public void setColumns() {
        ObjectEnumeratedColumnTableModel m = (ObjectEnumeratedColumnTableModel)this.model;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object r = this.model.getRowObject(i);
            if (!(r instanceof ObjectElementRow)) continue;
            ObjectElementRow row = (ObjectElementRow)r;
            m.updateColumns(row);
            break;
        }
        m.fireTableStructureChanged();
    }

    @Override
    public TargetObject getSelectedObject() {
        int selectedColumn = this.table.getSelectedColumn();
        Object r = this.model.getRowObject(this.table.getSelectedRow());
        if (r instanceof ObjectAttributeRow) {
            ObjectAttributeRow row = (ObjectAttributeRow)r;
            return row.getTargetObject();
        }
        if (r instanceof ObjectElementRow) {
            ObjectElementRow row = (ObjectElementRow)r;
            TargetObject targetObject = row.getTargetObject();
            if (selectedColumn > 0) {
                List<String> keys = row.getKeys();
                if (selectedColumn >= keys.size()) {
                    selectedColumn = 0;
                }
                String key = keys.get(selectedColumn);
                Map attributes = targetObject.getCachedAttributes();
                Object object = attributes.get(key);
                if (object instanceof TargetObject) {
                    TargetObject to = (TargetObject)object;
                    return to;
                }
            }
            return targetObject;
        }
        return null;
    }

    @Override
    public void setSelectedObject(TargetObject selection) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object row;
            Object r = this.model.getRowObject(i);
            if (r instanceof ObjectAttributeRow && ((ObjectAttributeRow)(row = (ObjectAttributeRow)r)).getTargetObject().equals((Object)selection)) {
                this.table.selectRow(i);
                break;
            }
            if (!(r instanceof ObjectElementRow) || !((ObjectElementRow)(row = (ObjectElementRow)r)).getTargetObject().equals((Object)selection)) continue;
            this.table.selectRow(i);
            break;
        }
    }

    @Override
    public void setFocus(TargetObject object, TargetObject focused) {
        Swing.runIfSwingOrRunLater(() -> this.table.repaint());
    }

    @Override
    public void setRoot(ObjectContainer container, TargetObject targetObject) {
        container.setTargetObject(targetObject);
    }
}

