/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.framework.Application;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;

public abstract class ImportExportAsAction
extends DockingAction {
    protected PluginTool tool;
    protected DebuggerObjectsProvider provider;
    protected String fileExt;
    protected GhidraFileChooserMode fileMode;
    protected String IMPORT = "Import...";
    protected String GROUP = "ImportExport";

    public ImportExportAsAction(String name, PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super(name, owner);
        this.tool = tool;
        this.provider = provider;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object obj = context.getContextObject();
        ObjectContainer sel = this.provider.getSelectedContainer(obj);
        return sel != null;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.provider.getSelectedContainer(contextObject);
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.provider.getComponent());
        chooser.setFileFilter(new GhidraFileFilter(){

            public String getDescription() {
                return "*" + ImportExportAsAction.this.fileExt;
            }

            public boolean accept(File file, GhidraFileChooserModel chooserModel) {
                if (file.getName().endsWith(ImportExportAsAction.this.fileExt)) {
                    return true;
                }
                return file.isDirectory();
            }
        });
        chooser.setFileSelectionMode(this.fileMode);
        chooser.setCurrentDirectory(Application.getUserSettingsDirectory());
        File f = chooser.getSelectedFile();
        chooser.dispose();
        if (chooser.wasCancelled() || f == null) {
            return;
        }
        this.doAction(container, f);
    }

    protected abstract void doAction(ObjectContainer var1, File var2);
}

