/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.DisplayFilteredAction;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Element;

public class DisplayFilteredXMLAction
extends DisplayFilteredAction {
    protected ConsoleService consoleService;
    protected static final Icon ICON_XML = new GIcon("icon.debugger.display.xml.filtered");

    public DisplayFilteredXMLAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("DisplayFilteredXML", tool, owner, provider);
        String[] path = new String[]{"Display filtered...", "XML"};
        this.setPopupMenuData(new MenuData(path, ICON_XML));
        this.setKeyBindingData(new KeyBindingData(69, 192));
        this.setHelpLocation(new HelpLocation(owner, "display_filtered_xml"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container, List<String> path) {
        this.consoleService = this.provider.getConsoleService();
        if (this.consoleService == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"DisplayFilteredGraph Error", (Object)"ConsoleService not found: Please add a console service provider to your tool");
            return;
        }
        ObjectContainer clone = ObjectContainer.clone(container);
        clone.setImmutable(true);
        this.getOffspring(clone, path);
    }

    @Override
    protected void finishGetOffspring(ObjectContainer container, List<String> path) {
        this.writeXml(container, path);
    }

    public void writeXml(ObjectContainer container, List<String> path) {
        Element root = container.toXml();
        String joinedPath = StringUtils.join(path, (String)".");
        XmlUtilities.setStringAttr((Element)root, (String)"Path", (String)joinedPath);
        this.consoleService.println(XmlUtilities.toString((Element)root));
    }
}

