/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.script.AskDialog;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.plugintool.PluginTool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;

public abstract class DisplayFilteredAction
extends DockingAction {
    protected PluginTool tool;
    protected DebuggerObjectsProvider provider;
    protected boolean isTree = false;
    private String lastCmd;

    public DisplayFilteredAction(String name, PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super(name, owner);
        this.tool = tool;
        this.provider = provider;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object obj = context.getContextObject();
        ObjectContainer sel = this.provider.getSelectedContainer(obj);
        return sel != null;
    }

    public void actionPerformed(ActionContext context) {
        Object contextObject = context.getContextObject();
        ObjectContainer container = this.provider.getSelectedContainer(contextObject);
        if (container != null) {
            AskDialog dialog = new AskDialog("Filter", "Filter", 0, (Object)this.lastCmd);
            if (dialog.isCanceled()) {
                return;
            }
            this.lastCmd = dialog.getValueAsString();
            ArrayList<String> path = new ArrayList<String>();
            path.addAll(container.getTargetObject().getPath());
            path.add(this.lastCmd);
            this.doAction(container, path);
        }
    }

    protected abstract void doAction(ObjectContainer var1, List<String> var2);

    protected CompletableFuture<Void> getOffspring(ObjectContainer container, List<String> path) {
        TargetObject to = container.getTargetObject();
        DebuggerObjectModel model = to.getModel();
        model.fetchModelObject(path, DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).thenAccept(obj -> {
            container.setTargetObject((TargetObject)obj);
            this.finishGetOffspring(container, path);
        });
        return CompletableFuture.completedFuture(null);
    }

    protected void finishGetOffspring(final ObjectContainer container, List<String> path) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DebuggerObjectsProvider p = new DebuggerObjectsProvider(DisplayFilteredAction.this.provider.getPlugin(), DisplayFilteredAction.this.provider.getModel(), container, DisplayFilteredAction.this.isTree);
                    container.propagateProvider(p);
                    p.update(container);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

