/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModuleActionContext;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionActionContext;
import ghidra.app.plugin.core.debug.gui.modules.ModuleRow;
import ghidra.app.plugin.core.debug.gui.modules.SectionRow;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerLegacyModulesPanel
extends JPanel {
    private final DebuggerModulesProvider provider;
    Trace currentTrace;
    private final ModulesListener modulesListener = new ModulesListener();
    protected final ModuleTableModel moduleTableModel;
    protected final GhidraTable moduleTable;
    final GhidraTableFilterPanel<ModuleRow> moduleFilterPanel;
    private DebuggerModuleActionContext myActionContext;

    protected static Set<TraceModule> getSelectedModulesFromContext(DebuggerModuleActionContext context) {
        return context.getSelectedModules().stream().map(r -> r.getModule()).collect(Collectors.toSet());
    }

    protected static Set<TraceSection> getSelectedSectionsFromContext(DebuggerModuleActionContext context) {
        return context.getSelectedModules().stream().flatMap(r -> r.getModule().getSections().stream()).collect(Collectors.toSet());
    }

    protected static AddressSetView getSelectedAddressesFromContext(DebuggerModuleActionContext context) {
        AddressSet sel = new AddressSet();
        for (TraceModule module : DebuggerLegacyModulesPanel.getSelectedModulesFromContext(context)) {
            sel.add(module.getRange());
        }
        return sel;
    }

    protected static ModuleRow getSelectedModuleRowFromContext(DebuggerModuleActionContext context) {
        Set<ModuleRow> modules = context.getSelectedModules();
        if (modules.size() != 1) {
            return null;
        }
        return modules.iterator().next();
    }

    protected static SectionRow getSelectedSectionRowFromContext(DebuggerSectionActionContext context) {
        Set<SectionRow> sections = context.getSelectedSections();
        if (sections.size() != 1) {
            return null;
        }
        return sections.iterator().next();
    }

    public DebuggerLegacyModulesPanel(DebuggerModulesProvider provider) {
        super(new BorderLayout());
        this.provider = provider;
        this.moduleTableModel = new ModuleTableModel(provider.getTool(), provider);
        this.moduleTable = new GhidraTable((TableModel)((Object)this.moduleTableModel));
        this.moduleTable.setSelectionMode(2);
        this.add(new JScrollPane((Component)this.moduleTable));
        this.moduleFilterPanel = new GhidraTableFilterPanel((JTable)this.moduleTable, (RowObjectTableModel)this.moduleTableModel);
        this.add((Component)this.moduleFilterPanel, "South");
        this.moduleTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.myActionContext = new DebuggerModuleActionContext(provider, this.moduleFilterPanel.getSelectedItems(), (GTable)this.moduleTable);
            provider.legacyModulesPanelContextChanged();
        });
        this.moduleTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerLegacyModulesPanel.this.navigateToSelectedModule();
                }
            }
        });
        this.moduleTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerLegacyModulesPanel.this.navigateToSelectedModule();
                    e.consume();
                }
            }
        });
        TableColumnModel colModel = this.moduleTable.getColumnModel();
        TableColumn baseCol = colModel.getColumn(ModuleTableColumns.BASE.ordinal());
        baseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn maxCol = colModel.getColumn(ModuleTableColumns.MAX.ordinal());
        maxCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = colModel.getColumn(ModuleTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    protected void contextChanged() {
        this.provider.contextChanged();
    }

    protected void navigateToSelectedModule() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.provider.listingService != null && (value = this.moduleTable.getValueAt(selectedRow = this.moduleTable.getSelectedRow(), selectedColumn = this.moduleTable.getSelectedColumn())) instanceof Address) {
            this.provider.listingService.goTo((Address)value, true);
        }
    }

    public DebuggerModuleActionContext getActionContext() {
        return this.myActionContext;
    }

    private void loadModules() {
        this.moduleTable.getSelectionModel().clearSelection();
        this.moduleTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceModuleManager moduleManager = this.currentTrace.getModuleManager();
        this.moduleTableModel.addAllItems(moduleManager.getAllModules());
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadModules();
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.setTrace(coordinates.getTrace());
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.modulesListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.modulesListener);
    }

    public void setSelectedModules(Set<TraceModule> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((ModuleTableModel)this.moduleTableModel).getRow(arg_0), (GTable)this.moduleTable, this.moduleTableModel, this.moduleFilterPanel);
    }

    private class ModulesListener
    extends TraceDomainObjectListener {
        public ModulesListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.ADDED, this::moduleAdded);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.LIFESPAN_CHANGED, this::moduleChanged);
            this.listenFor((TraceChangeType)Trace.TraceModuleChangeType.DELETED, this::moduleDeleted);
        }

        private void objectRestored() {
            DebuggerLegacyModulesPanel.this.loadModules();
        }

        private void moduleAdded(TraceModule module) {
            DebuggerLegacyModulesPanel.this.moduleTableModel.addItem(module);
        }

        private void moduleChanged(TraceModule module) {
            DebuggerLegacyModulesPanel.this.moduleTableModel.updateItem(module);
        }

        private void moduleDeleted(TraceModule module) {
            DebuggerLegacyModulesPanel.this.moduleTableModel.deleteItem(module);
        }
    }

    protected static class ModuleTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<ModuleTableColumns, ObjectKey, ModuleRow, TraceModule> {
        public ModuleTableModel(PluginTool tool, DebuggerModulesProvider provider) {
            super(tool, "Modules", ModuleTableColumns.class, TraceUniqueObject::getObjectKey, mod -> new ModuleRow(provider, (TraceModule)mod), ModuleRow::getModule);
        }

        public List<ModuleTableColumns> defaultSortOrder() {
            return List.of(ModuleTableColumns.BASE);
        }
    }

    protected static enum ModuleTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ModuleTableColumns, ModuleRow>
    {
        BASE("Base Address", Address.class, ModuleRow::getBase),
        MAX("Max Address", Address.class, ModuleRow::getMaxAddress),
        SHORT_NAME("Name", String.class, ModuleRow::getShortName),
        NAME("Module Name", String.class, ModuleRow::getName, ModuleRow::setName),
        MAPPING("Mapping", String.class, ModuleRow::getMapping),
        LIFESPAN("Lifespan", Lifespan.class, ModuleRow::getLifespan),
        LENGTH("Length", Long.class, ModuleRow::getLength);

        private final String header;
        private final Function<ModuleRow, ?> getter;
        private final BiConsumer<ModuleRow, Object> setter;
        private final Class<?> cls;

        private <T> ModuleTableColumns(String header, Class<T> cls, Function<ModuleRow, T> getter, BiConsumer<ModuleRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> ModuleTableColumns(String header, Class<T> cls, Function<ModuleRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(ModuleRow row) {
            return this.setter != null;
        }

        public void setValueOf(ModuleRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(ModuleRow row) {
            return this.getter.apply(row);
        }
    }
}

