/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model.columns;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;

public class TracePathLastLifespanColumn
extends AbstractDynamicTableColumn<PathTableModel.PathRow, Lifespan, Trace> {
    private final LastLifespanRenderer renderer = new LastLifespanRenderer();

    public String getColumnName() {
        return "Life";
    }

    public GColumnRenderer<Lifespan> getColumnRenderer() {
        return this.renderer;
    }

    public Lifespan getValue(PathTableModel.PathRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
        TraceObjectValue lastEntry = rowObject.getPath().getLastEntry();
        if (lastEntry == null) {
            return Lifespan.ALL;
        }
        return lastEntry.getLifespan();
    }

    private final class LastLifespanRenderer
    extends AbstractGColumnRenderer<Lifespan> {
        private LastLifespanRenderer() {
        }

        public String getFilterString(Lifespan t, Settings settings) {
            return t == null ? "<null>" : t.toString();
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            PathTableModel.PathRow row = (PathTableModel.PathRow)data.getRowObject();
            if (row.isCurrent()) {
                this.setBold();
            }
            return this;
        }
    }
}

