/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.interpreters;

import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.gui.interpreters.AbstractDebuggerWrappedConsoleConnection;
import ghidra.app.plugin.core.debug.gui.interpreters.DebuggerInterpreterProvider;
import ghidra.app.plugin.core.debug.gui.interpreters.DebuggerWrappedConsoleConnection;
import ghidra.app.plugin.core.debug.gui.interpreters.DebuggerWrappedInterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.plugin.core.interpreter.InterpreterPanelPlugin;
import ghidra.app.plugin.core.interpreter.InterpreterPanelService;
import ghidra.app.services.DebuggerInterpreterService;
import ghidra.dbg.target.TargetConsole;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetObject;
import ghidra.debug.api.interpreter.DebuggerInterpreterConnection;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

@PluginInfo(shortDescription="Debugger interpreter panel service", description="Manage interpreter panels within debug sessions", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, servicesRequired={InterpreterPanelService.class}, servicesProvided={DebuggerInterpreterService.class})
public class DebuggerInterpreterPlugin
extends AbstractDebuggerPlugin
implements DebuggerInterpreterService {
    @AutoServiceConsumed
    protected InterpreterPanelService consoleService;
    protected final Map<TargetObject, DebuggerInterpreterConnection> connections = new HashMap<TargetObject, DebuggerInterpreterConnection>();

    public DebuggerInterpreterPlugin(PluginTool tool) {
        super(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerInterpreterConnection showConsole(TargetConsole targetConsole) {
        DebuggerInterpreterConnection conn;
        Map<TargetObject, DebuggerInterpreterConnection> map = this.connections;
        synchronized (map) {
            conn = this.connections.computeIfAbsent((TargetObject)targetConsole, c -> this.createConnection(targetConsole));
        }
        conn.getInterpreterConsole().show();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerInterpreterConnection showConsole(TargetInterpreter targetInterpreter) {
        DebuggerInterpreterConnection conn;
        Map<TargetObject, DebuggerInterpreterConnection> map = this.connections;
        synchronized (map) {
            conn = this.connections.computeIfAbsent((TargetObject)targetInterpreter, c -> this.createConnection(targetInterpreter));
        }
        conn.getInterpreterConsole().show();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableConsole(TargetObject targetConsole, InterpreterConsole guiConsole) {
        DebuggerInterpreterConnection old;
        Map<TargetObject, DebuggerInterpreterConnection> map = this.connections;
        synchronized (map) {
            old = this.connections.remove(targetConsole);
        }
        assert (old.getInterpreterConsole() == guiConsole);
        SwingUtilities.invokeLater(() -> {
            if (guiConsole.isInputPermitted()) {
                guiConsole.setInputPermitted(false);
                guiConsole.setTransient();
                guiConsole.setPrompt(">>INVALID<<");
            }
        });
    }

    protected void createConsole(AbstractDebuggerWrappedConsoleConnection<?> connection) {
        DebuggerInterpreterProvider console = new DebuggerInterpreterProvider((InterpreterPanelPlugin)this.consoleService, (InterpreterConnection)connection, true);
        connection.setConsole((InterpreterConsole)console);
        connection.runInBackground();
    }

    protected DebuggerInterpreterConnection createConnection(TargetConsole targetConsole) {
        DebuggerWrappedConsoleConnection conn = new DebuggerWrappedConsoleConnection(this, targetConsole);
        this.createConsole(conn);
        return conn;
    }

    protected DebuggerInterpreterConnection createConnection(TargetInterpreter targetInterpreter) {
        DebuggerWrappedInterpreterConnection conn = new DebuggerWrappedInterpreterConnection(this, targetInterpreter);
        this.createConsole(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConsole(TargetObject targetConsole, InterpreterConsole guiConsole) {
        DebuggerInterpreterConnection old;
        Map<TargetObject, DebuggerInterpreterConnection> map = this.connections;
        synchronized (map) {
            old = this.connections.remove(targetConsole);
        }
        assert (old.getInterpreterConsole() == guiConsole);
        SwingUtilities.invokeLater(() -> guiConsole.dispose());
    }
}

