/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.PopupActionProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.task.Task;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(shortDescription="Debugger model method actions", description="Adds context actions to the GUI, generically, based on the model's methods", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={}, servicesRequired={DebuggerStaticMappingService.class})
public class DebuggerMethodActionsPlugin
extends Plugin
implements PopupActionProvider {
    public static final String GROUP_METHODS = "Debugger Methods";
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private DebuggerControlService controlService;
    private final AutoService.Wiring autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);

    public DebuggerMethodActionsPlugin(PluginTool tool) {
        super(tool);
        tool.addPopupActionProvider((PopupActionProvider)this);
    }

    protected boolean isControlTarget() {
        if (this.controlService == null || this.traceManager == null) {
            return true;
        }
        Trace trace = this.traceManager.getCurrentTrace();
        if (trace == null) {
            return true;
        }
        ControlMode mode = this.controlService.getCurrentMode(trace);
        return mode.isTarget();
    }

    protected boolean isAppropriate(ActionContext context) {
        if (context instanceof ProgramLocationActionContext) {
            return true;
        }
        return context instanceof DebuggerObjectActionContext;
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        if (!this.isControlTarget() || !this.isAppropriate(context)) {
            return List.of();
        }
        Target target = this.getTarget(context);
        if (target == null) {
            return List.of();
        }
        ArrayList<DockingActionIf> result = new ArrayList<DockingActionIf>();
        for (Target.ActionEntry entry : target.collectActions(null, context).values()) {
            if (entry.requiresPrompt() || entry.builtIn()) continue;
            result.add((DockingActionIf)new InvokeActionEntryAction(entry));
        }
        return result;
    }

    private Target getTarget(ActionContext context) {
        ProgramActionContext ctx;
        Program program;
        if (this.traceManager == null) {
            return null;
        }
        if (context instanceof ProgramActionContext && (program = (ctx = (ProgramActionContext)context).getProgram()) instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)program;
            DebuggerCoordinates coords = this.traceManager.getCurrentFor(view.getTrace());
            return coords == null ? null : coords.getTarget();
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        return current == null ? null : current.getTarget();
    }

    class InvokeActionEntryAction
    extends DockingAction {
        private final Target.ActionEntry entry;

        public InvokeActionEntryAction(Target.ActionEntry entry) {
            super(entry.display(), DebuggerMethodActionsPlugin.this.getName());
            this.entry = entry;
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, DebuggerMethodActionsPlugin.GROUP_METHODS));
        }

        public void actionPerformed(ActionContext context) {
            DebuggerMethodActionsPlugin.this.tool.execute((Task)new TargetActionTask(this.entry.display(), this.entry));
        }
    }
}

