/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.LValInternal;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class IndexExpr
extends Expr
implements LValInternal {
    private final RValInternal base;
    private final RValInternal index;
    private final int elemLen;

    private IndexExpr(StructuredSleigh ctx, StructuredSleigh.RVal base, StructuredSleigh.RVal index, int elemLen, DataType type) {
        super(ctx, type);
        this.base = (RValInternal)base;
        this.index = (RValInternal)index;
        this.elemLen = elemLen;
    }

    protected IndexExpr(StructuredSleigh ctx, StructuredSleigh.RVal base, StructuredSleigh.RVal index) {
        this(ctx, base, index, ctx.computeElementLength(base), base.getType());
    }

    @Override
    public StructuredSleigh.LVal cast(DataType type) {
        return new IndexExpr(this.ctx, this.base, this.index, this.elemLen, type);
    }

    public String toString() {
        return "<Index " + this.base + " 0x" + Long.toString(this.elemLen, 16) + "*" + this.index + ">";
    }

    @Override
    public StringTree generate(RValInternal parent) {
        StringTree st = new StringTree();
        st.append("(");
        st.append(this.base.generate(this));
        st.append(" + (");
        st.append(this.index.generate(this));
        st.append("*");
        st.append(Integer.toString(this.elemLen));
        st.append("))");
        return st;
    }
}

