/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.security.SSHKeyManager;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.InvalidKeyException;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class HeadlessClientAuthenticator
implements ClientAuthenticator {
    private static final char[] BADPASSWORD = "".toCharArray();
    private static Object sshPrivateKey;
    private static String userID;
    private static boolean passwordPromptAllowed;
    private Authenticator authenticator = new Authenticator(){

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            URL requestingURL;
            Msg.debug((Object)this, (Object)("PasswordAuthentication requested for " + this.getRequestingURL()));
            String usage = null;
            Object prompt = this.getRequestingPrompt();
            if ("security".equals(prompt)) {
                prompt = null;
            }
            if ((requestingURL = this.getRequestingURL()) != null) {
                URL minimalURL = null;
                try {
                    minimalURL = new URL(requestingURL, "/");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                usage = "Access password requested for " + (minimalURL != null ? minimalURL.toExternalForm() : requestingURL.getAuthority());
                prompt = "Password:";
            }
            if (prompt == null) {
                String host = this.getRequestingHost();
                prompt = (String)(host != null ? host + " " : "") + "(" + userID + ") Password:";
            }
            return new PasswordAuthentication(userID, HeadlessClientAuthenticator.this.getPassword(usage, (String)prompt));
        }
    };

    HeadlessClientAuthenticator() {
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public static void installHeadlessClientAuthenticator(String username, String keystorePath, boolean allowPasswordPrompt) throws IOException {
        passwordPromptAllowed = allowPasswordPrompt;
        if (username != null) {
            userID = username;
        }
        sshPrivateKey = null;
        HeadlessClientAuthenticator authenticator = new HeadlessClientAuthenticator();
        ClientUtil.setClientAuthenticator(authenticator);
        if (keystorePath != null) {
            File keyfile = new File(keystorePath);
            if (!keyfile.exists()) {
                try (InputStream keyIn = HeadlessClientAuthenticator.class.getResourceAsStream(keystorePath);){
                    if (keyIn != null) {
                        try {
                            sshPrivateKey = SSHKeyManager.getSSHPrivateKey(keyIn);
                            Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded SSH key: " + keystorePath));
                            return;
                        }
                        catch (Exception e) {
                            Msg.error(HeadlessClientAuthenticator.class, (Object)("Failed to open keystore for SSH use: " + keystorePath), (Throwable)e);
                            throw new IOException("Failed to parse keystore: " + keystorePath);
                        }
                    }
                }
                Msg.error(HeadlessClientAuthenticator.class, (Object)("Keystore not found: " + keystorePath));
                throw new FileNotFoundException("Keystore not found: " + keystorePath);
            }
            boolean success = false;
            try {
                sshPrivateKey = SSHKeyManager.getSSHPrivateKey(keyfile);
                success = true;
                Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded SSH key: " + keystorePath));
            }
            catch (InvalidKeyException e) {
                if (ApplicationKeyManagerFactory.setKeyStore((String)keystorePath, (boolean)false)) {
                    success = true;
                    Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded PKI keystore: " + keystorePath));
                }
            }
            catch (IOException e) {
                Msg.error(HeadlessClientAuthenticator.class, (Object)("Failed to open keystore for SSH use: " + keystorePath), (Throwable)e);
            }
            if (!success) {
                throw new IOException("Failed to parse keystore: " + keystorePath);
            }
        } else {
            sshPrivateKey = null;
        }
    }

    private char[] getPassword(String usage, String prompt) {
        if (!passwordPromptAllowed) {
            Msg.warn((Object)this, (Object)"Headless client not configured to supply required password");
            return BADPASSWORD;
        }
        char[] password = null;
        try {
            Console cons;
            Object passwordPrompt = "";
            if (usage != null) {
                passwordPrompt = (String)passwordPrompt + usage;
                passwordPrompt = (String)passwordPrompt + "\n";
            }
            if (prompt == null) {
                prompt = "Password:";
            }
            if ((cons = System.console()) != null) {
                passwordPrompt = (String)passwordPrompt + prompt + " ";
                password = cons.readPassword((String)passwordPrompt, new Object[0]);
            } else {
                int c;
                passwordPrompt = (String)passwordPrompt + "*** WARNING! Password entry will NOT be masked ***\n" + prompt;
                System.out.print((String)passwordPrompt);
                while (!((c = System.in.read()) <= 0 || Character.isWhitespace((char)c) && c != 32)) {
                    if (password == null) {
                        password = new char[1];
                    } else {
                        char[] newPass = new char[password.length + 1];
                        for (int i = 0; i < password.length; ++i) {
                            newPass[i] = password[i];
                            password[i] = '\u0000';
                        }
                        password = newPass;
                    }
                    password[password.length - 1] = (char)c;
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading standard-input for password", (Throwable)e);
        }
        return password;
    }

    @Override
    public char[] getNewPassword(Component parent, String serverInfo, String username) {
        throw new UnsupportedOperationException("Server password change not permitted");
    }

    @Override
    public boolean processPasswordCallbacks(String title, String serverType, String serverName, NameCallback nameCb, PasswordCallback passCb, ChoiceCallback choiceCb, AnonymousCallback anonymousCb, String loginError) {
        if (anonymousCb != null && !passwordPromptAllowed) {
            anonymousCb.setAnonymousAccessRequested(true);
            return true;
        }
        if (choiceCb != null) {
            choiceCb.setSelectedIndex(1);
        }
        if (nameCb != null && userID != null) {
            nameCb.setName(userID);
        }
        String usage = null;
        if (serverName != null) {
            usage = serverType + ": " + serverName;
        }
        char[] password = this.getPassword(usage, passCb.getPrompt());
        passCb.setPassword(password);
        return password != null;
    }

    @Override
    public boolean promptForReconnect(Component parent, String message) {
        return false;
    }

    public char[] getKeyStorePassword(String keystorePath, boolean passwordError) {
        if (passwordError) {
            if (passwordPromptAllowed) {
                Msg.error((Object)this, (Object)("Incorrect keystore password specified: " + keystorePath));
            } else {
                Msg.error((Object)this, (Object)("Keystore password required but password entry has been disabled: " + keystorePath));
            }
            return null;
        }
        return this.getPassword("Certificate keystore: " + keystorePath, "Keystore password: ");
    }

    @Override
    public boolean processSSHSignatureCallbacks(String serverName, NameCallback nameCb, SSHSignatureCallback sshCb) {
        if (sshPrivateKey == null) {
            return false;
        }
        if (nameCb != null) {
            nameCb.setName(userID);
        }
        try {
            sshCb.sign(sshPrivateKey);
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Failed to authenticate with SSH private key", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isSSHKeyAvailable() {
        return sshPrivateKey != null;
    }

    static {
        userID = ClientUtil.getUserName();
    }
}

