/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.DefaultClientAuthenticator;
import ghidra.framework.client.HeadlessClientAuthenticator;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryNotFoundException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.client.ServerConnectTask;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.RemoteRepositoryServerHandle;
import ghidra.framework.remote.RepositoryServerHandle;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.SignatureCallback;
import ghidra.framework.remote.security.SSHKeyManager;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.net.SignedToken;
import ghidra.security.KeyStorePasswordProvider;
import ghidra.util.HashUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UserAccessException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.net.Authenticator;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Hashtable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class ClientUtil {
    private static ClientAuthenticator clientAuthenticator;
    private static Hashtable<ServerInfo, RepositoryServerAdapter> serverHandles;

    private ClientUtil() {
    }

    public static synchronized void setClientAuthenticator(ClientAuthenticator authenticator) {
        clientAuthenticator = authenticator;
        Authenticator.setDefault(authenticator.getAuthenticator());
        SSHKeyManager.setProtectedKeyStorePasswordProvider(clientAuthenticator);
        ApplicationKeyManagerFactory.setKeyStorePasswordProvider((KeyStorePasswordProvider)clientAuthenticator);
    }

    public static ClientAuthenticator getClientAuthenticator() {
        if (clientAuthenticator == null) {
            if (SystemUtilities.isInHeadlessMode()) {
                ClientUtil.setClientAuthenticator(new HeadlessClientAuthenticator());
            } else {
                ClientUtil.setClientAuthenticator(new DefaultClientAuthenticator());
            }
        }
        return clientAuthenticator;
    }

    public static RepositoryServerAdapter getRepositoryServer(String host, int port) {
        return ClientUtil.getRepositoryServer(host, port, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryServerAdapter getRepositoryServer(String host, int port, boolean forceConnect) {
        RepositoryServerAdapter rsa;
        ClientUtil.getClientAuthenticator();
        if (port <= 0) {
            port = 13100;
        }
        ServerInfo server = new ServerInfo(host, port);
        Hashtable<ServerInfo, RepositoryServerAdapter> hashtable = serverHandles;
        synchronized (hashtable) {
            rsa = serverHandles.get(server);
            if (rsa == null) {
                rsa = new RepositoryServerAdapter(server);
                serverHandles.put(server, rsa);
                forceConnect = true;
            }
            if (forceConnect) {
                try {
                    rsa.connect();
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
            }
        }
        return rsa;
    }

    public static boolean isConnected(String host, int port) {
        ServerInfo server;
        RepositoryServerAdapter rsa;
        if (port <= 0) {
            port = 13100;
        }
        return (rsa = serverHandles.get(server = new ServerInfo(host, port))) != null && rsa.isConnected();
    }

    public static void clearRepositoryAdapter(String host, int port) {
        ServerInfo server;
        RepositoryServerAdapter serverAdapter;
        if (port == 0) {
            port = 13100;
        }
        if ((serverAdapter = serverHandles.remove(server = new ServerInfo(host, port))) != null) {
            serverAdapter.disconnect();
        }
    }

    public static String getUserName() {
        return SystemUtilities.getUserName();
    }

    public static void handleException(RepositoryAdapter repository, Exception exc, String operation, boolean mustRetry, Component parent) {
        String title = "Error During " + operation;
        if (exc instanceof ConnectException || exc instanceof NotConnectedException) {
            Msg.debug(ClientUtil.class, (Object)("Server not connected (" + operation + ")"));
            ClientUtil.promptForReconnect(repository, operation, mustRetry, parent);
        } else if (exc instanceof RepositoryNotFoundException) {
            Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)exc.getMessage());
        } else if (exc instanceof UserAccessException) {
            Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)("Access denied: " + repository + "\n" + exc.getMessage()));
        } else if (exc instanceof ServerException || exc instanceof ServerError) {
            Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)"Exception occurred on the Ghidra Server.", (Throwable)exc.getCause());
        } else if (exc instanceof RemoteException) {
            Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)"Exception occurred communicating with Ghidra Server.", (Throwable)exc.getCause());
        } else {
            String excMsg = exc.getMessage();
            if (excMsg == null) {
                excMsg = exc.toString();
            }
            if (exc instanceof IOException) {
                Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)excMsg, (Throwable)exc);
            } else {
                Msg.showError(ClientUtil.class, (Component)parent, (String)title, (Object)excMsg, (Throwable)exc);
            }
        }
    }

    public static void handleException(RepositoryAdapter repository, Exception exc, String operation, Component parent) {
        ClientUtil.handleException(repository, exc, operation, true, parent);
    }

    public static void promptForReconnect(RepositoryAdapter repository, Component parent) {
        ClientUtil.promptForReconnect(repository, null, false, parent);
    }

    private static void promptForReconnect(RepositoryAdapter rep, String operation, boolean mustRetry, Component parent) {
        ClientUtil.getClientAuthenticator();
        if (clientAuthenticator == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (mustRetry) {
            sb.append("The " + operation + " may have failed due to a lost connection with the Ghidra Server.\n");
            sb.append("You may have to retry the operation after you have reconnected to the server.");
        } else {
            sb.append("The connection to the Ghidra Server has been lost.");
        }
        sb.append("\n \nWould you like to reconnect?");
        if (rep != null && clientAuthenticator.promptForReconnect(parent, sb.toString())) {
            try {
                rep.connect();
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (IOException e) {
                ClientUtil.handleException(rep, e, "Server Reconnect", null);
            }
        }
    }

    public static void checkGhidraServer(String host, int port, TaskMonitor monitor) throws IOException, CancelledException {
        ServerConnectTask.getGhidraServerHandle(new ServerInfo(host, port), monitor);
    }

    static RemoteRepositoryServerHandle connect(ServerInfo server) throws LoginException, GeneralSecurityException, IOException, CancelledException {
        ClientUtil.getClientAuthenticator();
        boolean allowLoginRetry = clientAuthenticator instanceof DefaultClientAuthenticator;
        RemoteRepositoryServerHandle hdl = null;
        ServerConnectTask connectTask = new ServerConnectTask(server, allowLoginRetry);
        if (SystemUtilities.isInHeadlessMode()) {
            connectTask.run(TaskMonitor.DUMMY);
        } else {
            TaskLauncher.launch((Task)connectTask);
            if (connectTask.isCancelled()) {
                throw new CancelledException();
            }
        }
        hdl = connectTask.getRepositoryServerHandle();
        if (hdl == null) {
            Exception e = connectTask.getException();
            if (e == null) {
                return null;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            if (e instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new AssertException((Throwable)e);
        }
        return hdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changePassword(Component parent, RepositoryServerHandle handle, String serverInfo) throws IOException {
        ClientUtil.getClientAuthenticator();
        if (clientAuthenticator == null) {
            return;
        }
        char[] pwd = null;
        try {
            pwd = clientAuthenticator.getNewPassword(parent, serverInfo, handle.getUser());
            if (pwd != null) {
                handle.setPassword(HashUtilities.getSaltedHash(HashUtilities.SHA256_ALGORITHM, pwd));
                Msg.showInfo(ClientUtil.class, (Component)parent, (String)"Password Changed", (Object)"Password was changed successfully");
            }
        }
        finally {
            if (pwd != null) {
                Arrays.fill(pwd, ' ');
            }
        }
    }

    static boolean processPasswordCallbacks(Callback[] callbacks, String serverName, String defaultUserID, String loginError) throws IOException {
        ClientUtil.getClientAuthenticator();
        if (clientAuthenticator == null) {
            Msg.error(ClientUtil.class, (Object)"Unable to authenticate user without ClientAuthenticator");
            return false;
        }
        NameCallback nameCb = null;
        PasswordCallback passCb = null;
        ChoiceCallback choiceCb = null;
        AnonymousCallback anonymousCb = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                nameCb = (NameCallback)callback;
                nameCb.setName(defaultUserID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                passCb = (PasswordCallback)callback;
                continue;
            }
            if (callback instanceof ChoiceCallback) {
                choiceCb = (ChoiceCallback)callback;
                continue;
            }
            if (!(callback instanceof AnonymousCallback)) continue;
            anonymousCb = (AnonymousCallback)callback;
        }
        if (passCb == null) {
            throw new IOException("Unsupported authentication callback: " + callbacks[0].getClass().getName());
        }
        if (!clientAuthenticator.processPasswordCallbacks("Repository Server Authentication", "Repository Server", serverName, nameCb, passCb, choiceCb, anonymousCb, loginError)) {
            return false;
        }
        String name = defaultUserID;
        if (nameCb != null && (name = nameCb.getName()) == null) {
            name = nameCb.getDefaultName();
        }
        Msg.info(ClientUtil.class, (Object)("Password authenticating to " + serverName + " as user '" + name + "'"));
        return true;
    }

    static void processSignatureCallback(String serverName, SignatureCallback sigCb) throws IOException {
        try {
            SignedToken signedToken = ApplicationKeyManagerUtils.getSignedToken((Principal[])sigCb.getRecognizedAuthorities(), (byte[])sigCb.getToken());
            sigCb.sign(signedToken.certChain, signedToken.signature);
            Msg.info(ClientUtil.class, (Object)("PKI Authenticating to " + serverName + " as user '" + signedToken.certChain[0].getSubjectX500Principal() + "'"));
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new IOException(msg, e);
        }
    }

    static boolean processSSHSignatureCallback(Callback[] callbacks, String serverName, String defaultUserID) {
        NameCallback nameCb = null;
        SSHSignatureCallback sshCb = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                nameCb = (NameCallback)callback;
                nameCb.setName(defaultUserID);
                continue;
            }
            if (!(callback instanceof SSHSignatureCallback)) continue;
            sshCb = (SSHSignatureCallback)callback;
        }
        if (sshCb == null || !clientAuthenticator.isSSHKeyAvailable()) {
            return false;
        }
        if (!clientAuthenticator.processSSHSignatureCallbacks(serverName, nameCb, sshCb)) {
            return false;
        }
        Msg.info(ClientUtil.class, (Object)("SSH Authenticating to " + serverName + " as user '" + defaultUserID + "'"));
        return true;
    }

    public static boolean isSSHKeyAvailable() {
        return clientAuthenticator.isSSHKeyAvailable();
    }

    static {
        serverHandles = new Hashtable();
    }
}

