/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.RISCV_ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class RISCV_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 243;
    }

    public RISCV_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new RISCV_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    static int getHi20(int target) {
        int target_h = target & 0xFFFFF000;
        if ((target & 0x800) == 2048) {
            target_h += 4096;
        }
        return target_h;
    }

    static int getLo12(int target) {
        return target & 0xFFF;
    }

    private static int getSymbolValueIndirect(ElfRelocationContext elfRelocationContext, ElfSymbol hi20Symbol, long relocAddrOffsetAdj) {
        RISCV_ElfRelocationContext relocContext = (RISCV_ElfRelocationContext)elfRelocationContext;
        ElfRelocation hi20Reloc = relocContext.getHi20Relocation(hi20Symbol);
        if (hi20Reloc == null) {
            return 0;
        }
        int symIndex = hi20Reloc.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symIndex);
        long symOffset = elfRelocationContext.getSymbolValue(sym);
        long targetOffset = symOffset + hi20Reloc.getAddend();
        long hi20RelocOffset = hi20Reloc.getOffset() + relocAddrOffsetAdj;
        return (int)(targetOffset - hi20RelocOffset);
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (!this.canRelocate(elf)) {
            return RelocationResult.FAILURE;
        }
        if (!relocation.hasAddend()) {
            return RelocationResult.UNSUPPORTED;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean is32 = elf.is32Bit();
        int type = relocation.getType();
        if (0 == type) {
            return RelocationResult.SKIPPED;
        }
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        long base = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        long value64 = 0L;
        int value32 = 0;
        short value16 = 0;
        byte value8 = 0;
        int target = 0;
        int byteLength = 4;
        switch (type) {
            case 1: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value32);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is32Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 2: {
                value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                RISCV_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                RISCV_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 3: {
                if (is32) {
                    value32 = (int)(base + addend);
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = base + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 4: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_COPY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 5: {
                if (is32) {
                    value32 = (int)symbolValue;
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = symbolValue;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case 6: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPMOD32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 7: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPMOD64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 8: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPREL32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 9: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_DTPREL64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 10: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_TPREL32", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 11: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_TPREL64", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 16: {
                target = (int)(addend + symbolValue - offset);
                value32 = RISCV_ElfRelocationHandler.encodeSBTypeImm(target) | memory.getInt(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeSBTypeImm(-1);
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 17: {
                target = (int)(addend + symbolValue - offset);
                value32 = RISCV_ElfRelocationHandler.encodeUJTypeImm(target) | memory.getInt(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeUJTypeImm(-1);
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 18: 
            case 19: {
                target = (int)(addend + symbolValue - offset);
                memory.setInt(relocationAddress, RISCV_ElfRelocationHandler.getHi20(target) | memory.getInt(relocationAddress) & 0xFFF);
                memory.setInt(relocationAddress.add(4L), RISCV_ElfRelocationHandler.getLo12(target) << 20 | memory.getInt(relocationAddress.add(4L)) & 0xFFFFF);
                byteLength = 8;
                break;
            }
            case 21: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_GOT_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 22: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TLS_GD_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 20: 
            case 23: {
                target = (int)(addend + symbolValue - offset);
                memory.setInt(relocationAddress, RISCV_ElfRelocationHandler.getHi20(target) | memory.getInt(relocationAddress) & 0xFFF);
                break;
            }
            case 24: {
                target = RISCV_ElfRelocationHandler.getSymbolValueIndirect(elfRelocationContext, sym, relocationAddress.getOffset() - relocation.getOffset());
                if (target == 0) {
                    RISCV_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"Failed to locate HI20 relocation for R_RISCV_PCREL_LO12_I", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value32 = (target & 0xFFF) << 20 | memory.getInt(relocationAddress) & 0xFFFFF;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 25: {
                target = RISCV_ElfRelocationHandler.getSymbolValueIndirect(elfRelocationContext, sym, relocationAddress.getOffset() - relocation.getOffset());
                if (target == 0) {
                    RISCV_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (long)type, (String)symbolName, (String)"Failed to locate HI20 relocation for R_RISCV_PCREL_LO12_S", (MessageLog)elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value32 = (target & 0x7F) << 25 | target & 0xF80 | memory.getInt(relocationAddress) & 0x1FFF07F;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 26: {
                value32 = (int)(symbolValue + 2048L & 0xFFFFFFFFFFFFF000L) | memory.getInt(relocationAddress) & 0xFFF;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 27: {
                value32 = (int)(symbolValue & 0xFFFL) << 20 | memory.getInt(relocationAddress) & 0xFFFFF;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 28: {
                value32 = (int)(symbolValue & 0xFFFL);
                value32 = (value32 & 0x1F) << 7 | (value32 & 0xFE0) << 20 | memory.getInt(relocationAddress) & 0x1FFF07F;
                memory.setInt(relocationAddress, value32);
                break;
            }
            case 29: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_HI20", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 30: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_LO12_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 31: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_LO12_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 32: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_ADD", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 33: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 + (byte)(symbolValue + addend));
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 34: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 + (short)(symbolValue + addend));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 35: {
                value32 = memory.getInt(relocationAddress);
                memory.setInt(relocationAddress, value32 += (int)(symbolValue + addend));
                break;
            }
            case 36: {
                value64 = memory.getLong(relocationAddress);
                memory.setLong(relocationAddress, value64 += symbolValue + addend);
                byteLength = 8;
                break;
            }
            case 37: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 - (byte)(symbolValue + addend));
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 38: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 - (short)(symbolValue + addend));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 39: {
                value32 = memory.getInt(relocationAddress);
                memory.setInt(relocationAddress, value32 -= (int)(symbolValue + addend));
                break;
            }
            case 40: {
                value64 = memory.getLong(relocationAddress);
                memory.setLong(relocationAddress, value64 -= symbolValue + addend);
                byteLength = 8;
                break;
            }
            case 41: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GNU_VTINHERIT", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 42: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GNU_VTENTRY", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 43: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_ALIGN", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 44: {
                short target_s = (short)(addend + symbolValue - offset);
                value16 = (short)(RISCV_ElfRelocationHandler.encodeCBTypeImm(target_s) | memory.getShort(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeCBTypeImm(-1));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 45: {
                short target_s = (short)(addend + symbolValue - offset);
                value16 = (short)(RISCV_ElfRelocationHandler.encodeCJTypeImm(target_s) | memory.getShort(relocationAddress) & ~RISCV_ElfRelocationHandler.encodeCJTypeImm(-1));
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case 46: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_RVC_LUI", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 47: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GPREL_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 48: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_GPREL_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 49: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_I", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 50: {
                RISCV_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_RISCV_TPREL_S", (String)symbolName, (long)symbolIndex, (String)"TODO, needs support ", (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case 51: {
                return RelocationResult.SKIPPED;
            }
            case 52: {
                byte loc8 = memory.getByte(relocationAddress);
                value8 = (byte)(symbolValue + addend);
                value8 = (byte)(loc8 & 0xC0 | (loc8 & 0x3F) - value8 & 0x3F);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 53: {
                byte loc8 = memory.getByte(relocationAddress);
                value8 = (byte)(symbolValue + addend);
                value8 = (byte)(loc8 & 0xC0 | value8 & 0x3F);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 54: {
                value8 = (byte)(symbolValue + addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case 55: {
                value16 = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, (short)value8);
                byteLength = 2;
                break;
            }
            case 56: 
            case 57: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, (int)value8);
                break;
            }
            default: {
                RISCV_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private static int getBitField(int val, int shiftRight, int bitSize) {
        return val >> shiftRight & (1 << bitSize) - 1;
    }

    private static int encodeSBTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 4) << 8 | RISCV_ElfRelocationHandler.getBitField(val, 5, 6) << 25 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 7 | RISCV_ElfRelocationHandler.getBitField(val, 12, 1) << 31;
    }

    private static int encodeUJTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 10) << 21 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 20 | RISCV_ElfRelocationHandler.getBitField(val, 12, 8) << 12 | RISCV_ElfRelocationHandler.getBitField(val, 20, 1) << 31;
    }

    private static int encodeCBTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 2) << 3 | RISCV_ElfRelocationHandler.getBitField(val, 3, 2) << 10 | RISCV_ElfRelocationHandler.getBitField(val, 5, 1) << 2 | RISCV_ElfRelocationHandler.getBitField(val, 6, 2) << 5 | RISCV_ElfRelocationHandler.getBitField(val, 8, 1) << 12;
    }

    private static int encodeCJTypeImm(int val) {
        return RISCV_ElfRelocationHandler.getBitField(val, 1, 3) << 3 | RISCV_ElfRelocationHandler.getBitField(val, 4, 1) << 11 | RISCV_ElfRelocationHandler.getBitField(val, 5, 1) << 2 | RISCV_ElfRelocationHandler.getBitField(val, 6, 1) << 7 | RISCV_ElfRelocationHandler.getBitField(val, 7, 1) << 6 | RISCV_ElfRelocationHandler.getBitField(val, 8, 2) << 9 | RISCV_ElfRelocationHandler.getBitField(val, 10, 1) << 8 | RISCV_ElfRelocationHandler.getBitField(val, 11, 1) << 12;
    }
}

