/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.NotFoundException;

public class eBPF_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 247;
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 247) {
            return RelocationResult.FAILURE;
        }
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int type = relocation.getType();
        if (type == 0) {
            return RelocationResult.SKIPPED;
        }
        String section_name = elfRelocationContext.relocationTable.getSectionToBeRelocated().getNameAsString();
        if (section_name.toString().contains("debug")) {
            return RelocationResult.SKIPPED;
        }
        SymbolTable table = program.getSymbolTable();
        int symbolIndex = relocation.getSymbolIndex();
        ElfSymbol symbol = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = symbol.getNameAsString();
        Address symbolAddr = table.getSymbols(symbolName).next().getAddress();
        long new_value = 0L;
        int byteLength = 4;
        try {
            switch (type) {
                case 1: {
                    new_value = symbolAddr.getAddressableWordOffset();
                    Byte dst = memory.getByte(relocationAddress.add(1L));
                    memory.setLong(relocationAddress.add(4L), new_value);
                    memory.setByte(relocationAddress.add(1L), (byte)(dst + 16));
                    break;
                }
                case 10: {
                    long instr_next = relocationAddress.add(8L).getAddressableWordOffset();
                    if (symbol.isFunction()) {
                        new_value = symbolAddr.getAddressableWordOffset();
                        int offset = (int)(new_value - instr_next);
                        memory.setInt(relocationAddress.add(4L), offset);
                        break;
                    }
                    if (symbol.isSection() && memory.getInt(relocationAddress) == 4229) {
                        ElfSectionHeader sectionHeader = elfRelocationContext.getElfHeader().getSection(symbolName);
                        long section_start = program.getImageBase().getOffset() + sectionHeader.getAddress();
                        int current_imm = memory.getInt(relocationAddress.add(4L));
                        int func_sec_offset = (current_imm + 1) * 8;
                        long func_addr = section_start + (long)func_sec_offset;
                        int offset = (int)(func_addr - instr_next);
                        memory.setInt(relocationAddress.add(4L), offset);
                    }
                    break;
                }
                default: {
                    if (symbolIndex == 0) {
                        eBPF_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)Long.toString(type), (String)"applied relocation with symbol-index of 0", (MessageLog)elfRelocationContext.getLog());
                    }
                    return RelocationResult.UNSUPPORTED;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

