/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.signature.BlockSignature;
import ghidra.app.decompiler.signature.CopySignature;
import ghidra.app.decompiler.signature.DebugSignature;
import ghidra.app.decompiler.signature.VarnodeSignature;
import ghidra.bsfv.BSimFeatureType;
import ghidra.bsfv.BSimFeatureVisualizerPlugin;
import ghidra.bsfv.BsfvFeatureColumnObject;
import ghidra.bsfv.BsfvRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class BsfvTableModel
extends AddressBasedTableModel<BsfvRowObject> {
    private BSimFeatureVisualizerPlugin plugin;
    private HighFunction hfunction;
    private Map<SequenceNumber, PcodeOpAST> seqToPcode;
    private Map<Integer, String> blockIndexToCallString;
    private ArrayList<DebugSignature> signatures;
    private Set<PcodeOpAST> featuredOps;
    public static boolean DEBUG = false;

    public BsfvTableModel(BSimFeatureVisualizerPlugin plugin, Program program) {
        super("BSim Feature Visualizer", (ServiceProvider)plugin.getTool(), program, null);
        this.plugin = plugin;
    }

    protected TableColumnDescriptor<BsfvRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addHiddenColumn((DynamicTableColumn)new AddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new OpSequenceNumberTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new BSimFeatureTableColumn(), 2, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new BSimFeatureTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PcodeOpNameTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new BaseVarnodeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new BasicBlockAddressTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PreviousOpInfoTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new BasicBlockIndexColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<BsfvRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.plugin.getCurrentProgram() == null) {
            return;
        }
        Function function = this.plugin.getFunction();
        if (function == null) {
            return;
        }
        if (!this.decompile(function, monitor)) {
            return;
        }
        this.featuredOps = new HashSet<PcodeOpAST>();
        for (int i = 0; i < this.signatures.size(); ++i) {
            int hash = this.signatures.get((int)i).hash;
            SequenceNumber seq = null;
            BSimFeatureType type = null;
            Varnode vn = null;
            PcodeOpAST pcode = null;
            PcodeOpAST previousPcode = null;
            Address basicBlockStart = null;
            Integer blockIndex = null;
            DebugSignature debugSignature = this.signatures.get(i);
            if (debugSignature instanceof VarnodeSignature) {
                VarnodeSignature varSig = (VarnodeSignature)debugSignature;
                seq = varSig.seqNum;
                type = BSimFeatureType.DATA_FLOW;
                vn = varSig.vn;
                pcode = this.seqToPcode.get(varSig.seqNum);
                if (pcode != null && pcode.getParent() != null) {
                    basicBlockStart = ((PcodeOp)pcode.getParent().getIterator().next()).getSeqnum().getTarget();
                    this.featuredOps.add(pcode);
                }
                if (pcode == null) {
                    Msg.info((Object)((Object)this), (Object)("null pcode for feature " + hash + ", op = " + varSig.opcode + ", seq = " + seq));
                } else if (!pcode.getMnemonic().equals(varSig.opcode)) {
                    Msg.info((Object)((Object)this), (Object)("op mis-match at " + seq + ", varSig = " + varSig.opcode + ", pcode = " + pcode.getMnemonic()));
                }
            } else {
                debugSignature = this.signatures.get(i);
                if (debugSignature instanceof CopySignature) {
                    CopySignature copySig = (CopySignature)debugSignature;
                    blockIndex = copySig.index;
                    type = BSimFeatureType.COPY_SIG;
                    basicBlockStart = ((PcodeBlockBasic)this.hfunction.getBasicBlocks().get(blockIndex)).getStart();
                    seq = new SequenceNumber(basicBlockStart, 0);
                } else {
                    BlockSignature blockSig = (BlockSignature)this.signatures.get(i);
                    basicBlockStart = blockSig.blockSeq;
                    blockIndex = blockSig.index;
                    if (blockSig.opSeq == null) {
                        seq = new SequenceNumber(blockSig.blockSeq, 0);
                        type = BSimFeatureType.CONTROL_FLOW;
                        basicBlockStart = blockSig.blockSeq;
                    } else if (blockSig.previousOpSeq == null) {
                        seq = blockSig.opSeq;
                        type = BSimFeatureType.COMBINED;
                        basicBlockStart = blockSig.blockSeq;
                        pcode = this.seqToPcode.get(blockSig.opSeq);
                    } else {
                        seq = blockSig.opSeq;
                        type = BSimFeatureType.DUAL_FLOW;
                        basicBlockStart = blockSig.blockSeq;
                        pcode = this.seqToPcode.get(blockSig.opSeq);
                        previousPcode = this.seqToPcode.get(blockSig.previousOpSeq);
                    }
                }
            }
            accumulator.add((Object)new BsfvRowObject(hash, seq, vn, pcode, previousPcode, type, basicBlockStart, blockIndex));
            if (!DEBUG) continue;
            Msg.debug((Object)((Object)this), (Object)(i + ": " + seq + " " + Integer.toUnsignedString(hash, 16)));
        }
    }

    public Address getAddress(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getAddress();
    }

    public PcodeOpAST getOpAt(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getPcodeOpAST();
    }

    public PcodeOpAST getPreviousOpAt(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getPreviousPcodeOpAST();
    }

    public BSimFeatureType getFeatureTypeAt(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getBSimFeatureType();
    }

    public Integer getBlockIndexAt(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getBlockIndex();
    }

    public Address getBasicBlockStart(int row) {
        return ((BsfvRowObject)this.getRowObject(row)).getBasicBlockStart();
    }

    public HighFunction getHighFunction() {
        return this.hfunction;
    }

    public Set<PcodeOpAST> getFeaturedOps() {
        return Collections.unmodifiableSet(this.featuredOps);
    }

    public String getCallString(int index) {
        return this.blockIndexToCallString.get(index);
    }

    public void reload(Program p) {
        this.setProgram(p);
        this.reload();
    }

    public void setProgram(Program program) {
        if (this.program != program) {
            this.program = program;
            this.clearData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decompile(Function function, TaskMonitor monitor) {
        DecompInterface decompiler = null;
        try {
            decompiler = this.getConfiguredDecompiler();
            if (!decompiler.openProgram(this.plugin.getCurrentProgram())) {
                Msg.info((Object)((Object)this), (Object)"Unable to initalize the Decompiler interface");
                Msg.info((Object)((Object)this), (Object)decompiler.getLastMessage());
                boolean bl = false;
                return bl;
            }
            int decompilerTimeout = this.plugin.getDecompilerTimeout();
            DecompileResults decompRes = decompiler.decompileFunction(function, decompilerTimeout, monitor);
            this.hfunction = decompRes.getHighFunction();
            if (this.hfunction == null) {
                Msg.info((Object)((Object)this), (Object)("null HighFunction for " + function.getName()));
                boolean bl = false;
                return bl;
            }
            this.seqToPcode = new HashMap<SequenceNumber, PcodeOpAST>();
            this.blockIndexToCallString = new HashMap<Integer, String>();
            for (PcodeBlockBasic block : this.hfunction.getBasicBlocks()) {
                StringBuilder sb = new StringBuilder();
                Iterator pcodeOpIter = block.getIterator();
                while (pcodeOpIter.hasNext()) {
                    PcodeOpAST op = (PcodeOpAST)pcodeOpIter.next();
                    this.seqToPcode.put(op.getSeqnum(), op);
                    if (op.getOpcode() != 7 && op.getOpcode() != 8) continue;
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(op.getMnemonic());
                }
                if (sb.length() == 0) {
                    sb.append("(empty)");
                }
                this.blockIndexToCallString.put(block.getIndex(), sb.toString());
            }
            this.signatures = decompiler.debugSignatures(function, decompilerTimeout, null);
            if (this.signatures == null) {
                Msg.info((Object)((Object)this), (Object)("Null sigres for function " + function.getName()));
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (decompiler != null) {
                decompiler.closeProgram();
                decompiler.dispose();
            }
        }
        return true;
    }

    private DecompInterface getConfiguredDecompiler() {
        DecompInterface decompiler = new DecompInterface();
        decompiler.setOptions(new DecompileOptions());
        decompiler.toggleSyntaxTree(true);
        decompiler.setSimplificationStyle("normalize");
        decompiler.setSignatureSettings(this.plugin.getSignatureSettings());
        return decompiler;
    }

    private class AddressTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, Address, Object> {
        private AddressTableColumn() {
        }

        public String getColumnName() {
            return "Address";
        }

        public Address getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getAddress();
        }
    }

    private class OpSequenceNumberTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, SequenceNumber, Object> {
        private OpSequenceNumberTableColumn() {
        }

        public String getColumnName() {
            return "Op Sequence Number";
        }

        public SequenceNumber getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getSeq();
        }
    }

    private class BSimFeatureTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, BsfvFeatureColumnObject, Object> {
        private BSimFeatureTableColumn() {
        }

        public String getColumnName() {
            return "Feature";
        }

        public BsfvFeatureColumnObject getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getFeature();
        }
    }

    private class BSimFeatureTypeTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, String, Object> {
        private BSimFeatureTypeTableColumn() {
        }

        public String getColumnName() {
            return "Feature Type";
        }

        public String getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getBSimFeatureType().toString();
        }
    }

    private class PcodeOpNameTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, String, Object> {
        private PcodeOpNameTableColumn() {
        }

        public String getColumnName() {
            return "Pcode Op Name";
        }

        public String getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getOpMnemonic();
        }
    }

    private class BaseVarnodeTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, String, Object> {
        private BaseVarnodeTableColumn() {
        }

        public String getColumnName() {
            return "Base Varnode";
        }

        public String getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            if (rowObject.getBaseVarnode() != null) {
                return rowObject.getBaseVarnode().toString(BsfvTableModel.this.program.getLanguage());
            }
            return null;
        }
    }

    private class BasicBlockAddressTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, Address, Object> {
        private BasicBlockAddressTableColumn() {
        }

        public String getColumnName() {
            return "Basic Block Start";
        }

        public Address getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getBasicBlockStart();
        }
    }

    private class PreviousOpInfoTableColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, String, Object> {
        private PreviousOpInfoTableColumn() {
        }

        public String getColumnName() {
            return "Previous Op Info";
        }

        public String getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            PcodeOpAST prev = rowObject.getPreviousPcodeOpAST();
            if (prev == null) {
                return null;
            }
            return prev.getMnemonic() + ": " + prev.getSeqnum().toString();
        }
    }

    private class BasicBlockIndexColumn
    extends AbstractDynamicTableColumn<BsfvRowObject, Integer, Object> {
        private BasicBlockIndexColumn() {
        }

        public String getColumnName() {
            return "Block Index";
        }

        public Integer getValue(BsfvRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getBlockIndex();
        }
    }
}

