/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.KeyEntryDialog;
import docking.actions.ToolActions;
import ghidra.util.Msg;
import java.awt.Component;

public class KeyBindingAction
extends DockingAction {
    public static String NAME = "Set KeyBinding";
    private ToolActions toolActions;

    public KeyBindingAction(ToolActions toolActions) {
        super(NAME, "DockingWindows");
        this.toolActions = toolActions;
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
        if (windowManager == null) {
            return;
        }
        DockingActionIf action = DockingWindowManager.getMouseOverAction();
        if (action == null) {
            return;
        }
        if (!(action = this.maybeGetToolLevelAction(action)).getKeyBindingType().supportsKeyBindings()) {
            Component parent = windowManager.getActiveComponent();
            Msg.showInfo(this.getClass(), (Component)parent, (String)"Unable to Set Keybinding", (Object)("Action \"" + this.getActionName(action) + "\" does not support key bindings"));
            return;
        }
        KeyEntryDialog d = new KeyEntryDialog(action, this.toolActions);
        DockingWindowManager.showDialog(d);
    }

    private DockingActionIf maybeGetToolLevelAction(DockingActionIf dockingAction) {
        String actionName;
        DockingActionIf sharedAction;
        if (dockingAction.getKeyBindingType().isShared() && (sharedAction = this.toolActions.getSharedStubKeyBindingAction(actionName = dockingAction.getName())) != null) {
            return sharedAction;
        }
        return dockingAction;
    }

    private String getActionName(DockingActionIf action) {
        MenuData popupMenuData = action.getPopupMenuData();
        if (popupMenuData != null) {
            return popupMenuData.getMenuItemName();
        }
        MenuData menuBarData = action.getMenuBarData();
        if (menuBarData != null) {
            return menuBarData.getMenuItemName();
        }
        return action.getName();
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }
}

